/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.freemark;

import com.ejianc.foundation.cust.freemark.IFreemarkerEngine;
import com.ejianc.framework.core.exception.BusinessException;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FreemarkerEngine
implements IFreemarkerEngine {
    private Configuration formTemplateConfig;
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());

    public Configuration getFormTemplateConfiguration() {
        try {
            if (this.formTemplateConfig == null) {
                this.formTemplateConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
                this.formTemplateConfig.setDefaultEncoding("UTF-8");
                this.formTemplateConfig.setClassForTemplateLoading(FreemarkerEngine.class, "/templates");
            }
            return this.formTemplateConfig;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public String genFormByTemplateName(String templateName, Object model) {
        try {
            Template template = this.getFormTemplateConfiguration().getTemplate(templateName);
            StringWriter writer = new StringWriter();
            template.process(model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public String parseByString(String templateSource, Object model) {
        try {
            Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            StringTemplateLoader loader = new StringTemplateLoader();
            cfg.setTemplateLoader((TemplateLoader)loader);
            cfg.setClassicCompatible(true);
            loader.putTemplate("freemaker", templateSource);
            Template template = cfg.getTemplate("freemaker");
            StringWriter writer = new StringWriter();
            template.process(model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            this.LOG.error(String.format("freemaker\u6a21\u677f\u3010%s\u3011\u89e3\u6790\u5931\u8d25\uff1a%s", templateSource, e.getMessage()));
            throw new BusinessException(String.format("freemaker\u6a21\u677f\u3010%s\u3011\u89e3\u6790\u5931\u8d25", templateSource), (Throwable)e);
        }
    }
}

