/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessColumnCtrlEntity;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.mapper.BusinessColumnCtrlMapper;
import com.ejianc.foundation.cust.mapper.BusinessColumnMapper;
import com.ejianc.foundation.cust.mapper.BusinessTableMapper;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusinessTableCacheUtil;
import com.ejianc.foundation.cust.util.TableOperator;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessTableServiceImpl
extends BaseServiceImpl<BusinessTableMapper, BusinessTableEntity>
implements IBusinessTableService {
    @Autowired
    private BusinessTableMapper businessTableMapper;
    @Autowired
    private BusinessColumnMapper businessColumnMapper;
    @Autowired
    private BusinessColumnCtrlMapper businessColumnCtrlMapper;

    private String generateKey() {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        return Utils.randString((int)3).toLowerCase() + format.format(new Date());
    }

    @Override
    public void saveBusinessTable(BusinessTableEntity businessTableEntity) {
        TableOperator tableOperate = new TableOperator(this.businessTableMapper, businessTableEntity);
        if (businessTableEntity.getId() != null && businessTableEntity.getId() > 0L) {
            BusinessTableEntity uniqueBean = (BusinessTableEntity)((Object)this.businessTableMapper.selectById(businessTableEntity.getId()));
            uniqueBean.setName(businessTableEntity.getName());
            uniqueBean.setComment(businessTableEntity.getComment());
            uniqueBean.setGroupId(businessTableEntity.getGroupId());
            uniqueBean.setGroupName(businessTableEntity.getGroupName());
            this.businessTableMapper.updateById((Object)uniqueBean);
            this.businessColumnCtrlMapper.removeByTableId(businessTableEntity.getId());
            this.businessColumnMapper.removeByTableId(businessTableEntity.getId());
        } else {
            if (tableOperate.isTableCreated()) {
                throw new BusinessException("\u8868[" + businessTableEntity.getName() + "]\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u5e93\u4e2d");
            }
            businessTableEntity.setId(IdWorker.getId());
            businessTableEntity.setUniqueKey(this.generateKey());
            this.businessTableMapper.insert((Object)businessTableEntity);
        }
        for (BusinessColumnEntity businessColumn : businessTableEntity.getColumns()) {
            if (businessColumn.getId() == null) {
                businessColumn.setId(IdWorker.getId());
            }
            businessColumn.setUniqueKey(this.generateKey());
            businessColumn.setTableId(businessTableEntity.getId());
            this.businessColumnMapper.insert((Object)businessColumn);
            if (1 == businessColumn.getPrimary()) continue;
            BusinessColumnCtrlEntity ctrl = businessColumn.getCtrl();
            if (ctrl == null) {
                throw new BusinessException("\u5b57\u6bb5\u5fc5\u987b\u914d\u7f6e\u63a7\u4ef6\uff01");
            }
            if (ctrl.getId() == null) {
                ctrl.setId(IdWorker.getId());
            }
            ctrl.setColumnId(businessColumn.getId());
            this.businessColumnCtrlMapper.insert((Object)ctrl);
        }
        tableOperate.syncColumn();
        BusinessTableCacheUtil.put(businessTableEntity);
    }

    @Override
    public BusinessTableEntity getFilledByKey(String uniqueKey) {
        BusinessTableEntity businessTable = BusinessTableCacheUtil.get(uniqueKey);
        if (businessTable != null) {
            return businessTable;
        }
        businessTable = this.getByKey(uniqueKey);
        this.fill(businessTable);
        BusinessTableCacheUtil.put(businessTable);
        return businessTable;
    }

    private void fill(BusinessTableEntity businessTable) {
        if (businessTable == null) {
            return;
        }
        QueryWrapper columnWrapper = new QueryWrapper();
        columnWrapper.eq((Object)"table_id", (Object)businessTable.getId());
        List columns = this.businessColumnMapper.selectList((Wrapper)columnWrapper);
        for (BusinessColumnEntity column : columns) {
            QueryWrapper ctrlQueryWrapper = new QueryWrapper();
            ctrlQueryWrapper.eq((Object)"column_id", (Object)column.getId());
            BusinessColumnCtrlEntity businessColumnCtrlEntity = (BusinessColumnCtrlEntity)((Object)this.businessColumnCtrlMapper.selectOne((Wrapper)ctrlQueryWrapper));
            column.setCtrl(businessColumnCtrlEntity);
            column.setTable(businessTable);
        }
        businessTable.setColumns(columns);
        TableOperator tableOperator = new TableOperator(this.businessTableMapper, businessTable);
        businessTable.setCreatedTable(tableOperator.isTableCreated());
    }

    private BusinessTableEntity getByKey(String uniqueKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unique_key", (Object)uniqueKey);
        BusinessTableEntity businessTable = (BusinessTableEntity)((Object)this.businessTableMapper.selectOne((Wrapper)queryWrapper));
        return businessTable;
    }

    @Override
    public void removeTableByPkId(String tableId) {
        this.businessColumnMapper.removeByTableId(Long.parseLong(tableId));
        this.businessColumnCtrlMapper.removeByTableId(Long.parseLong(tableId));
        this.businessTableMapper.removeTableByPkId(tableId);
    }
}

