/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.util;

import cn.hutool.core.util.ArrayUtil;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AppUtil
implements ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AppUtil.class);
    private static ApplicationContext context;
    private static String currentProfiles;

    public void setApplicationContext(ApplicationContext _context) throws BeansException {
        context = _context;
    }

    public static ApplicationContext getApplicaitonContext() {
        return context;
    }

    public static Object getBean(String beanId) {
        try {
            return context.getBean(beanId);
        }
        catch (Exception ex) {
            LOGGER.debug("getBean:" + beanId + "," + ex.getMessage());
            return null;
        }
    }

    public static <T> T getBean(Class<T> beanClass) {
        try {
            return (T)context.getBean(beanClass);
        }
        catch (Exception ex) {
            LOGGER.debug("getBean:" + beanClass + "," + ex.getMessage());
            return null;
        }
    }

    public static <T> Map<String, T> getImplInstance(Class<T> clazz) {
        return context.getBeansOfType(clazz);
    }

    public static <T> List<T> getImplInstanceArray(Class<T> clazz) {
        ArrayList list = new ArrayList();
        Map map = context.getBeansOfType(clazz);
        for (Object t : map.values()) {
            list.add(t);
        }
        return list;
    }

    public static void publishEvent(ApplicationEvent event) {
        if (context != null) {
            context.publishEvent(event);
        }
    }

    public static String getCtxEnvironment() {
        if (currentProfiles != null) {
            return currentProfiles;
        }
        Environment environment = context.getEnvironment();
        Object[] activeProfiles = environment.getActiveProfiles();
        if (ArrayUtil.isNotEmpty((Object[])activeProfiles)) {
            currentProfiles = activeProfiles[0];
            return currentProfiles;
        }
        Object[] defaultProfiles = environment.getDefaultProfiles();
        if (ArrayUtil.isNotEmpty((Object[])defaultProfiles)) {
            currentProfiles = defaultProfiles[0];
            return defaultProfiles[0];
        }
        throw new BusinessException("\u67e5\u627e\u4e0d\u5230\u6b63\u786e\u7684\u73af\u5883\u5c5e\u6027\u914d\u7f6e\uff01");
    }

    static {
        currentProfiles = null;
    }
}

