/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessFormdefEntity;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.bean.FormType;
import com.ejianc.foundation.cust.bean.model.FormGroup;
import com.ejianc.foundation.cust.bean.model.FormOverallArrangement;
import com.ejianc.foundation.cust.bean.model.FormTab;
import com.ejianc.foundation.cust.freemark.IFreemarkerEngine;
import com.ejianc.foundation.cust.generator.AbsFormElementGenerator;
import com.ejianc.foundation.cust.mapper.BusinessFormdefMapper;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.foundation.cust.util.AppUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessFormdefServiceImpl
extends BaseServiceImpl<BusinessFormdefMapper, BusinessFormdefEntity>
implements IBusinessFormdefService {
    @Autowired
    private BusinessFormdefMapper businessFormdefMapper;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IFormTemplateService formTemplateService;
    @Autowired
    IFreemarkerEngine freemarkEngine;

    @Override
    public void removeBusinessFormdefById(String formdefId) {
        this.businessFormdefMapper.removeBusinessFormdefById(formdefId);
    }

    @Override
    public String generateFormHtml(String boKey, JSONArray templateConfig, String formType) {
        String boDesign = this.businessObjectService.getOverallArrangementByCode(boKey);
        if (StringUtils.isNotBlank((String)boDesign)) {
            if (FormType.PC_IVIEW.value().equals(formType)) {
                return this.generateIviewOverallArrangementFormHtml(boDesign, boKey, templateConfig);
            }
            return this.generateVueOverallArrangementFormHtml(boDesign, boKey, templateConfig);
        }
        BusinessObjectEntity businessObject = this.businessObjectService.getFilledByKey(boKey);
        StringBuilder sb = new StringBuilder();
        for (Object object : templateConfig) {
            JSONObject jsonObject = (JSONObject)object;
            String templateKey = jsonObject.getString("templateKey");
            BusinessTableRel relation = businessObject.getRelation().find(jsonObject.getString("tableKey"));
            QueryWrapper templateWrapper = new QueryWrapper();
            templateWrapper.eq((Object)"unique_key", (Object)templateKey);
            FormTemplateEntity template = (FormTemplateEntity)((Object)this.formTemplateService.getOne((Wrapper)templateWrapper));
            if (template == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("relation", relation);
            for (AbsFormElementGenerator generator : AppUtil.getImplInstanceArray(AbsFormElementGenerator.class)) {
                map.put(generator.getGeneratorName(), generator);
            }
            String html = this.freemarkEngine.parseByString(template.getHtml(), map);
            sb.append(html);
        }
        if (sb.length() > 0) {
            sb.insert(0, "<div class=\"ivu-form ivu-form-label-right\">");
            sb.append("</div>");
        }
        return sb.toString();
    }

    private String generateIviewOverallArrangementFormHtml(String boDesign, String boKey, JSONArray templateConfig) {
        FormOverallArrangement formDesign = (FormOverallArrangement)JSON.toJavaObject((JSON)JSON.parseObject((String)boDesign), FormOverallArrangement.class);
        BusinessObjectEntity businessObject = this.businessObjectService.getFilledByKey(boKey);
        StringBuffer html = new StringBuffer();
        if (CollectionUtil.isNotEmpty(formDesign.getTabList())) {
            html.append("<Tabs>");
            formDesign.getTabList().forEach(tab -> {
                html.append(" <tab-pane label=\"").append(tab.getComment()).append("\">");
                html.append(this.generateGroupsHtml(tab.getGroupList(), businessObject, templateConfig));
                html.append("</tab-pane> ");
            });
            html.append("</Tabs>");
        } else {
            html.append(this.generateGroupsHtml(formDesign.getGroupList(), businessObject, templateConfig));
        }
        if (html.length() > 0) {
            html.insert(0, "<div class=\"ivu-form ivu-form-label-right\"><script>\n    window.custFormComponentMixin ={\n        data: function () {\n            return {\"test\":\"helloWorld\"};\n        },\n        created:function(){\n            console.log(\"\u811a\u672c\u5c06\u4f1a\u6df7\u5165\u81ea\u5b9a\u4e49\u8868\u5355\u7ec4\u4ef6\u4e2d...\");\n        },methods:{\n            testaaa:function(){alert(1)}\n        }\n    }\n</script>");
            html.append("</div>");
        }
        return html.toString();
    }

    private String generateVueOverallArrangementFormHtml(String boDesign, String boKey, JSONArray templateConfig) {
        FormOverallArrangement formDesign = (FormOverallArrangement)JSON.toJavaObject((JSON)JSON.parseObject((String)boDesign), FormOverallArrangement.class);
        BusinessObjectEntity businessObject = this.businessObjectService.getFilledByKey(boKey);
        StringBuffer html = new StringBuffer();
        if (CollectionUtil.isNotEmpty(formDesign.getTabList())) {
            html.append("<ul class=\"nav nav-tabs\">");
            boolean isFirst = true;
            for (FormTab tab : formDesign.getTabList()) {
                html.append(String.format("<li %s ><a href=\"#%s\"  data-toggle=\"tab\" >%s</a></li>", isFirst ? "class=\"active\"" : "", tab.getComment(), tab.getComment()));
                isFirst = false;
            }
            html.append("</ul> ");
            isFirst = true;
            html.append("<div class=\"tab-content\">");
            for (FormTab tab : formDesign.getTabList()) {
                html.append("<div class=\"tab-pane ").append(isFirst ? "active" : "").append("\" id=\"").append(tab.getComment()).append("\">").append(this.generateGroupsHtml(tab.getGroupList(), businessObject, templateConfig)).append("</div>");
                isFirst = false;
            }
            html.append("</div>");
        } else {
            html.append(this.generateGroupsHtml(formDesign.getGroupList(), businessObject, templateConfig));
        }
        if (html.length() > 0) {
            html.insert(0, "<div class=\"ivu-form ivu-form-label-right\"><script>\n    window.custFormComponentMixin ={\n        data: function () {\n            return {\"test\":\"helloWorld\"};\n        },\n        created:function(){\n            console.log(\"\u811a\u672c\u5c06\u4f1a\u6df7\u5165\u81ea\u5b9a\u4e49\u8868\u5355\u7ec4\u4ef6\u4e2d...\");\n        },methods:{\n            testaaa:function(){alert(1)}\n        }\n    }\n</script>");
            html.append("</div>");
        }
        return html.toString();
    }

    private String generateGroupsHtml(List<FormGroup> groupList, BusinessObjectEntity businessObject, JSONArray templateConfig) {
        StringBuilder groupHtml = new StringBuilder();
        groupList.forEach(group -> {
            String tableKey = group.getKey();
            String templateKey = this.getTemplateKey(templateConfig, tableKey);
            BusinessTableRel relation = businessObject.getRelation().find(tableKey);
            QueryWrapper templateWrapper = new QueryWrapper();
            templateWrapper.eq((Object)"unique_key", (Object)templateKey);
            FormTemplateEntity template = (FormTemplateEntity)((Object)((Object)this.formTemplateService.getOne((Wrapper)templateWrapper)));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("relation", relation);
            group.setTableRelation(relation);
            map.put("group", group);
            for (AbsFormElementGenerator generator : AppUtil.getImplInstanceArray(AbsFormElementGenerator.class)) {
                map.put(generator.getGeneratorName(), generator);
            }
            String html = this.freemarkEngine.parseByString(template.getHtml(), map);
            groupHtml.append(html);
        });
        return groupHtml.toString();
    }

    private String getTemplateKey(JSONArray templateConfig, String tableKey) {
        for (Object object : templateConfig) {
            JSONObject jsonObject = (JSONObject)object;
            if (!jsonObject.getString("tableKey").equals(tableKey)) continue;
            return jsonObject.getString("templateKey");
        }
        throw new BusinessException("tableKey :" + tableKey + "\u5c1a\u672a\u9009\u62e9\u6a21\u677f\uff0c\u8bf7\u9009\u62e9\u6a21\u677f\u540e\u751f\u6210\u8868\u5355");
    }

    @Override
    public BusinessFormdefEntity getByKey(String uniqueKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unique_key", (Object)uniqueKey);
        BusinessFormdefEntity resultBean = (BusinessFormdefEntity)((Object)this.businessFormdefMapper.selectOne((Wrapper)queryWrapper));
        return resultBean;
    }

    private String generateKey() {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        return Utils.randString((int)3).toLowerCase() + format.format(new Date());
    }

    @Override
    public void saveFormDef(BusinessFormdefEntity businessFormdefEntity) {
        if (businessFormdefEntity.getId() != null && businessFormdefEntity.getId() > 0L) {
            BusinessFormdefEntity uniqueBean = (BusinessFormdefEntity)((Object)this.businessFormdefMapper.selectById(businessFormdefEntity.getId()));
            uniqueBean.setType(businessFormdefEntity.getType());
            uniqueBean.setName(businessFormdefEntity.getName());
            uniqueBean.setDescription(businessFormdefEntity.getDescription());
            uniqueBean.setGroupId(businessFormdefEntity.getGroupId());
            uniqueBean.setGroupName(businessFormdefEntity.getGroupName());
            uniqueBean.setBoKey(businessFormdefEntity.getBoKey());
            uniqueBean.setBoName(businessFormdefEntity.getBoName());
            uniqueBean.setHtml(businessFormdefEntity.getHtml());
            this.businessFormdefMapper.updateById((Object)uniqueBean);
        } else {
            businessFormdefEntity.setUniqueKey(this.generateKey());
            this.businessFormdefMapper.insert((Object)businessFormdefEntity);
        }
    }
}

