/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.util;

import com.ejianc.foundation.cust.util.AppUtil;
import com.ejianc.foundation.cust.util.GroovyBinding;
import com.ejianc.foundation.cust.util.IGroovyScriptEngine;
import com.ejianc.foundation.cust.util.IScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class GroovyScriptEngine
implements IGroovyScriptEngine,
ApplicationListener<ContextRefreshedEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GroovyBinding groovyBinding = new GroovyBinding();

    @Override
    public void execute(String script) {
        this.executeObject(script, null);
    }

    @Override
    public void execute(String script, Map<String, Object> vars) {
        this.executeObject(script, vars);
    }

    @Override
    public boolean executeBoolean(String script, Map<String, Object> vars) {
        return (Boolean)this.executeObject(script, vars);
    }

    @Override
    public String executeString(String script, Map<String, Object> vars) {
        return (String)this.executeObject(script, vars);
    }

    @Override
    public int executeInt(String script, Map<String, Object> vars) {
        return (Integer)this.executeObject(script, vars);
    }

    @Override
    public float executeFloat(String script, Map<String, Object> vars) {
        return ((Float)this.executeObject(script, vars)).floatValue();
    }

    @Override
    public Object executeObject(String script, Map<String, Object> vars) {
        this.groovyBinding.setThreadVariables(vars);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6267\u884c:{}", (Object)script);
            this.logger.debug("variables:{}", (Object)(vars + ""));
        }
        GroovyShell shell = new GroovyShell((Binding)this.groovyBinding);
        script = script.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&nuot;", "\n").replace("&amp;", "&");
        Object rtn = shell.evaluate(script);
        return rtn;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            Map<String, IScript> scirptImpls = AppUtil.getImplInstance(IScript.class);
            for (Map.Entry<String, IScript> scriptMap : scirptImpls.entrySet()) {
                this.groovyBinding.setProperty(scriptMap.getKey(), scriptMap.getValue());
            }
        }
    }
}

