/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomDataEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomDataService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ExcelExportUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/table"})
public class CustomTableMongoController
implements Serializable {
    private static final long serialVersionUID = 8717661796833595475L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String DEL = "del";
    private static final String PID = "pid";
    private static final String ORG_ID = "orgId";
    private static final String CREATE_USER = "createUser";
    private static final String CREATE_TIME = "createTime";
    private static final String BILL_STATE = "billState";
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ICustomDataService iCustomDataService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private MongodbCrudTemplate mongoTemplate;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/{pageCode}/save"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> save(@PathVariable String pageCode, @RequestBody JSONObject saveData) throws IOException {
        if (StringUtils.isBlank((CharSequence)pageCode)) {
            this.logger.error("\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return CommonResponse.error((String)"\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if (saveData != null) {
            if (mainColumnEntities != null && mainColumnEntities.size() > 0) {
                for (CustomColumnEntity col : mainColumnEntities) {
                    String v;
                    if (col.getUniqued() == null || !col.getUniqued().booleanValue() || !StringUtils.isNotEmpty((CharSequence)(v = saveData.getString(col.getProperty())))) continue;
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put(col.getProperty(), new Parameter("eq", (Object)v));
                    IPage<JSONObject> pages = this.getPageListData(app, queryParam, InvocationInfoProxy.getOrgId());
                    if (StringUtils.isBlank((CharSequence)saveData.getString(ID))) {
                        if (pages.getTotal() <= 0L) continue;
                        return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                    }
                    if (pages.getTotal() > 1L) {
                        return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                    }
                    if (pages.getTotal() != 1L || saveData.getString(ID).equals(((JSONObject)pages.getRecords().get(0)).getString(ID))) continue;
                    return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                }
                for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                    if (ID.equals(customColumnEntity.getProperty())) {
                        String value = saveData.getString(customColumnEntity.getProperty());
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            saveData.put(customColumnEntity.getProperty(), (Object)saveData.getString(customColumnEntity.getProperty()));
                            continue;
                        }
                        saveData.remove((Object)customColumnEntity.getProperty());
                        continue;
                    }
                    if ("refer".equals(customColumnEntity.getType())) {
                        if (saveData.getJSONObject(customColumnEntity.getProperty()) == null) continue;
                        saveData.put(customColumnEntity.getProperty(), (Object)saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
                        continue;
                    }
                    if ("date".equals(customColumnEntity.getType())) {
                        JSONObject col;
                        if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                        Object dateString = saveData.getString(customColumnEntity.getProperty());
                        String val = customColumnEntity.getVal();
                        if (StringUtils.isNotEmpty((CharSequence)val) && StringUtils.isNotEmpty((CharSequence)(col = JSONObject.parseObject((String)val)).getString("format")) && col.getString("format").length() != ((String)dateString).length()) {
                            if (((String)dateString).length() == 10 && col.getString("format").length() == 19) {
                                dateString = (String)dateString + " 00:00:00";
                            }
                            if (((String)dateString).length() == 19 && col.getString("format").length() == 10) {
                                dateString = ((String)dateString).substring(0, 10);
                            }
                        }
                        saveData.put(customColumnEntity.getProperty(), dateString);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                    saveData.put(customColumnEntity.getProperty(), (Object)saveData.getString(customColumnEntity.getProperty()));
                }
            }
            Long mainPkId = 0L;
            if (!saveData.containsKey((Object)ID)) {
                mainPkId = IdWorker.getId();
                saveData.put(ID, (Object)(mainPkId + ""));
                saveData.put(ORG_ID, (Object)(InvocationInfoProxy.getOrgId() + ""));
                saveData.put(BILL_STATE, (Object)0);
                saveData.put(CREATE_USER, (Object)(InvocationInfoProxy.getUserid() + ""));
            } else {
                mainPkId = saveData.getLong(ID);
                saveData.put(BILL_STATE, (Object)Integer.parseInt(saveData.getString(BILL_STATE)));
            }
            List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (ListUtil.isNotEmpty(childTableEntities)) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    List<CustomColumnEntity> childColumnEntities = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                    if (!ListUtil.isNotEmpty(childColumnEntities)) continue;
                    JSONArray childDatas = saveData.getJSONArray(childTableEntity.getUiKey());
                    JSONArray saveChildData = new JSONArray();
                    if (ListUtil.isNotEmpty((List)childDatas)) {
                        for (int i = 0; i < childDatas.size(); ++i) {
                            Long childPkId;
                            JSONObject childData = childDatas.getJSONObject(i);
                            childData.put("rowIndex", (Object)i);
                            String rowState = childData.getString("rowState");
                            if (DEL.equals(rowState) && StringUtils.isNotEmpty((CharSequence)childData.getString(ID))) continue;
                            for (CustomColumnEntity childColumnEntity : childColumnEntities) {
                                if (ID.equals(childColumnEntity.getProperty())) {
                                    String value = childData.getString(childColumnEntity.getProperty());
                                    if (StringUtils.isNotBlank((CharSequence)value)) {
                                        childData.put(childColumnEntity.getProperty(), (Object)childData.getString(childColumnEntity.getProperty()));
                                        continue;
                                    }
                                    childData.remove((Object)childColumnEntity.getProperty());
                                    continue;
                                }
                                if ("refer".equals(childColumnEntity.getType())) {
                                    if (saveData.getJSONObject(childColumnEntity.getProperty()) == null) continue;
                                    saveData.put(childColumnEntity.getProperty(), (Object)saveData.getJSONObject(childColumnEntity.getProperty()).toJSONString());
                                    continue;
                                }
                                if ("date".equals(childColumnEntity.getType())) {
                                    JSONObject col;
                                    if (!StringUtils.isNotEmpty((CharSequence)childData.getString(childColumnEntity.getProperty()))) continue;
                                    String dateString = childData.getString(childColumnEntity.getProperty());
                                    String val = childColumnEntity.getVal();
                                    if (StringUtils.isNotEmpty((CharSequence)val) && StringUtils.isNotEmpty((CharSequence)(col = JSONObject.parseObject((String)val)).getString("format")) && col.getString("format").length() != dateString.length()) {
                                        if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                            dateString = dateString + " 00:00:00";
                                        }
                                        if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                            dateString = dateString.substring(0, 10);
                                        }
                                    }
                                    childData.put(childColumnEntity.getProperty(), (Object)dateString);
                                    continue;
                                }
                                childData.put(childColumnEntity.getProperty(), (Object)childData.getString(childColumnEntity.getProperty()));
                            }
                            this.logger.info("childData i={},\u6570\u636e\uff1a{}", (Object)i, (Object)JSONObject.toJSONString((Object)childData));
                            if (childData.containsKey((Object)ID)) {
                                childPkId = childData.getLong(ID);
                            } else {
                                childPkId = IdWorker.getId();
                                childData.put(ID, (Object)(childPkId + ""));
                                childData.put(PID, (Object)(mainPkId + ""));
                                childData.put(CREATE_USER, (Object)(InvocationInfoProxy.getUserid() + ""));
                                childData.put(CREATE_TIME, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                childData.put("rowState", null);
                            }
                            ArrayList<Long> attachIds = new ArrayList<Long>();
                            JSONArray array = childData.getJSONArray("attachIds");
                            if (array != null && array.size() > 0) {
                                for (int j = 0; j < array.size(); ++j) {
                                    Long attrId = array.getLong(j);
                                    attachIds.add(attrId);
                                }
                            }
                            this.logger.info("\u5904\u7406\u5b50\u8868\u9644\u4ef6 attachIds----{}", (Object)JSONObject.toJSONString(attachIds));
                            if (ListUtil.isNotEmpty(attachIds)) {
                                CommonResponse res = this.attachmentApi.updateAttachRef(childPkId, attachIds);
                                this.logger.info("\u5904\u7406\u5b50\u8868\u9644\u4ef6 attachIds----CommonResponse {}", (Object)JSONObject.toJSONString((Object)res));
                            }
                            saveChildData.add((Object)childData);
                        }
                    }
                    saveData.put(childTableEntity.getUiKey(), (Object)saveChildData);
                }
            }
            ArrayList<Long> attachIds = new ArrayList<Long>();
            JSONArray array = saveData.getJSONArray("attachIds");
            if (array != null && array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    Long attrId = array.getLong(i);
                    attachIds.add(attrId);
                }
            }
            this.logger.info("attachIds----{}", (Object)JSONObject.toJSONString(attachIds));
            if (ListUtil.isNotEmpty(attachIds)) {
                CommonResponse res = this.attachmentApi.updateAttachRef(mainPkId, attachIds);
                this.logger.info("attachIds----CommonResponse {}", (Object)JSONObject.toJSONString((Object)res));
            }
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter("eq", (Object)mainPkId));
            List dataEntityList = this.iCustomDataService.queryList(dataParam, false);
            CustomDataEntity customDataEntity = null;
            if (ListUtil.isEmpty((List)dataEntityList)) {
                customDataEntity = new CustomDataEntity();
                customDataEntity.setMainId(mainPkId);
                customDataEntity.setAppCode(pageCode);
            } else {
                customDataEntity = (CustomDataEntity)((Object)dataEntityList.get(0));
            }
            customDataEntity.setData(saveData.toJSONString());
            this.mongoTemplate.insertOrUpdate(saveData, mainTableEntity.getTableName());
            this.iCustomDataService.saveOrUpdate((Object)customDataEntity, false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)saveData);
    }

    public static void main(String[] args) {
        String s = "2023-01-05 00:00:00";
        System.out.println(s.substring(0, 10));
    }

    @RequestMapping(value={"/{pageCode}/pageList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<JSONObject>> pageList(@PathVariable String pageCode, @RequestBody QueryParam queryParam) {
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        return CommonResponse.success(this.getPageListData(app, queryParam, orgId));
    }

    @RequestMapping(value={"/{pageCode}/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void export(@PathVariable String pageCode, @RequestBody QueryParam queryParam, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        IPage<JSONObject> pageData = this.getPageListData(app, queryParam, orgId);
        ExcelExportUtil excelExport = new ExcelExportUtil();
        List<JSONObject> res = this.getExportData(pageData.getRecords(), app.getId());
        if (ListUtil.isEmpty(res)) {
            return;
        }
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        excelExport.setData(res);
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> titleList = new ArrayList<String>();
        QueryParam param = new QueryParam();
        param.getParams().put("customTableId", new Parameter("eq", (Object)mainTableEntity.getId()));
        List list = this.customColumnService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            for (CustomColumnEntity customListEntity : list) {
                if (Objects.equals(customListEntity.getProperty(), CREATE_USER) || Objects.equals(customListEntity.getProperty(), ORG_ID) || Objects.equals(customListEntity.getProperty(), ID)) continue;
                properties.add(customListEntity.getProperty());
                titleList.add(customListEntity.getColumnName());
            }
        }
        if (properties.size() > 0) {
            excelExport.setHeardKey(properties.toArray(new String[properties.size()]));
            excelExport.setFontSize(12);
            excelExport.setSheetName(app.getAppName());
            excelExport.setTitle(app.getAppName());
            excelExport.setHeardList(titleList.toArray(new String[titleList.size()]));
            excelExport.exportExport(response);
        }
    }

    private List<JSONObject> getExportData(List<JSONObject> list, Long appId) {
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(appId);
        List<CustomColumnEntity> mainCols = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if (ListUtil.isNotEmpty(list)) {
            for (JSONObject mainDetail : list) {
                for (CustomColumnEntity col : mainCols) {
                    String[] stringArray;
                    if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("name"));
                    }
                    if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("text"));
                    }
                    if (BILL_STATE.equals(col.getProperty()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode((Integer)mainDetail.getInteger(col.getProperty())).getDescription());
                    }
                    if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
                    if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                        stringArray = col.getVal().split(",");
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "\u662f";
                        stringArray = stringArray2;
                        stringArray2[1] = "\u5426";
                    }
                    String[] names = stringArray;
                    if ("1".equals(mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)names[0]);
                        continue;
                    }
                    mainDetail.put(col.getProperty(), (Object)names[1]);
                }
                res.add(mainDetail);
            }
        }
        return res;
    }

    private IPage<JSONObject> getPageListData(CustomAppEntity app, QueryParam queryParam, Long orgId) {
        CustomTableEntity mainTableEntity;
        List<CustomColumnEntity> mainCols;
        if (app.getQueryRange() == 0 || app.getQueryRange() == 1 && queryParam.getParams().get(CREATE_USER) == null) {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isEmpty((CharSequence)authOrgIds)) {
                queryParam.getParams().put(ORG_ID, new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList())));
            }
            this.logger.info("\u672c\u4e0b\u67e5\u8be2\u6761\u4ef6\uff1aauthOrgIds={},InvocationInfoProxy.getOrgId()={},orgId={}", new Object[]{authOrgIds, InvocationInfoProxy.getOrgId(), queryParam.getParams().get(ORG_ID)});
        }
        if (ListUtil.isNotEmpty(mainCols = this.customColumnService.queryColumnsByTableId((mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId())).getId()))) {
            for (CustomColumnEntity col : mainCols) {
                if (!col.getType().equals("string") && !col.getType().equals("refer") && !col.getType().equals("select")) continue;
                queryParam.getFuzzyFields().add(col.getProperty());
            }
        }
        queryParam.getOrderMap().put(CREATE_TIME, "desc");
        IPage page = this.mongoTemplate.queryPage(queryParam, mainTableEntity.getTableName());
        return page;
    }

    @PostMapping(value={"/pageList/{appId}"})
    public CommonResponse<JSONObject> pageListByAppId(@PathVariable Long appId, @RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        JSONObject appJson = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = (CustomAppEntity)((Object)this.customAppService.selectById(appId));
        if (null == app) {
            return CommonResponse.error((String)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5e94\u7528\u6570\u636e\u5931\u8d25\uff0c\u65e0\u5339\u914d\u7684\u5e94\u7528\u4fe1\u606f\uff01");
        }
        IPage<JSONObject> page = this.getPageListData(app, queryParam, orgId);
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
            List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
            page.getRecords().forEach(o -> mainColumnEntities.forEach(col -> {
                if (("refer".equals(col.getType()) || "select".equals(col.getType())) && o.get((Object)col.getProperty()) != null) {
                    JSONObject data = JSONObject.parseObject((String)o.getString(col.getProperty()));
                    if (StringUtils.isNotEmpty((CharSequence)data.getString("name"))) {
                        o.put(col.getProperty(), (Object)data.getString("name"));
                    } else if (StringUtils.isNotEmpty((CharSequence)data.getString("text"))) {
                        o.put(col.getProperty(), (Object)data.getString("text"));
                    }
                }
                if (BILL_STATE.equals(col.getProperty())) {
                    o.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode((Integer)o.getInteger(col.getProperty())).getDescription());
                }
            }));
        }
        appJson.put("count", (Object)page.getTotal());
        appJson.put("dbType", (Object)"0");
        appJson.put("isList", (Object)"1");
        appJson.put("isPage", (Object)"1");
        appJson.put("linkList", null);
        appJson.put("expData", (Object)new JSONObject());
        appJson.put("list", (Object)page.getRecords());
        appJson.put("total", (Object)page.getPages());
        resp.put(app.getAppCode(), (Object)appJson);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/{pageCode}/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@PathVariable String pageCode, @RequestBody List<String> ids) throws IOException {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        for (String id : ids) {
            this.mongoTemplate.deleteById(id, mainTableEntity.getTableName());
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter("eq", (Object)id));
            List dataEntityList = this.iCustomDataService.queryList(dataParam, false);
            if (!ListUtil.isNotEmpty((List)dataEntityList)) continue;
            this.iCustomDataService.removeById(((CustomDataEntity)((Object)dataEntityList.get(0))).getId(), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/{pageCode}/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDetail(@PathVariable String pageCode, @RequestParam String id) throws IOException {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        JSONObject jsonObject = this.mongoTemplate.selectById(id, mainTableEntity.getTableName());
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/{pageCode}/queryPrintDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryPrintDetail(@PathVariable String pageCode, @RequestParam String id) throws IOException {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainCols = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        JSONObject mainDetail = this.mongoTemplate.selectById(id, mainTableEntity.getTableName());
        for (Object col : mainCols) {
            String[] stringArray;
            if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("name"));
            }
            if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("text"));
            }
            if (BILL_STATE.equals(col.getProperty()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode((Integer)mainDetail.getInteger(col.getProperty())).getDescription());
            }
            if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
            if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                stringArray = col.getVal().split(",");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "\u662f";
                stringArray = stringArray2;
                stringArray2[1] = "\u5426";
            }
            String[] names = stringArray;
            if ("1".equals(mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)names[0]);
                continue;
            }
            mainDetail.put(col.getProperty(), (Object)names[1]);
        }
        List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
        if (childTableEntities != null && childTableEntities.size() > 0) {
            for (CustomTableEntity childTableEntity : childTableEntities) {
                List<CustomColumnEntity> subCols = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                JSONArray subTbsData = new JSONArray();
                try {
                    JSONArray detailObjs = mainDetail.getJSONArray(childTableEntity.getUiKey());
                    for (int i = 0; i < detailObjs.size(); ++i) {
                        JSONObject subDetail = detailObjs.getJSONObject(i);
                        for (CustomColumnEntity col : subCols) {
                            String[] stringArray;
                            if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)subDetail.getString(col.getProperty()))) {
                                subDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)subDetail.getString(col.getProperty())).getString("name"));
                            }
                            if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)subDetail.getString(col.getProperty()))) {
                                subDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)subDetail.getString(col.getProperty())).getString("text"));
                            }
                            if (!"integer".equals(col.getType())) continue;
                            if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                                stringArray = col.getVal().split(",");
                            } else {
                                String[] stringArray3 = new String[2];
                                stringArray3[0] = "\u662f";
                                stringArray = stringArray3;
                                stringArray3[1] = "\u5426";
                            }
                            String[] names = stringArray;
                            if ("1".equals(subDetail.getString(col.getProperty()))) {
                                subDetail.put(col.getProperty(), (Object)names[0]);
                                continue;
                            }
                            subDetail.put(col.getProperty(), (Object)names[1]);
                        }
                        subTbsData.add((Object)subDetail);
                    }
                    mainDetail.put(childTableEntity.getUiKey(), (Object)subTbsData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        CommonResponse approveList = this.bpmApi.queryHistoryById(Long.valueOf(Long.parseLong(id)));
        mainDetail.put("ApproveInfo", approveList.getData());
        return CommonResponse.success((Object)mainDetail);
    }

    @RequestMapping(value={"/syncToMongo"}, method={RequestMethod.GET})
    public CommonResponse<String> syncToMongo(@RequestParam(required=false) String pageCode) {
        Thread runnable = new Thread(() -> {
            QueryParam dataParam = new QueryParam();
            if (StringUtils.isNotEmpty((CharSequence)pageCode)) {
                dataParam.getParams().put("appCode", new Parameter("eq", (Object)pageCode));
            }
            int index = 1;
            dataParam.setPageIndex(index);
            dataParam.setPageSize(500);
            IPage page = this.iCustomDataService.queryPage(dataParam, false);
            while (ListUtil.isNotEmpty((List)page.getRecords())) {
                this.saveToMongo(page.getRecords());
                dataParam.setPageIndex(++index);
                page = this.iCustomDataService.queryPage(dataParam, false);
            }
        });
        runnable.start();
        return CommonResponse.success((String)"\u540c\u6b65\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u7cfb\u7edf\u5728\u540e\u53f0\u5904\u7406\u4e2d...");
    }

    private void saveToMongo(List<CustomDataEntity> entities) {
        if (ListUtil.isEmpty(entities)) {
            return;
        }
        HashMap<String, CustomAppEntity> appMap = new HashMap<String, CustomAppEntity>();
        HashMap<String, CustomTableEntity> tableMap = new HashMap<String, CustomTableEntity>();
        for (CustomDataEntity entity : entities) {
            CustomTableEntity mainTableEntity;
            CustomAppEntity app = (CustomAppEntity)((Object)appMap.get(entity.getAppCode()));
            if (app == null) {
                app = this.customAppService.queryCustomAppByCode(entity.getAppCode());
                appMap.put(entity.getAppCode(), app);
            }
            if ((mainTableEntity = (CustomTableEntity)((Object)tableMap.get(app.getId().toString()))) == null) {
                mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
                tableMap.put(app.getId().toString(), mainTableEntity);
            }
            JSONObject saveData = JSONObject.parseObject((String)entity.getData());
            this.mongoTemplate.insertOrUpdate(saveData, mainTableEntity.getTableName());
        }
    }
}

