package com.ejianc.business.contractbase.pool.contractpool.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
public class ContractReportVO extends BaseVO {

    private static final long serialVersionUID = -7704541980055959188L;

    private Long contractId; // 合同Id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long categoryId; // 合同分类Id
    private String categoryName; // 合同分类名称
    private String categoryProperty; // 合同分类属性
    private Long mainContractId; // 主合同Id
    private String mainContractName; // 主合同名称
    private String mainContractCode; // 主合同编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Long partyaId; // 合同甲方Id
    private String partyaName; // 合同甲方名称
    private Long partybId; // 合同乙方Id
    private String partybName; // 合同乙方名称
    private Long partycId; // 合同丙方Id
    private String partycName; // 合同丙方名称
    private Long joinPartyId; // 联合体方Id
    private String joinPartyName; // 联合体方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String signPlace; // 签订地点
    /**
     * 工程地点
     */
    private String projectAddress;
    private String pricingType; // 计价方式：fixedPrice-可调单价、fixedTotalPrice-固定总价、3-成本加酬金
    private String taxCalcTypeName; // 计税方式名称:简易计税、一般计税
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractFinishDate; // 合同竣工日期
    private Integer contractDaysLimit; // 合同工期:合同工期=同竣工日期-开工日期+1（单位：天）
    private Integer purchaseType; // 采购类型: 1-自采，2-集采
    private BigDecimal taxRate; // 合同税率
    private BigDecimal baseTaxMny; // 合同签订(合同初始)金额（含税）
    private BigDecimal baseMny; // 合同签订(合同初始)金额（不含税）
    private BigDecimal baseTax; // 合同签订(合同初始)税额
    private BigDecimal contractTaxMny; // 合同总金额（含税）
    private BigDecimal contractMny; // 合同总金额（不含税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal totalPaymentApplyTaxMny; // 累计付款申请金额（含税）
    private BigDecimal totalPaymentApplyMny; // 累计付款申请金额（不含税）
    private BigDecimal totalSettleTaxMny;//合同累计结算金额(含税)
    private BigDecimal totalSettleMny;//合同累计结算金额(无税)
    private BigDecimal totalSettleTax; // 合同累计结算税额

    private String contractTaxMnyStr; // 累计付款申请金额（含税）字符
    private String totalPaymentApplyTaxMnyStr; // 合同累计结算金额(含税) 字符
    private String totalSettleTaxMnyStr; // 合同累计结算金额(无税)含税

    private Long sourceId; // 来源业务单据Id

    /**
     * 是否可以点击
     */
    private Boolean clickable;


    /**
     * 合同属性：1-收入，0支出
     */
    private Integer contractProperty;
    /**
     * 合同属性名称：1-收入，0支出
     */
    private String contractPropertyName;

    /**
     * 来源单业务单据类型：
     */
    private String sourceType;

    /**
     * 来源业务单据类型名称
     */
    private String sourceTypeName;

    /**
     * 单据PC端详情路由地址
     */
    private String pcCardUrl;

    /**
     * 单据移动端详情路由地址
     */
    private String mobileCardUrl;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废； 5、已冻结  默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String performanceStatus;
    /**
     * 合同履约状态名称：1、未签订；2、履约中；3、已终止；4、已作废； 5、已冻结  默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String performanceStatusName;

    /**
     * 经办人Id
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办人电话
     */
    private String employeePhone;

    /**
     * 经办部门id
     */
    private Long departmentId;

    /**
     * 经办部门名称
     */
    private String departmentName;

    /**
     * 备注
     */
    private String memo;

    /**
     * 数据来源：1-业务系统数据推送，2-手工录入
     */
    private Integer addType;

    private Long supplierProjectManagerId;// 乙方负责人/乙方项目经理id
    /**
     * 乙方负责人/乙方项目经理名称
     */
    private String supplierProjectManagerName;

    /**
     * 乙方负责人/乙方项目经理联系电话
     */
    private String supplierProjectManagerLink;

    /**
     * 完工结算单生效日期
     */
    private Date finishSettleDate;


    private String purchaseId; // 供货内容id
    private String purchaseName; // 供货内容名称

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    private List<ContractSubPaymentNodeVO> contractSubPaymentNodeList = new ArrayList<>(); // 合同付款节点子实体

    public Integer getContractProperty() {
        return contractProperty;
    }

    public void setContractProperty(Integer contractProperty) {
        this.contractProperty = contractProperty;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    @ReferDeserialTransfer
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getPcCardUrl() {
        return pcCardUrl;
    }

    public void setPcCardUrl(String pcCardUrl) {
        this.pcCardUrl = pcCardUrl;
    }

    public String getMobileCardUrl() {
        return mobileCardUrl;
    }

    public void setMobileCardUrl(String mobileCardUrl) {
        this.mobileCardUrl = mobileCardUrl;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @ReferDeserialTransfer
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    @ReferDeserialTransfer
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    @ReferDeserialTransfer
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferDeserialTransfer
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferDeserialTransfer
    public Long getPartyaId() {
        return partyaId;
    }

    public void setPartyaId(Long partyaId) {
        this.partyaId = partyaId;
    }
    public String getPartyaName() {
        return partyaName;
    }

    public void setPartyaName(String partyaName) {
        this.partyaName = partyaName;
    }

    @ReferDeserialTransfer
    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }
    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }

    @ReferDeserialTransfer
    public Long getPartycId() {
        return partycId;
    }

    public void setPartycId(Long partycId) {
        this.partycId = partycId;
    }
    public String getPartycName() {
        return partycName;
    }

    public void setPartycName(String partycName) {
        this.partycName = partycName;
    }

    @ReferDeserialTransfer
    public Long getJoinPartyId() {
        return joinPartyId;
    }

    public void setJoinPartyId(Long joinPartyId) {
        this.joinPartyId = joinPartyId;
    }
    public String getJoinPartyName() {
        return joinPartyName;
    }

    public void setJoinPartyName(String joinPartyName) {
        this.joinPartyName = joinPartyName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public String getTaxCalcTypeName() {
        return taxCalcTypeName;
    }

    public void setTaxCalcTypeName(String taxCalcTypeName) {
        this.taxCalcTypeName = taxCalcTypeName;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getContractFinishDate() {
        return contractFinishDate;
    }

    public void setContractFinishDate(Date contractFinishDate) {
        this.contractFinishDate = contractFinishDate;
    }
    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getTotalPaymentApplyTaxMny() {
        return totalPaymentApplyTaxMny;
    }

    public void setTotalPaymentApplyTaxMny(BigDecimal totalPaymentApplyTaxMny) {
        this.totalPaymentApplyTaxMny = totalPaymentApplyTaxMny;
    }
    public BigDecimal getTotalPaymentApplyMny() {
        return totalPaymentApplyMny;
    }

    public void setTotalPaymentApplyMny(BigDecimal totalPaymentApplyMny) {
        this.totalPaymentApplyMny = totalPaymentApplyMny;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
     public List<ContractSubPaymentNodeVO> getContractSubPaymentNodeList() {
        return contractSubPaymentNodeList;
     }

     public void setContractSubPaymentNodeList(List<ContractSubPaymentNodeVO> contractSubPaymentNodeList) {
        this.contractSubPaymentNodeList = contractSubPaymentNodeList;
     }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getPerformanceStatusName() {
        return performanceStatusName;
    }

    public void setPerformanceStatusName(String performanceStatusName) {
        this.performanceStatusName = performanceStatusName;
    }

    public String getContractTaxMnyStr() {
        return contractTaxMnyStr;
    }

    public void setContractTaxMnyStr(String contractTaxMnyStr) {
        this.contractTaxMnyStr = contractTaxMnyStr;
    }

    public String getTotalPaymentApplyTaxMnyStr() {
        return totalPaymentApplyTaxMnyStr;
    }

    public void setTotalPaymentApplyTaxMnyStr(String totalPaymentApplyTaxMnyStr) {
        this.totalPaymentApplyTaxMnyStr = totalPaymentApplyTaxMnyStr;
    }

    public String getTotalSettleTaxMnyStr() {
        return totalSettleTaxMnyStr;
    }

    public void setTotalSettleTaxMnyStr(String totalSettleTaxMnyStr) {
        this.totalSettleTaxMnyStr = totalSettleTaxMnyStr;
    }

    public Boolean getClickable() {
        return clickable;
    }

    public void setClickable(Boolean clickable) {
        this.clickable = clickable;
    }

}
