package com.ejianc.business.contractbase.home.consts;

import org.apache.commons.lang3.StringUtils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 编码常量翻译
 */
public enum ProjectStatusEnum {

    // 项目状态：1、在建 2、项目中止 3、竣工 4、保修 5、 其他
    在建("1", "在建"),
    项目中止("2", "项目中止"),
    竣工("3", "竣工"),
    保修("4", "保修"),
    其他("5", "其他"),
    nullv(null, null),
    ;

    private final String name;
    private final String code;
    private static Map<String, ProjectStatusEnum> enumMap = new HashMap();

    private ProjectStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static ProjectStatusEnum getEnumByCode(String code) {
        return (ProjectStatusEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ProjectStatusEnum.class).stream().collect(Collectors.toMap(ProjectStatusEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
