package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同类型枚举
 *
 * @author CJ
 * @Description:
 * @date 2022/2/28 11:42
 */
public enum ContractTypeEnum {

    /**
     * 合同类型：周转材合同
     */
    周转材合同("rmat", "周转材合同", "rmat"),

    /**
     * 合同类型：周转材合同补充协议
     */
    周转材合同补充协议("rmat", "周转材合同补充协议", "rmatSupplement"),

    /**
     * 合同类型：周转材合同变更
     */
    周转材合同变更("rmat", "周转材合同变更", "rmatChange"),

    /**
     * 合同类型：施工合同
     */
    施工合同("contraction", "施工合同", "contraction"),
    /**
     * 合同类型：施工合同补充协议
     */
    施工合同补充协议("contraction", "施工合同补充协议", "contractionSupplement"),
    /**
     * 合同类型：施工合同变更
     */
    施工合同变更("contraction", "施工合同变更", "contractionChange"),


    /**
     * 合同类型：专业分包合同
     */
    专业分包合同("proSub", "专业分包合同", "proSub"),
    /**
     * 合同类型：专业分包合同补充协议
     */
    专业分包合同补充协议("proSub", "专业分包合同补充协议", "proSubSupplement"),
    /**
     * 合同类型：专业分包合同变更
     */
    专业分包合同变更("proSub", "专业分包合同变更", "proSubChange"),

    /**
     * 合同类型：劳务分包合同
     */
    劳务分包合同("laborSub", "劳务分包合同", "laborSub"),
    /**
     * 合同类型：劳务分包合同补充协议
     */
    劳务分包合同补充协议("laborSub", "劳务分包合同补充协议", "laborSubSupplement"),
    /**
     * 合同类型：劳务分包合同变更
     */
    劳务分包合同变更("laborSub", "劳务分包合同变更", "laborSubChange"),

    /**
     * 合同类型：物资采购合同
     */
    物资采购合同("contractMaterial", "物资采购合同", "contractMaterial"),
    /**
     * 合同类型：物资采购合同
     */
    物资采购合同补充协议("contractMaterial", "物资采购合同补充协议", "contractMaterialSupplement"),
    /**
     * 合同类型：物资采购合同
     */
    物资采购合同变更("contractMaterial", "物资采购合同变更", "contractMaterialChange"),

    /**
     * 合同类型：混凝土合同
     */
    混凝土合同("contractConcrete", "混凝土合同", "contractConcrete"),
    /**
     * 合同类型：混凝土合同补充协议
     */
    混凝土合同补充协议("contractConcrete", "混凝土合同补充协议", "contractConcreteSupplement"),
    /**
     * 合同类型：混凝土合同变更
     */
    混凝土合同变更("contractConcrete", "混凝土合同变更", "contractConcreteChange"),

    /**
     * 合同类型：收入合同
     */
    收入合同("contractIn", "收入合同", "contractIn"),
    /**
     * 合同类型：收入合同补充协议
     */
    收入合同补充协议("contractIn", "收入合同补充协议", "contractInSupplement"),
    /**
     * 合同类型：收入合同变更
     */
    收入合同变更("contractIn", "收入合同变更", "contractInChange"),

    /**
     * 合同类型：支出合同
     */
    支出合同("contractOut", "支出合同", "contractOut"),
    /**
     * 合同类型：支出合同补充协议
     */
    支出合同补充协议("contractOut", "支出合同补充协议", "contractOutSupplement"),
    /**
     * 合同类型：支出合同变更
     */
    支出合同变更("contractOut", "支出合同变更", "contractOutChange"),

    /**
     * 合同类型：其他收入合同
     */
    其他收入合同("otherIn", "其他收入合同", "otherIn"),
    /**
     * 合同类型：其他收入合同补充协议
     */
    其他收入合同补充协议("otherIn", "其他收入合同补充协议", "otherInSupplement"),
    /**
     * 合同类型：其他收入合同变更
     */
    其他收入合同变更("otherIn", "其他收入合同变更", "otherInChange"),

    /**
     * 合同类型：其他支出合同
     */
    其他支出("contractOther", "其他支出", "contractOther"),
    /**
     * 合同类型：其他支出补充协议
     */
    其他支出补充协议("contractOther", "其他支出补充协议", "contractOtherSupplement"),
    /**
     * 合同类型：其他支出合同变更
     */
    其他支出合同变更("contractOther", "其他支出合同变更", "contractOtherChange"),

    /**
     * 合同类型：设备租赁
     */
    设备租赁("equipmentRent", "设备租赁", "equipmentRent"),
    /**
     * 合同类型：设备租赁补充协议
     */
    设备租赁补充协议("equipmentRent", "设备租赁补充协议", "equipmentRentSupplement"),
    /**
     * 合同类型：设备租赁变更
     */
    设备租赁变更("equipmentRent", "设备租赁变更", "equipmentRentChange"),

    /**
     * 合同类型：设备采购
     */
    设备采购("equipmentPurchase", "设备采购", "equipmentPurchase"),
    /**
     * 合同类型：设备采购补充协议
     */
    设备采购补充协议("equipmentPurchase", "设备采购补充协议", "equipmentPurchaseSupplement"),
    /**
     * 合同类型：设备采购变更
     */
    设备采购变更("equipmentPurchase", "设备采购变更", "equipmentPurchaseChange"),

    /**
     * 合同类型：临时设备
     */
    临时设备("tempEquip", "临时设备", "tempEquip"),
    /**
     * 合同类型：临时设备补充协议
     */
    临时设备补充协议("tempEquip", "临时设备补充协议", "tempEquipSupplement"),
    /**
     * 合同类型：临时设备变更
     */
    临时设备变更("tempEquip", "临时设备变更", "tempEquipChange"),

    /**
     * 合同类型：安拆合同
     */
    安拆合同("contractAC",  "安拆合同", "contractAC"),
    /**
     * 合同类型：安拆合同补充协议
     */
    安拆合同补充协议("contractAC",  "安拆合同补充协议", "contractACSupplement"),
    /**
     * 合同类型：安拆合同变更
     */
    安拆合同变更("contractAC",  "安拆合同变更", "contractACChange"),

    /**
     * 合同类型：辅料中心周转材租赁合同
     */
    辅料中心周转材租赁合同("assistrmat", "辅料中心周转材租赁合同", "assistrmat"),
    /**
     * 合同类型：辅料中心周转材租赁合同补充协议
     */
    辅料中心周转材租赁合同补充协议("assistrmat", "辅料中心周转材租赁合同补充协议", "assistrmatSupplement"),
    /**
     * 合同类型：辅料中心周转材租赁合同变更
     */
    辅料中心周转材租赁合同变更("assistrmat", "辅料中心周转材租赁合同变更", "assistrmatChange"),

    /**
     * 合同类型：辅料中心周转材采购合同
     */
    辅料中心周转材采购合同("assistmaterial", "辅料中心周转材采购合同", "assistmaterial"),
    /**
     * 合同类型：辅料中心周转材采购合同补充协议
     */
    辅料中心周转材采购合同补充协议("assistmaterial", "辅料中心周转材采购合同补充协议", "assistmaterialSupplement"),
    /**
     * 合同类型：辅料中心周转材采购合同变更
     */
    辅料中心周转材采购合同变更("assistmaterial", "辅料中心周转材采购合同变更", "assistmaterialChange"),

    /**
     * 合同类型：辅料中心周转材租出合同
     */
    辅料中心周转材租出合同("assistOutRent", "周转材租出合同", "assistOutRent"),
    /**
     * 合同类型：辅料中心周转材租出合同补充协议
     */
    辅料中心周转材租出合同补充协议("assistOutRent", "周转材租出合同补充协议", "assistOutRentSupplement"),
    /**
     * 合同类型：辅料中心周转材租出合同变更
     */
    辅料中心周转材租出合同变更("assistOutRent", "周转材租出合同变更", "assistOutRentChange"),

    /**
     * 合同类型：设备公司设备采购合同
     */
    设备公司设备采购合同("equipPurchaseCorp", "设备公司设备采购合同", "equipPurchaseCorp"),
    /**
     * 合同类型：设备公司设备采购合同补充协议
     */
    设备公司设备采购合同补充协议("equipPurchaseCorp", "设备公司设备采购合同补充协议", "equipPurchaseCorpSupplement"),
    /**
     * 合同类型：设备公司设备采购合同变更
     */
    设备公司设备采购合同变更("equipPurchaseCorp", "设备公司设备采购合同变更", "equipPurchaseCorpChange"),

    /**
     * 合同类型：设备公司设备租赁合同
     */
    设备公司设备租赁合同("equipRentCorp", "设备公司设备租赁合同", "equipRentCorp"),
    /**
     * 合同类型：设备公司设备租赁合同补充协议
     */
    设备公司设备租赁合同补充协议("equipRentCorp", "设备公司设备租赁合同补充协议", "equipRentCorpSupplement"),
    /**
     * 合同类型：设备公司设备租赁合同变更
     */
    设备公司设备租赁合同变更("equipRentCorp", "设备公司设备租赁合同变更", "equipRentCorpChange"),
    /**
     * 合同类型：设备公司设备租出合同
     */
    设备公司设备租出合同("equipOutRentCorp", "机械设备租出合同", "equipOutRentCorpCorp"),
    /**
     * 合同类型：设备公司设备租出合同补充协议
     */
    设备公司设备租出合同补充协议("equipOutRentCorp", "机械设备租出合同补充协议", "equipOutRentCorpCorpSupplement"),
    /**
     * 合同类型：设备公司设备租出合同变更
     */
    设备公司设备租出合同变更("equipOutRentCorp", "机械设备租出合同变更", "equipOutRentCorpCorpChange");



    ContractTypeEnum(String typeCode, String typeName, String subTypeCode) {
        this.typeCode = typeCode;
        this.typeName = typeName;
        this.subTypeCode = subTypeCode;
    }

    //合同大类
    private String typeCode;
    //合同业务类型名称
    private String typeName;
    //合同业务子类型
    private String subTypeCode;
    private static Map<String, ContractTypeEnum> enumMap = new HashMap<>();

    public String getSubTypeCode() {
        return subTypeCode;
    }

    public void setSubTypeCode(String subTypeCode) {
        this.subTypeCode = subTypeCode;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(ContractTypeEnum.class).stream().collect(Collectors.toMap(ContractTypeEnum::getSubTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }
}
