package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 结算池-结算单类型枚举
 * <p>
 * 1-product_value-产值报量,
 * 2-product_value_first-对甲报量,
 * 3-settle_verify-结算报审,
 * 4-project_decide-工程定案,
 * 5-material_week_rent_out-周转材租出结算,
 * 6-material_week_rent_in-周转材租入结算,
 * 7-equip_rent_out-设备租出结算,
 * 8-equip_rent_in-设备租入结算,
 * 9-labor_month-劳务分包月度结算,
 * 10-labor_node-劳务分包节点结算,
 * 11-labor_final-劳务分包最终结算,
 * 12-pro_month-专业分包月度结算,
 * 13-pro_node-专业分包节点结算,
 * 14-pro_final-专业分包最终结算,
 * 15-material_buy_in-物资采购结算,
 * 16-equip_buy_in-设备采购结算,
 * 17-beton_buy_in-混凝土采购结算,
 * 18-temp_equip-临时设备结算,
 * 19-big_equip_install_uninstall-大型设备安拆结算,
 * 20-law_cost-诉讼费结算,
 * 21-other_in-其他收入结算,
 * 22-other_out-其他支出结算,
 * 23-other_out_contract_month-其他支出合同过程结算,
 * 24-other_out_contract_final-其他支出合同最终结算
 */
public enum SettleSourceTypeEnum {

    //1-product_value-产值报量,
    产值报量("product_value", "产值报量"),
    //2-product_value_first-对甲报量,
    对甲报量("product_value_first", "对甲报量"),
    //3-settle_verify-结算报审,
    结算报审("settle_verify", "结算报审"),
    //4-project_decide-工程定案,
    工程定案("project_decide", "工程定案"),
    //5-material_week_rent_out-周转材租出结算,
    周转材租出结算("material_week_rent_out", "周转材租出结算"),
    //6-material_week_rent_in-周转材租入结算,
    周转材租入结算("material_week_rent_in", "周转材租入结算"),
    //7-equip_rent_out-设备租出结算,
    设备租出结算("equip_rent_out", "设备租出结算"),
    //8-equip_rent_in-设备租入结算,
    设备租入结算("equip_rent_in", "设备租赁结算"),
    //9-labor_month-劳务分包月度结算,
    劳务分包月度结算("labor_month", "劳务分包月度结算"),
    //10-labor_node-劳务分包节点结算,
    劳务分包节点结算("labor_node", "劳务分包节点结算"),
    //11-labor_final-劳务分包最终结算,
    劳务分包最终结算("labor_final", "劳务分包最终结算"),
    //12-pro_month-专业分包月度结算,
    专业分包月度结算("pro_month", "专业分包月度结算"),
    //13-pro_node-专业分包节点结算,
    专业分包节点结算("pro_node", "专业分包节点结算"),
    //14-pro_final-专业分包最终结算,
    专业分包最终结算("pro_final", "专业分包最终结算"),
    //15-material_buy_in-物资采购结算,
    物资采购结算("material_buy_in", "物资采购结算"),
    //16-equip_buy_in-设备采购结算,
    设备采购结算("equip_buy_in", "设备采购结算"),
    //17-beton_buy_in-混凝土采购结算,
    混凝土采购结算("beton_buy_in", "混凝土采购结算"),
    零星材料结算("sporadic_material", "零星材料结算"),
    //18-temp_equip-临时设备结算,
    临时设备结算("temp_equip", "临时设备结算"),
    //19-big_equip_install_uninstall-大型设备安拆结算,
//    大型设备安拆结算("big_equip_install_uninstall", "大型设备安拆结算"),
    //20-law_cost-诉讼费结算,
    诉讼费结算("law_cost", "诉讼费结算"),
    //21-other_in-其他收入结算,
    其他收入结算("other_in", "其他收入结算"),
    //22-other_out-其他支出结算,
    其他支出结算("other_out", "其他支出结算"),
    //23-other_out_contract_month-其他支出合同过程结算
    其他支出合同过程结算("other_out_contract_month", "其他支出合同过程结算"),
    //24-other_out_contract_final-其他支出合同最终结算
    其他支出合同最终结算("other_out_contract_final", "其他支出合同最终结算"),
    安拆合同过程结算("ac_other_out_contract_month", "安拆合同过程结算"),
    安拆合同最终结算("ac_other_out_contract_final", "安拆合同最终结算"),

    辅料中心周转材租入结算("assist_rmat_rent_in", "辅料中心周转材租入结算"),
    辅料中心周转材采购结算("assist_material_buy_in", "辅料中心周转材采购结算"),

    周转材租出结算_公司("material_week_rent_out_company", "周转材租出结算（公司）"),
    周转材租入结算_公司("material_week_rent_in_company", "周转材租入结算（公司）"),
    周转材采购结算_公司("material_week_buy_in_company", "周转材采购结算（公司）"),
    设备组出结算_公司("equip_rent_out_company", "设备组出结算（公司）"),
    设备租入结算_公司("equip_rent_in_company", "设备租入结算（公司）"),

    设备公司设备采购过程结算("equip_purchase_corp_process", "设备公司设备采购过程结算"),
    设备公司设备采购最终结算("equip_purchase_corp_final", "设备公司设备采购最终结算"),
    设备公司设备租赁过程结算("equip_rent_in_corp_process", "设备公司设备租赁过程结算"),
    设备公司设备租赁最终结算("equip_rent_in_corp_final", "设备公司设备租赁最终结算");

    // 结算单类型
    private String code;
    // 结算单类型名名称
    private String name;
    private static Map<String, SettleSourceTypeEnum> enumMap = new HashMap<>();

    SettleSourceTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        enumMap = EnumSet.allOf(SettleSourceTypeEnum.class)
                .stream().collect(Collectors.toMap(SettleSourceTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static SettleSourceTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }
}
