package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 结算单合同标识
 */
public enum ContractFlagEnum {
    /**
     * 有合同结算
     */
    有合同结算(1, "有合同结算"),

    /**
     * 无合同结算
     */
    无合同结算(0, "无合同结算");

    ContractFlagEnum(Integer contractFlagCode, String contractFlagCodeName) {
        this.contractFlagCode = contractFlagCode;
        this.contractFlagCodeName = contractFlagCodeName;
    }

    private Integer contractFlagCode;
    private String contractFlagCodeName;

    private static Map<String, ContractTypeEnum> enumMap = new HashMap<>();

    public Integer getContractFlagCode() {
        return contractFlagCode;
    }

    public void setContractFlagCode(Integer contractFlagCode) {
        this.contractFlagCode = contractFlagCode;
    }

    public String getContractFlagCodeName() {
        return contractFlagCodeName;
    }

    public void setContractFlagCodeName(String contractFlagCodeName) {
        this.contractFlagCodeName = contractFlagCodeName;
    }

    static {
        enumMap = EnumSet.allOf(ContractTypeEnum.class).stream().collect(Collectors.toMap(ContractTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }
}
