package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.ClauseSettingHystrix;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 合同条款管理API
 *
 * @author CJ
 * @Description: 合同条款管理API
 * @date 2021/11/10 17:50
 */
@FeignClient(name = "ejc-contractbase-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-contractbase-web", fallback = ClauseSettingHystrix.class)
public interface IClauseSettingApi {

    /**
     * 根据模板Id查询模板编辑版本列表
     *
     * @param categoryId 合同分类id
     * @return
     */
    @GetMapping(value = "/api/clauseSetting/getListByCategoryId")
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryId(@RequestParam Long categoryId);

    /**
     * 根据分类属性查询对应可用条款列表
     *
     * @param categoryProperty
     * @return
     */
    @GetMapping(value = "/api/clauseSetting/getListByCategoryProperty")
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryProperty(@RequestParam String categoryProperty);

}
