package com.ejianc.business.contractbase.api;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.hystrix.HomePortalHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "ejc-contractbase-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-contractbase-web", fallback = HomePortalHystrix.class)
public interface IHomePortalApi {

    // 产值进度比例
    @RequestMapping(value = "/api/homePortal/queryOutputScale", method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryOutputScale(@RequestParam Long projectId);

}
