package com.ejianc.business.contractbase.disclose.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.contractbase.disclose.vo.ContractArchiveDetailFileVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 合同归档子实体
 * 
 * @author generator
 * 
 */
public class ContractArchiveDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractArchiveId; // 合同归档id
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 合同签订日期
    private BigDecimal contractMny; // 合同金额
    private Long partybId; // 乙方id
    private String partybName; // 乙方
    private Integer fileNum; // 文件数量

    private List<ContractArchiveDetailFileVO> fileList = new ArrayList<>(); // 合同归档子实体附件实体

    public Long getContractArchiveId() {
        return contractArchiveId;
    }

    public void setContractArchiveId(Long contractArchiveId) {
        this.contractArchiveId = contractArchiveId;
    }

    @ReferSerialTransfer(referCode="contractPool")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }
    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }

    public List<ContractArchiveDetailFileVO> getFileList() {
        return fileList;
    }

    public void setFileList(List<ContractArchiveDetailFileVO> fileList) {
        this.fileList = fileList;
    }

    public Integer getFileNum() {
        return fileNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }
}
