package com.ejianc.business.contractbase.disclose.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.contractbase.disclose.vo.ContractArchiveDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 合同归档
 * 
 * @author generator
 * 
 */
public class ContractArchiveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date transferDate; // 移交日期
    private Long discloseId; // 交底人
    private String discloseName; // 交底人名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long transferFileId; // 移交档案接收人
    private String transferFileName; // 移交档案接收人
    private String memo; // 备注
    private String billStateName;
    private Long orgId; // 组织
    private String orgName; // orgName

    private List<ContractArchiveDetailVO> detailList = new ArrayList<>(); // 合同归档子实体

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getTransferDate() {
        return transferDate;
    }

    public void setTransferDate(Date transferDate) {
        this.transferDate = transferDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDiscloseId() {
        return discloseId;
    }

    @ReferDeserialTransfer
    public void setDiscloseId(Long discloseId) {
        this.discloseId = discloseId;
    }
    public String getDiscloseName() {
        return discloseName;
    }

    public void setDiscloseName(String discloseName) {
        this.discloseName = discloseName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getTransferFileId() {
        return transferFileId;
    }

    @ReferDeserialTransfer
    public void setTransferFileId(Long transferFileId) {
        this.transferFileId = transferFileId;
    }
    public String getTransferFileName() {
        return transferFileName;
    }

    public void setTransferFileName(String transferFileName) {
        this.transferFileName = transferFileName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ContractArchiveDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractArchiveDetailVO> detailList) {
        this.detailList = detailList;
    }
}
