package com.ejianc.business.contractbase.disclose.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工程承包合同一二级交底
 * 
 * @author generator
 * 
 */
public class EngineerContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // orgName
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long contractType; // 合同类型
    private String contractTypeName; // 合同类型
    private Long customerId; // 合同甲方/发包人
    private String customerName; // 合同甲方/发包人
    private String supervisor; // 监理单位
    private String designer; // 设计单位
    private String survey; // 勘察单位
    private String address; // 工程地址
    private Long transferFileId; // 移交文件
    private String transferFileName; // 移交文件
    private String otherTransferFile; // 其他移交文件

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date discloseDate; // 交底日期
    private Long discloseId; // 交底人
    private String discloseName; // 交底人名称
    private String receiveDiscloseId; // 接收交底人
    private String receiveDiscloseName; // 接收交底人
    private BigDecimal contractMny; // 合同金额
    private BigDecimal contractMnyWan; // 合同金额（万元）
    private BigDecimal temporarilyMny; // 暂列金
    private BigDecimal provisionalMny; // 暂估价
    private BigDecimal subcontractorMny; // 甲分包
    private BigDecimal advanceMny; // 垫资额
    private BigDecimal financeMny; // 财务费用
    private String projectOverview; // 工程概况
    private String tenderContent; // 承包内容
    private String payCommit; // 付款约定
    private String changePriceContent; // 调价调差
    private String measure; // 措施约定
    private String visaAims; // 签证索赔
    private String aSupply; // 甲供材及认质认价
    private String settleContent; // 结算程序与结算款约定
    private String progressCommit; // 进度约定（目标）
    private String qualityCommit; // 质量约定（目标）
    private String safeWorker; //  安全约定（目标）
    private String progressCommitReward; // 进度约定（奖罚）
    private String qualityCommitReward; // 质量约定（奖罚）
    private String safeWorkerReward; //  安全约定（奖罚）
    private String aSupplySub; // 甲分包及甲指分包
    private String argue; // 争议解决


    private String billStateName; // 单据编码名称

    private List<EngineerContractDetailVO> detailList = new ArrayList<>(); // 工程承包合同一二级交底子实体

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    @ReferSerialTransfer(referCode="pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public String getSurvey() {
        return survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }


    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getTransferFileId() {
        return transferFileId;
    }
    @ReferDeserialTransfer
    public void setTransferFileId(Long transferFileId) {
        this.transferFileId = transferFileId;
    }
    public String getTransferFileName() {
        return transferFileName;
    }

    public void setTransferFileName(String transferFileName) {
        this.transferFileName = transferFileName;
    }
    public String getOtherTransferFile() {
        return otherTransferFile;
    }

    public void setOtherTransferFile(String otherTransferFile) {
        this.otherTransferFile = otherTransferFile;
    }
    public Date getDiscloseDate() {
        return discloseDate;
    }

    public void setDiscloseDate(Date discloseDate) {
        this.discloseDate = discloseDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDiscloseId() {
        return discloseId;
    }

    @ReferDeserialTransfer
    public void setDiscloseId(Long discloseId) {
        this.discloseId = discloseId;
    }
    public String getDiscloseName() {
        return discloseName;
    }

    public void setDiscloseName(String discloseName) {
        this.discloseName = discloseName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public String getReceiveDiscloseId() {
        return receiveDiscloseId;
    }

    @ReferDeserialTransfer
    public void setReceiveDiscloseId(String receiveDiscloseId) {
        this.receiveDiscloseId = receiveDiscloseId;
    }




    public String getReceiveDiscloseName() {
        return receiveDiscloseName;
    }

    public void setReceiveDiscloseName(String receiveDiscloseName) {
        this.receiveDiscloseName = receiveDiscloseName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractMnyWan() {
        return contractMnyWan;
    }

    public void setContractMnyWan(BigDecimal contractMnyWan) {
        this.contractMnyWan = contractMnyWan;
    }
    public BigDecimal getTemporarilyMny() {
        return temporarilyMny;
    }

    public void setTemporarilyMny(BigDecimal temporarilyMny) {
        this.temporarilyMny = temporarilyMny;
    }
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    public BigDecimal getSubcontractorMny() {
        return subcontractorMny;
    }

    public void setSubcontractorMny(BigDecimal subcontractorMny) {
        this.subcontractorMny = subcontractorMny;
    }
    public BigDecimal getAdvanceMny() {
        return advanceMny;
    }

    public void setAdvanceMny(BigDecimal advanceMny) {
        this.advanceMny = advanceMny;
    }
    public BigDecimal getFinanceMny() {
        return financeMny;
    }

    public void setFinanceMny(BigDecimal financeMny) {
        this.financeMny = financeMny;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public String getTenderContent() {
        return tenderContent;
    }

    public void setTenderContent(String tenderContent) {
        this.tenderContent = tenderContent;
    }
    public String getPayCommit() {
        return payCommit;
    }

    public void setPayCommit(String payCommit) {
        this.payCommit = payCommit;
    }
    public String getChangePriceContent() {
        return changePriceContent;
    }

    public void setChangePriceContent(String changePriceContent) {
        this.changePriceContent = changePriceContent;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    public String getVisaAims() {
        return visaAims;
    }

    public void setVisaAims(String visaAims) {
        this.visaAims = visaAims;
    }
    public String getASupply() {
        return aSupply;
    }

    public void setASupply(String aSupply) {
        this.aSupply = aSupply;
    }
    public String getSettleContent() {
        return settleContent;
    }

    public void setSettleContent(String settleContent) {
        this.settleContent = settleContent;
    }
    public String getProgressCommit() {
        return progressCommit;
    }

    public void setProgressCommit(String progressCommit) {
        this.progressCommit = progressCommit;
    }
    public String getQualityCommit() {
        return qualityCommit;
    }

    public void setQualityCommit(String qualityCommit) {
        this.qualityCommit = qualityCommit;
    }
    public String getSafeWorker() {
        return safeWorker;
    }

    public void setSafeWorker(String safeWorker) {
        this.safeWorker = safeWorker;
    }
    public String getProgressCommitReward() {
        return progressCommitReward;
    }

    public void setProgressCommitReward(String progressCommitReward) {
        this.progressCommitReward = progressCommitReward;
    }
    public String getQualityCommitReward() {
        return qualityCommitReward;
    }

    public void setQualityCommitReward(String qualityCommitReward) {
        this.qualityCommitReward = qualityCommitReward;
    }
    public String getSafeWorkerReward() {
        return safeWorkerReward;
    }

    public void setSafeWorkerReward(String safeWorkerReward) {
        this.safeWorkerReward = safeWorkerReward;
    }
    public String getASupplySub() {
        return aSupplySub;
    }

    public void setASupplySub(String aSupplySub) {
        this.aSupplySub = aSupplySub;
    }
    public String getArgue() {
        return argue;
    }

    public void setArgue(String argue) {
        this.argue = argue;
    }

    public List<EngineerContractDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<EngineerContractDetailVO> detailList) {
        this.detailList = detailList;
    }
}
