package com.ejianc.business.contractbase.disclose.vo;

import java.util.Date;
import java.math.*;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 物资采购合同交底
 * 
 * @author generator
 * 
 */
public class EquipmentContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同ID
    private String contractName; // 合同名称
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long supplierId; // 供货商ID
    private String supplierName; // 供货商名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureDate; // 交底日期
    private Long informantId; // 交底人ID
    private String informantName; // 交底人名称
    private String receivInformantId; // 接收交底人ID
    private String receivInformantName; // 接收交底人名称
    private Integer rate; // 发票税率
    private String pricingMethod; // 计价方式
    private String supplyContact; // 供货联系人
    private String supplierPhone; // 供货联系方式
    private String supplyScope; // 供货范围
    private String supplyTime; // 供货周期
    private String cceptanceCriteria; // 验收标准
    private String paymentTerms; // 付款条件
    private String paymentMethods; // 付款方式
    private String principle; // 调价调差原则
    private String visaClaims; // 签证索赔
    private String performanceAgreements; // 履约约定
    private String resposibility; // 合同双方责任界定
    private String disputeResolution; // 争议解决
    private String miscellaneous; // 其他约定
    private String forceMajeure; //  不可抗力
    private String contractCode; // 合同编码
    private String projectCode; // 项目编码
    private String categoryName; // 合同类型
    private Long categoryId; // 合同类型ID
    private BigDecimal contractMny; // 合同金额
    private String supplyContactId; // 供货人ID
    private String code; // 编码
    private Integer billState; // 单据状态
    private Long orgId; // 组织ID

    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; //
    private String parentOrgCode; //
    private String parentOrgName; //

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode="contractMaterial")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getDisclosureDate() {
        return disclosureDate;
    }

    public void setDisclosureDate(Date disclosureDate) {
        this.disclosureDate = disclosureDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getInformantId() {
        return informantId;
    }
    @ReferDeserialTransfer
    public void setInformantId(Long informantId) {
        this.informantId = informantId;
    }
    public String getInformantName() {
        return informantName;
    }

    public void setInformantName(String informantName) {
        this.informantName = informantName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getReceivInformantId() {
        return receivInformantId;
    }
    @ReferDeserialTransfer
    public void setReceivInformantId(String receivInformantId) {
        this.receivInformantId = receivInformantId;
    }
    public String getReceivInformantName() {
        return receivInformantName;
    }

    public void setReceivInformantName(String receivInformantName) {
        this.receivInformantName = receivInformantName;
    }
    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }
    public String getPricingMethod() {
        return pricingMethod;
    }

    public void setPricingMethod(String pricingMethod) {
        this.pricingMethod = pricingMethod;
    }
    public String getSupplyContact() {
        return supplyContact;
    }

    public void setSupplyContact(String supplyContact) {
        this.supplyContact = supplyContact;
    }
    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public String getSupplyScope() {
        return supplyScope;
    }

    public void setSupplyScope(String supplyScope) {
        this.supplyScope = supplyScope;
    }
    public String getSupplyTime() {
        return supplyTime;
    }

    public void setSupplyTime(String supplyTime) {
        this.supplyTime = supplyTime;
    }
    public String getCceptanceCriteria() {
        return cceptanceCriteria;
    }

    public void setCceptanceCriteria(String cceptanceCriteria) {
        this.cceptanceCriteria = cceptanceCriteria;
    }
    public String getPaymentTerms() {
        return paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }
    public String getPaymentMethods() {
        return paymentMethods;
    }

    public void setPaymentMethods(String paymentMethods) {
        this.paymentMethods = paymentMethods;
    }
    public String getPrinciple() {
        return principle;
    }

    public void setPrinciple(String principle) {
        this.principle = principle;
    }
    public String getVisaClaims() {
        return visaClaims;
    }

    public void setVisaClaims(String visaClaims) {
        this.visaClaims = visaClaims;
    }
    public String getPerformanceAgreements() {
        return performanceAgreements;
    }

    public void setPerformanceAgreements(String performanceAgreements) {
        this.performanceAgreements = performanceAgreements;
    }
    public String getResposibility() {
        return resposibility;
    }

    public void setResposibility(String resposibility) {
        this.resposibility = resposibility;
    }
    public String getDisputeResolution() {
        return disputeResolution;
    }

    public void setDisputeResolution(String disputeResolution) {
        this.disputeResolution = disputeResolution;
    }
    public String getMiscellaneous() {
        return miscellaneous;
    }

    public void setMiscellaneous(String miscellaneous) {
        this.miscellaneous = miscellaneous;
    }
    public String getForceMajeure() {
        return forceMajeure;
    }

    public void setForceMajeure(String forceMajeure) {
        this.forceMajeure = forceMajeure;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public String getSupplyContactId() {
        return supplyContactId;
    }

    public void setSupplyContactId(String supplyContactId) {
        this.supplyContactId = supplyContactId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
