package com.ejianc.business.contractbase.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 二维码生成位置
 *
 * @author CJ
 * @Description: 二维码生成位置
 * @date 2022/7/5 10:57
 */
public enum QRCodeShowTypeEnum {

    /**
     * 二维码生成位置：首页
     */
    首页("firstPage", "首页"),

    /**
     * 二维码生成位置：尾页
     */
    尾页("lastPage", "尾页"),
    /**
     * 二维码生成位置：奇数页
     */
    奇数页("oddPage", "奇数页"),
    /**
     * 二维码生成位置：偶数页
     */
    偶数页("evenPage", "偶数页");

    private String typeCode;
    private String typeName;
    private static Map<String, QRCodeShowTypeEnum> enumMap = new HashMap<>();

    QRCodeShowTypeEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(QRCodeShowTypeEnum.class).stream().collect(Collectors.toMap(QRCodeShowTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static QRCodeShowTypeEnum getByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
