package com.ejianc.business.contractbase.filing.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class ContractFilingVO extends BaseVO {

    private static final long serialVersionUID = 3221532146225952879L;

    private Long contractId; // 业务单据Id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private BigDecimal contractTaxMny; //合同金额（含税）
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Long firstPartyId; // 合同甲方Id
    private String firstPartyName; // 合同甲方名称
    private Long supplierId; // 合同乙方Id
    private String supplierName; // 合同乙方名称

    private Long employeeId;//经办人Id
    private String employeeName;//经办人名称
    private String employeeCode;//经办人名称

    private String filingExplain;//归档说明

    private Long departmentId;//经办部门id
    private String departmentName;//经办部门名称
    private String departmentCode;//经办部门编码

    private String billCode;//单据编码

    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    private Long filingTypeId;//归档类型 id
    private String filingTypeName;//归档类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filingDate;//归档日期
    private String filingTypeCode;//归档合同类型

    private String filingTypeInnerCode;//归档合同类型

    private Long sourceId;//来源id

    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private String updateBillType;//单据类型
    private String billStateStr;
    private String filingDateStr;//归档日期
    private Long fileId;//文件Id
    private String fileName;//文件名称
    private String filingTypeBillType;//归档类型单据类型

    private Long sourceContractId; //业务单据对应合同Id

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getFilingTypeBillType() {
        return filingTypeBillType;
    }

    public void setFilingTypeBillType(String filingTypeBillType) {
        this.filingTypeBillType = filingTypeBillType;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getFilingDateStr() {
        return filingDateStr;
    }

    public void setFilingDateStr(String filingDateStr) {
        this.filingDateStr = filingDateStr;
    }

    public String getFilingTypeCode() {
        return filingTypeCode;
    }

    public void setFilingTypeCode(String filingTypeCode) {
        this.filingTypeCode = filingTypeCode;
    }

    public String getFilingTypeInnerCode() {
        return filingTypeInnerCode;
    }

    public void setFilingTypeInnerCode(String filingTypeInnerCode) {
        this.filingTypeInnerCode = filingTypeInnerCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getUpdateBillType() {
        return updateBillType;
    }

    public void setUpdateBillType(String updateBillType) {
        this.updateBillType = updateBillType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Date getFilingDate() {
        return filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }

    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getFilingExplain() {
        return filingExplain;
    }

    public void setFilingExplain(String filingExplain) {
        this.filingExplain = filingExplain;
    }

    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getFilingTypeId() {
        return filingTypeId;
    }

    public void setFilingTypeId(Long filingTypeId) {
        this.filingTypeId = filingTypeId;
    }

    public String getFilingTypeName() {
        return filingTypeName;
    }

    public void setFilingTypeName(String filingTypeName) {
        this.filingTypeName = filingTypeName;
    }

    public Long getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(Long sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
}
