package com.ejianc.business.contractbase.home.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 编码常量翻译
 */
public enum BusinessStatusEnum {

    // 业务状态：1、开工准备 2、正式开工 3、停工 4、复工5、完工6、竣工验收 7、成本关门 8、决算中 9、已决算 10、资料未归档 11、资料已归档 12、保修中 13、保修结束 14、开账 15、资金冻结 16、资金恢复 17、已销账
    开工准备("1", "开工准备"),
    正式开工("2", "正式开工"),
    停工("3", "停工"),
    复工("4", "复工"),
    完工("5", "完工"),
    竣工验收("6", "竣工验收"),
    成本关门("7", "成本关门"),
    决算中("8", "决算中"),
    已决算("9", "已决算"),
    资料未归档("10", "资料未归档"),
    资料已归档("11", "资料已归档"),
    保修中("12", "保修中"),
    保修结束("13", "保修结束"),
    开账("14", "开账"),
    资金冻结("15", "资金冻结"),
    资金恢复("16", "资金恢复"),
    已销账("17", "已销账"),
    nullv(null, null),
    ;

    private final String name;
    private final String code;
    private static Map<String, BusinessStatusEnum> enumMap = new HashMap();

    private BusinessStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BusinessStatusEnum getEnumByCode(String code) {
        return (BusinessStatusEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BusinessStatusEnum.class).stream().collect(Collectors.toMap(BusinessStatusEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
