package com.ejianc.business.contractbase.pool.contractpool.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 合同池导入时使用的VO
 *
 * @author generator
 */
public class ImportContractPoolVO {

    // 是否手动新增：1-是，0-否
    private Integer handleType;
    private String handleTypeName;
    // 项目部
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    // 所属组织
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    // 合同
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    // 是否集采
    private Integer purchaseType; // 是否集采：1-否，2-是---(对应合同池的采购类型: 1-自采，2-集采)
    private String purchaseTypeName; // 是否集采：1-否，2-是---(对应合同池的采购类型: 1-自采，2-集采)
    // 项目
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    // 属性类别
    private Integer contractProperty; // 属性类别，0支出，1收入---对应合合同属性：1-收入，0支出
    private String contractPropertyName; // 属性类别名称，0支出，1收入---对应合合同属性：1-收入，0支出
    // 合同类别
    private Long categoryId; // 合同分类Id
    private String categoryName; // 合同分类名称
    private String categoryProperty; // 合同分类属性---暂时当做合同大类
    // 是否补充协议(1:是，0：否)
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String supplementFlagName; // 是否补充协议(1:是，0：否)
    // 主合同
    private Long mainContractId; // 主合同Id
    private String mainContractName; // 主合同名称
    private String mainContractCode; // 主合同编码
    // 合同状态--对应合同池的合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；
    private String performanceStatus;
    private String performanceStatusName;
    // 甲方
    private Long partyaId; // 甲方id
    private String partyaName; // 甲方名称
    // 乙方
    private Long partybId; // 乙方id
    private String partybName; // 乙方名称
    // 丙方
    private Long partycId; // 丙方id
    private String partycName; // 丙方名称
    // 联合体方
    private Long joinPartyId; // 联合体方id
    private String joinPartyName; // 联合体方名称
    // 签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    // 签订地点
    private String signPlace; // 签订地点
    // 税率
    private BigDecimal taxRate; // 合同税率
    private String taxRateStr; // 合同税率
    // 合同签订金额
    private BigDecimal baseTaxMny; // 有税
    private BigDecimal baseMny; // 无税
    private BigDecimal baseTax; // 税额
    private String baseTaxMnyStr; // 有税
    private String baseMnyStr; // 无税
    private String baseTaxStr; // 税额
    // 合同总金额
    private BigDecimal contractTaxMny; // 有税
    private BigDecimal contractMny; // 无税
    private BigDecimal contractTax; // 税额
    private String contractTaxMnyStr; // 有税
    private String contractMnyStr; // 无税
    private String contractTaxStr; // 税额
    // 计价方式：可调单价、固定总价、成本价酬金、费率合同、固定单价
    private String pricingType;
    private Long pricingTypeId;
    // 计税方式
    private String taxCalcTypeName; // 计税方式名称:简易计税、一般计税
    // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; // 合同开工日期
    // 合同竣工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractFinishDate; // 合同竣工日期
    // 备注
    private String memo; // 非必填，0-500字
    // 导入失败原因
    private String errorMessage;

    public Long getPricingTypeId() {
        return pricingTypeId;
    }

    public void setPricingTypeId(Long pricingTypeId) {
        this.pricingTypeId = pricingTypeId;
    }

    public String getTaxRateStr() {
        return taxRateStr;
    }

    public void setTaxRateStr(String taxRateStr) {
        this.taxRateStr = taxRateStr;
    }

    public String getBaseTaxMnyStr() {
        return baseTaxMnyStr;
    }

    public void setBaseTaxMnyStr(String baseTaxMnyStr) {
        this.baseTaxMnyStr = baseTaxMnyStr;
    }

    public String getBaseMnyStr() {
        return baseMnyStr;
    }

    public void setBaseMnyStr(String baseMnyStr) {
        this.baseMnyStr = baseMnyStr;
    }

    public String getBaseTaxStr() {
        return baseTaxStr;
    }

    public void setBaseTaxStr(String baseTaxStr) {
        this.baseTaxStr = baseTaxStr;
    }

    public String getContractTaxMnyStr() {
        return contractTaxMnyStr;
    }

    public void setContractTaxMnyStr(String contractTaxMnyStr) {
        this.contractTaxMnyStr = contractTaxMnyStr;
    }

    public String getContractMnyStr() {
        return contractMnyStr;
    }

    public void setContractMnyStr(String contractMnyStr) {
        this.contractMnyStr = contractMnyStr;
    }

    public String getContractTaxStr() {
        return contractTaxStr;
    }

    public void setContractTaxStr(String contractTaxStr) {
        this.contractTaxStr = contractTaxStr;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    public String getHandleTypeName() {
        return handleTypeName;
    }

    public void setHandleTypeName(String handleTypeName) {
        this.handleTypeName = handleTypeName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Integer getContractProperty() {
        return contractProperty;
    }

    public void setContractProperty(Integer contractProperty) {
        this.contractProperty = contractProperty;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public String getSupplementFlagName() {
        return supplementFlagName;
    }

    public void setSupplementFlagName(String supplementFlagName) {
        this.supplementFlagName = supplementFlagName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getPerformanceStatusName() {
        return performanceStatusName;
    }

    public void setPerformanceStatusName(String performanceStatusName) {
        this.performanceStatusName = performanceStatusName;
    }

    public Long getPartyaId() {
        return partyaId;
    }

    public void setPartyaId(Long partyaId) {
        this.partyaId = partyaId;
    }

    public String getPartyaName() {
        return partyaName;
    }

    public void setPartyaName(String partyaName) {
        this.partyaName = partyaName;
    }

    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }

    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }

    public Long getPartycId() {
        return partycId;
    }

    public void setPartycId(Long partycId) {
        this.partycId = partycId;
    }

    public String getPartycName() {
        return partycName;
    }

    public void setPartycName(String partycName) {
        this.partycName = partycName;
    }

    public Long getJoinPartyId() {
        return joinPartyId;
    }

    public void setJoinPartyId(Long joinPartyId) {
        this.joinPartyId = joinPartyId;
    }

    public String getJoinPartyName() {
        return joinPartyName;
    }

    public void setJoinPartyName(String joinPartyName) {
        this.joinPartyName = joinPartyName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

//    public String getPricingTypeName() {
//        return pricingTypeName;
//    }
//
//    public void setPricingTypeName(String pricingTypeName) {
//        this.pricingTypeName = pricingTypeName;
//    }

    public String getTaxCalcTypeName() {
        return taxCalcTypeName;
    }

    public void setTaxCalcTypeName(String taxCalcTypeName) {
        this.taxCalcTypeName = taxCalcTypeName;
    }

    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public Date getContractFinishDate() {
        return contractFinishDate;
    }

    public void setContractFinishDate(Date contractFinishDate) {
        this.contractFinishDate = contractFinishDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
