package com.ejianc.business.contractbase.pool.contractpool.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/30 17:23
 */
public class SubLeaderReportVO extends BaseVO {
    private static final long serialVersionUID = 3190890054961061030L;

    private List<String> searchTexts = new ArrayList<>();
    private String searchText;
    private String orderName;
    private String orderValue;
    private String startDate;
    private String endDate;
    private Integer startLine;
    private Integer pageSize;

    private String name; // 姓名
    private String idNum; // 身份证号
    private String phone; // 手机号
    private Long grade; // 等级
    private String gradeName; // 等级名称
    private Long supplierId; //  供应商id

    private Boolean coordination; // 是否协同
    private Boolean inException; // 是否异常
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exceptionEndDate; // 异常结束时间
    private Date lastCoDate; // 最近合作时间
    private Long orgId; //项目部Id
    private List<Long> parentOrgId; //组织Id
    private String[] grades; //分包负责人等级

    private Long punishType; // 供应商状态 处置方式 红黑牌等的id
    private Date punishDate; // 处置日期
    private String punishApplyOrg; // 处置申请单位
    private String punishApplyPerson; // 处置申请人
    private String punishOldGrade; // 处置原等级
    private String punishGrade; // 处置等级
    private String punishMemo; // 处置理由

    private String supplierContent; // 供货内容
    private String supplierName; // 供应商的名称
    private String supplierGrade; // 供应商的等级
    private String area; // 供应商的地区
    private String supplierCode; // 供应商的编号
    private String personal; // 供应商的 企业/个人
    private String contentId; // 劳务分包供货内容id
    private String contentIdForTrans; // 劳务分包供货内容id,用于feign数据传输   -_-!!哎

    private Integer cooperationOrgNum; //合作单位：显示分包负责人签订的分包合同的所属单位数量，需要验重，两份合同，所属单位一致，数量+1
    private Integer cooperationProjectNum; //合作项目：显示分包负责人签订的分包合同的所属项目数量，需要验重，两份合同，所属项目一致，数量+1
    private BigDecimal totalSignedContractAmt; //已签订合作金额：根据分包合同关联的分包负责人，统计该分包负责人签订的分包合同金额
    private BigDecimal totalContractSettleAmt; //已结算合同金额：根据结算的合同所属的分包负责人，统计该分包负责人已经结算的（过程金额+完工差额）的金额

    public String[] getGrades() {
        return grades;
    }

    public void setGrades(String[] grades) {
        this.grades = grades;
    }

    public String getContentIdForTrans() {
        return contentIdForTrans;
    }

    public void setContentIdForTrans(String contentIdForTrans) {
        this.contentIdForTrans = contentIdForTrans;
    }

//    @ReferSerialTransfer(referCode="support-defdoc")
    public String getContentId() {
        return contentId;
    }

//    @ReferDeserialTransfer
    public void setContentId(String contentId) {
        this.contentId = contentId;
    }
    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierContent() {
        return supplierContent;
    }

    public void setSupplierContent(String supplierContent) {
        this.supplierContent = supplierContent;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierGrade() {
        return supplierGrade;
    }

    public void setSupplierGrade(String supplierGrade) {
        this.supplierGrade = supplierGrade;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public Boolean getCoordination() {
        return coordination;
    }

    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }

    public Boolean getInException() {
        return inException;
    }

    public void setInException(Boolean inException) {
        this.inException = inException;
    }

    public Date getExceptionEndDate() {
        return exceptionEndDate;
    }

    public void setExceptionEndDate(Date exceptionEndDate) {
        this.exceptionEndDate = exceptionEndDate;
    }

    public Date getLastCoDate() {
        return lastCoDate;
    }

    public void setLastCoDate(Date lastCoDate) {
        this.lastCoDate = lastCoDate;
    }
//    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }

//    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }

    public Date getPunishDate() {
        return punishDate;
    }

    public void setPunishDate(Date punishDate) {
        this.punishDate = punishDate;
    }

    public String getPunishApplyOrg() {
        return punishApplyOrg;
    }

    public void setPunishApplyOrg(String punishApplyOrg) {
        this.punishApplyOrg = punishApplyOrg;
    }

    public String getPunishApplyPerson() {
        return punishApplyPerson;
    }

    public void setPunishApplyPerson(String punishApplyPerson) {
        this.punishApplyPerson = punishApplyPerson;
    }

    public String getPunishOldGrade() {
        return punishOldGrade;
    }

    public void setPunishOldGrade(String punishOldGrade) {
        this.punishOldGrade = punishOldGrade;
    }

    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }

    public String getPunishMemo() {
        return punishMemo;
    }

    public void setPunishMemo(String punishMemo) {
        this.punishMemo = punishMemo;
    }

    /**
     * 姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 姓名
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 身份证号
     */
    public String getIdNum() {
        return idNum;
    }

    /**
     * 身份证号
     */
    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }
    /**
     * 手机号
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 手机号
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 等级
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGrade() {
        return grade;
    }

    /**
     * 等级
     */
    @ReferDeserialTransfer
    public void setGrade(Long grade) {
        this.grade = grade;
    }
    /**
     * 等级名称
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 等级名称
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public List<String> getSearchTexts() {
        return searchTexts;
    }

    public void setSearchTexts(List<String> searchTexts) {
        this.searchTexts = searchTexts;
    }

    public String getSearchText() {
        return searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public String getOrderValue() {
        return orderValue;
    }

    public void setOrderValue(String orderValue) {
        this.orderValue = orderValue;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getCooperationOrgNum() {
        return cooperationOrgNum;
    }

    public void setCooperationOrgNum(Integer cooperationOrgNum) {
        this.cooperationOrgNum = cooperationOrgNum;
    }

    public Integer getCooperationProjectNum() {
        return cooperationProjectNum;
    }

    public void setCooperationProjectNum(Integer cooperationProjectNum) {
        this.cooperationProjectNum = cooperationProjectNum;
    }

    public BigDecimal getTotalSignedContractAmt() {
        return totalSignedContractAmt;
    }

    public void setTotalSignedContractAmt(BigDecimal totalSignedContractAmt) {
        this.totalSignedContractAmt = totalSignedContractAmt;
    }

    public BigDecimal getTotalContractSettleAmt() {
        return totalContractSettleAmt;
    }

    public void setTotalContractSettleAmt(BigDecimal totalContractSettleAmt) {
        this.totalContractSettleAmt = totalContractSettleAmt;
    }

    public Integer getStartLine() {
        return startLine;
    }

    public void setStartLine(Integer startLine) {
        this.startLine = startLine;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public List<Long> getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(List<Long> parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
}
