package com.ejianc.business.contractbase.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.List;

/**
 * @author:刘家乐
 * @date:2021/11/8
 * @document:
 */
public class TemplateCategoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 分类名称
     */
    private String categoryName;
    /**
     *内码 规则通选择的是顶级分类是本身id
     *子类是父id
     */
    private String innerCode;
    /**
     *父id
     */
    private Long pid;

    /**
     * 父级分类名称
     */
    private String pName;
    /**
     *启用状态：0-停用，1-启用
     */
    private Integer enableStatus;
    /**
     * 类别：0-内置项，1-新增项
     */
    private Integer sourceType;
    /**
     *编码规则
     */
    private String code;
    /**
     *排序
     */
    private Integer sequence;
    /**
     * 分类属性：每个大的分类下该属性保持一致', 这里选择的是顶级分类是本身id
     * 子类是父id
     */
    private String  categoryProperty;
    /**
     * 是否顶级 0-固定分类，1-下级分类
     */
    private Integer isTop;

    /**
     * 对应单据类型
     */
    private String billTypeCode;

    /**
     * 合同属性id
     */
    private Long contractPropertyId;
    /**
     * 合同属性编码
     */
    private String contractPropertyCode;
    /**
     * 合同属性名称
     */
    private String contractPropertyName;

    /**
     * 所属组织Id
     */
    private Long belongOrgId;
    /**
     * 所属组织名称
     */
    private String belongOrgName;
    /**
     * 所属组织编码
     */
    private String belongOrgCode;

    /**
     * 所属组织内码
     */
    private String belongOrgInnerCode;

    public String getBelongOrgInnerCode() {
        return belongOrgInnerCode;
    }

    public void setBelongOrgInnerCode(String belongOrgInnerCode) {
        this.belongOrgInnerCode = belongOrgInnerCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBelongOrgId() {
        return belongOrgId;
    }

    @ReferDeserialTransfer
    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }

    public String getBelongOrgCode() {
        return belongOrgCode;
    }

    public void setBelongOrgCode(String belongOrgCode) {
        this.belongOrgCode = belongOrgCode;
    }

    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }

    public String getpName() {
        return pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    @ReferDeserialTransfer
    public Long getContractPropertyId() {
        return contractPropertyId;
    }

    public void setContractPropertyId(Long contractPropertyId) {
        this.contractPropertyId = contractPropertyId;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    private List<TemplateCategoryVO> children;

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public List<TemplateCategoryVO> getChildren() {
        return children;
    }

    public void setChildren(List<TemplateCategoryVO> children) {
        this.children = children;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public Long getPid() {
        return pid;
    }


    @ReferDeserialTransfer
    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public Integer getIsTop() {
        return isTop;
    }

    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }
}
