package com.ejianc.business.contractbase.vo.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同费用类型枚举
 *
 */
public enum ContractFeeTypeEnum {
    /**
     * 合同类型：周转材合同
     */
    周转材合同("rmat", "周转材租入合同"),

    /**
     * 合同类型：混凝土合同
     */
    混凝土合同("contractConcrete", "混凝土采购合同"),

    /**
     * 合同类型：设备租赁
     */
    设备租赁("equipmentRent", "项目维度设备租赁合同"),

    /**
     * 合同类型：设备采购
     */
    设备采购("equipmentPurchase", "项目维度设备采购合同"),

    /**
     * 合同类型：物资采购合同
     */
    物资采购合同("contractMaterial", "消耗材合同"),

    /**
     * 合同类型：专业分包合同
     */
    专业分包合同("proSub", "专业分包合同"),

    /**
     * 合同类型：劳务分包合同
     */
    劳务分包合同("laborSub", "劳务分包合同"),

    /**
     * 合同类型：劳务分包合同（本地使用）
     */
    劳务分包合同dev("laborsub", "劳务分包合同"),

    /**
     * 合同类型：其他支出合同
     */
    其他支出("contractOther", "其他支出合同");



    ContractFeeTypeEnum(String contractTypeCode, String contractFeeTypeName) {
        this.contractTypeCode = contractTypeCode;
        this.contractFeeTypeName = contractFeeTypeName;
    }

    //合同大类
    private String contractTypeCode;
    //合同业务费用类型名称
    private String contractFeeTypeName;
    private static Map<String, ContractFeeTypeEnum> enumMap = new HashMap<>();

    public String getContractTypeCode() {
        return contractTypeCode;
    }

    public void setContractTypeCode(String contractTypeCode) {
        this.contractTypeCode = contractTypeCode;
    }

    public String getContractFeeTypeName() {
        return contractFeeTypeName;
    }

    public void setContractFeeTypeName(String contractFeeTypeName) {
        this.contractFeeTypeName = contractFeeTypeName;
    }

    public static Map<String, ContractFeeTypeEnum> getEnumMap() {
        return enumMap;
    }

    public static void setEnumMap(Map<String, ContractFeeTypeEnum> enumMap) {
        ContractFeeTypeEnum.enumMap = enumMap;
    }

    static {
        enumMap = EnumSet.allOf(ContractFeeTypeEnum.class).stream().collect(Collectors.toMap(ContractFeeTypeEnum::getContractTypeCode, Function.identity(), (k1, k2) -> k2));
    }


    public static ContractFeeTypeEnum getByCode(String contractTypeCode) {
        return enumMap.get(contractTypeCode);
    }
}
