package com.ejianc.business.contractbase.pool.settlepool.vo;

import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算池主实体VO
 *
 * @author generator
 */
public class SettlePoolVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    // 结算池表字段
    private Long sourceId; // 结算单来源
    private String sourceType; // 结算单类型
    private String sourceTypeName; // 结算单类型
    private Integer settleProperty; // 属性类别，0支出，1收入
    private String settlePropertyName; // 属性类别名称，0支出，1收入
    private Long settleId;// 结算单位id
    private String settleCode;// 结算单位编码
    private String settleName;// 结算单位名称
    private Integer contractFlag;// 是否有合同：1-是，0-否
    private String contractFlagName;// 是否有合同：1-是，0-否
    private Integer handleType;// 是否手动新增：1-是，0-否
    private Long payTypeNoContractId;// 无合同费用类型id
    private String payTypeNoContractCode;// 无合同费用类型编码
    private String payTypeNoContractName;// 无合同费用类型名称
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billStateName; // 单据状态名称 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private String contractType; // 合同类型
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    private Long maiContractId; // 主合同id
    private String maiContractName; // 主合同名称
    private String maiContractCode; // 主合同编码
    private String partyaCode; // 甲方编码
    private Long partyaId; // 甲方id
    private String partyaName; // 甲方名称
    private String partybCode; // 乙方编码
    private Long partybId; // 乙方id
    private String partybName; // 乙方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private BigDecimal curTaxMny; // 本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额
    private BigDecimal curMny; // 本期结算金额(无税)
    private BigDecimal curTax; // 本期结算税额
    private Integer ultimateFlag; // 是否最终结算：0否，1是
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门名称
    private String memo; // 非必填，0-500字
    private BigDecimal lastTaxMny; // 截止本期已结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额
    private BigDecimal lastMny; // 截止本期已结算金额(无税)
    private BigDecimal lastTax; // 截止本期税额


    private BigDecimal totalSettlePaymentTaxMny;//累计结算支付金额（含税）
    private BigDecimal totalSettlePaymentMny;//累计结算支付金额（无税）
    private BigDecimal totalApplyPaymentTaxMny;//累计申请支付金额（含税）
    private BigDecimal totalApplyPaymentMny;//累计申请支付金额（无税）

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 结算单类型 优化字段
    private String sourceTypeNameStr; // 扩展字段
    private String ext2; // 扩展字段
    private String ext3; // 扩展字段
    private String ext4; // 扩展字段
    private String ext5; // 扩展字段
    private String ext6; // 扩展字段
    private String ext7; // 扩展字段
    private String ext8; // 扩展字段

    private Integer filingStatus;//是否归档 1：是；0：否
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否


    //导出使用字段
    private String handleTypeStr; //数据来源

    public String getHandleTypeStr() {
        return handleTypeStr;
    }

    public void setHandleTypeStr(String handleTypeStr) {
        this.handleTypeStr = handleTypeStr;
    }

    public Long getPayTypeNoContractId() {
        return payTypeNoContractId;
    }

    @ReferDeserialTransfer
    public void setPayTypeNoContractId(Long payTypeNoContractId) {
        this.payTypeNoContractId = payTypeNoContractId;
    }

    public String getPayTypeNoContractCode() {
        return payTypeNoContractCode;
    }

    public void setPayTypeNoContractCode(String payTypeNoContractCode) {
        this.payTypeNoContractCode = payTypeNoContractCode;
    }

    public String getPayTypeNoContractName() {
        return payTypeNoContractName;
    }

    public void setPayTypeNoContractName(String payTypeNoContractName) {
        this.payTypeNoContractName = payTypeNoContractName;
    }

    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    public String getContractFlagName() {
        return contractFlagName;
    }

    public void setContractFlagName(String contractFlagName) {
        this.contractFlagName = contractFlagName;
    }

    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    @ReferDeserialTransfer
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    /**
     * 来源结算单号穿透URL
     */
    private String billCodeUrl;

    /**
     * 合同编号穿透URL
     */
    private String contractUrl;

    /**
     * 已申请金额
     */
    private BigDecimal alreadyApplyMny;

    /**
     * 剩余可申请金额
     */
    private BigDecimal residueApplyMny;


    private String partyaUrl;

    /**
     * 乙方URL
     */
    private String partybUrl;

    /**
     * 合同编码URL
     */
    private String projectUrl;

    /**
     * 只更新非空字段
     */
    private String updateLevel = UpdateLevelEnum.更新非NULL字段.getLevelCode();

    private BigDecimal totalProcessTaxMny; // 完工单累计过程结算金额
    private BigDecimal totalProcessMny; // 完工单过程结算金额(无税)
    private BigDecimal totalProcessTaxDifference; // 完工单过程结算差额
    private BigDecimal totalProcessDifference; // 完工单过程结算差额（无税）

    private BigDecimal totalNodeTaxMny; // 完工单累计节点结算金额
    private BigDecimal totalNodeMny; // 完工单累计节点结算金额(无税)
    private BigDecimal totalNodeTaxDifference; // 完工单节点结算差额
    private BigDecimal totalNodeDifference; // 完工单节点结算差额（无税）

//    分包完工单使用字段，分包完工单结算金额使用此字段，本期结算金额传递完工结算差额
    private BigDecimal finishCurTaxMny; //完工结算单本期结算金额（含税）
    private BigDecimal finishCurMny; //完工结算单本期结算金额(无税)
    private BigDecimal finishCurTax; //完工结算单本期结算税额

    private BigDecimal quoteMny; //本次上报金额（无税）
    private BigDecimal quoteTaxMny; //本次上报金额
    private BigDecimal quoteTax; //本次上报税额

    //单据类型名称字段
    /**
     * 结算单类型名称
     */
    private String settleSourceTypeName;

    /**
     * 合同类型名称
     */
    private String contractTypeName;

    private BigDecimal displaySettleTaxMny; //列表展示本期结算金额

    public BigDecimal getDisplaySettleTaxMny() {
        return SettleSourceTypeEnum.专业分包最终结算.getCode().equals(this.sourceType) || SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(this.sourceType) ? (null != this.totalNodeTaxDifference ? this.totalNodeTaxDifference : BigDecimal.ZERO) : this.curTaxMny;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public String getSettleSourceTypeName() {
        return settleSourceTypeName;
    }

    public void setSettleSourceTypeName(String settleSourceTypeName) {
        this.settleSourceTypeName = settleSourceTypeName;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public BigDecimal getTotalProcessTaxMny() {
        return totalProcessTaxMny;
    }

    public void setTotalProcessTaxMny(BigDecimal totalProcessTaxMny) {
        this.totalProcessTaxMny = totalProcessTaxMny;
    }

    public BigDecimal getTotalProcessMny() {
        return totalProcessMny;
    }

    public void setTotalProcessMny(BigDecimal totalProcessMny) {
        this.totalProcessMny = totalProcessMny;
    }

    public BigDecimal getTotalProcessTaxDifference() {
        return totalProcessTaxDifference;
    }

    public void setTotalProcessTaxDifference(BigDecimal totalProcessTaxDifference) {
        this.totalProcessTaxDifference = totalProcessTaxDifference;
    }

    public BigDecimal getTotalProcessDifference() {
        return totalProcessDifference;
    }

    public void setTotalProcessDifference(BigDecimal totalProcessDifference) {
        this.totalProcessDifference = totalProcessDifference;
    }

    public BigDecimal getTotalNodeTaxMny() {
        return totalNodeTaxMny;
    }

    public void setTotalNodeTaxMny(BigDecimal totalNodeTaxMny) {
        this.totalNodeTaxMny = totalNodeTaxMny;
    }

    public BigDecimal getTotalNodeMny() {
        return totalNodeMny;
    }

    public void setTotalNodeMny(BigDecimal totalNodeMny) {
        this.totalNodeMny = totalNodeMny;
    }

    public BigDecimal getTotalNodeTaxDifference() {
        return totalNodeTaxDifference;
    }

    public void setTotalNodeTaxDifference(BigDecimal totalNodeTaxDifference) {
        this.totalNodeTaxDifference = totalNodeTaxDifference;
    }

    public BigDecimal getTotalNodeDifference() {
        return totalNodeDifference;
    }

    public void setTotalNodeDifference(BigDecimal totalNodeDifference) {
        this.totalNodeDifference = totalNodeDifference;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public Integer getSettleProperty() {
        return settleProperty;
    }

    public void setSettleProperty(Integer settleProperty) {
        this.settleProperty = settleProperty;
    }

    public String getSettlePropertyName() {
        return settlePropertyName;
    }

    public void setSettlePropertyName(String settlePropertyName) {
        this.settlePropertyName = settlePropertyName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getMaiContractId() {
        return maiContractId;
    }

    public void setMaiContractId(Long maiContractId) {
        this.maiContractId = maiContractId;
    }

    public String getMaiContractName() {
        return maiContractName;
    }

    public void setMaiContractName(String maiContractName) {
        this.maiContractName = maiContractName;
    }

    public String getMaiContractCode() {
        return maiContractCode;
    }

    public void setMaiContractCode(String maiContractCode) {
        this.maiContractCode = maiContractCode;
    }

    public String getPartyaCode() {
        return partyaCode;
    }

    public void setPartyaCode(String partyaCode) {
        this.partyaCode = partyaCode;
    }

    public Long getPartyaId() {
        return partyaId;
    }

    @ReferDeserialTransfer
    public void setPartyaId(Long partyaId) {
        this.partyaId = partyaId;
    }

    public String getPartyaName() {
        return partyaName;
    }

    public void setPartyaName(String partyaName) {
        this.partyaName = partyaName;
    }

    public String getPartybCode() {
        return partybCode;
    }

    public void setPartybCode(String partybCode) {
        this.partybCode = partybCode;
    }

    public Long getPartybId() {
        return partybId;
    }

    @ReferDeserialTransfer
    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }

    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public BigDecimal getCurTaxMny() {
        return curTaxMny;
    }

    public void setCurTaxMny(BigDecimal curTaxMny) {
        this.curTaxMny = curTaxMny;
    }

    public BigDecimal getCurMny() {
        return curMny;
    }

    public void setCurMny(BigDecimal curMny) {
        this.curMny = curMny;
    }

    public BigDecimal getCurTax() {
        return curTax;
    }

    public void setCurTax(BigDecimal curTax) {
        this.curTax = curTax;
    }

    public Integer getUltimateFlag() {
        return ultimateFlag;
    }

    public void setUltimateFlag(Integer ultimateFlag) {
        this.ultimateFlag = ultimateFlag;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }

    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }

    public BigDecimal getLastTax() {
        return lastTax;
    }

    public void setLastTax(BigDecimal lastTax) {
        this.lastTax = lastTax;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSourceTypeNameStr() {
        return sourceTypeNameStr;
    }

    public void setSourceTypeNameStr(String sourceTypeNameStr) {
        this.sourceTypeNameStr = sourceTypeNameStr;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getBillCodeUrl() {
        return billCodeUrl;
    }

    public void setBillCodeUrl(String billCodeUrl) {
        this.billCodeUrl = billCodeUrl;
    }

    public String getContractUrl() {
        return contractUrl;
    }

    public void setContractUrl(String contractUrl) {
        this.contractUrl = contractUrl;
    }

    public BigDecimal getAlreadyApplyMny() {
        return alreadyApplyMny;
    }

    public void setAlreadyApplyMny(BigDecimal alreadyApplyMny) {
        this.alreadyApplyMny = alreadyApplyMny;
    }

    public BigDecimal getResidueApplyMny() {
        return residueApplyMny;
    }

    public void setResidueApplyMny(BigDecimal residueApplyMny) {
        this.residueApplyMny = residueApplyMny;
    }

    public String getPartyaUrl() {
        return partyaUrl;
    }

    public void setPartyaUrl(String partyaUrl) {
        this.partyaUrl = partyaUrl;
    }

    public String getPartybUrl() {
        return partybUrl;
    }

    public void setPartybUrl(String partybUrl) {
        this.partybUrl = partybUrl;
    }

    public String getProjectUrl() {
        return projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String getUpdateLevel() {
        return updateLevel;
    }

    public void setUpdateLevel(String updateLevel) {
        this.updateLevel = updateLevel;
    }

    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }

    public BigDecimal getTotalSettlePaymentMny() {
        return totalSettlePaymentMny;
    }

    public void setTotalSettlePaymentMny(BigDecimal totalSettlePaymentMny) {
        this.totalSettlePaymentMny = totalSettlePaymentMny;
    }

    public BigDecimal getTotalApplyPaymentTaxMny() {
        return totalApplyPaymentTaxMny;
    }

    public void setTotalApplyPaymentTaxMny(BigDecimal totalApplyPaymentTaxMny) {
        this.totalApplyPaymentTaxMny = totalApplyPaymentTaxMny;
    }

    public BigDecimal getTotalApplyPaymentMny() {
        return totalApplyPaymentMny;
    }

    public void setTotalApplyPaymentMny(BigDecimal totalApplyPaymentMny) {
        this.totalApplyPaymentMny = totalApplyPaymentMny;
    }

    public BigDecimal getFinishCurTaxMny() {
        return finishCurTaxMny;
    }

    public void setFinishCurTaxMny(BigDecimal finishCurTaxMny) {
        this.finishCurTaxMny = finishCurTaxMny;
    }

    public BigDecimal getFinishCurMny() {
        return finishCurMny;
    }

    public void setFinishCurMny(BigDecimal finishCurMny) {
        this.finishCurMny = finishCurMny;
    }

    public BigDecimal getFinishCurTax() {
        return finishCurTax;
    }

    public void setFinishCurTax(BigDecimal finishCurTax) {
        this.finishCurTax = finishCurTax;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }

    public BigDecimal getQuoteTax() {
        return quoteTax;
    }

    public void setQuoteTax(BigDecimal quoteTax) {
        this.quoteTax = quoteTax;
    }
}
