package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.ContractFillingHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author CJ
 * @Description:
 * @date 2022/7/28 18:13
 */
@FeignClient(name = "ejc-contractbase-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-contractbase-web", fallback = ContractFillingHystrix.class)
public interface IContractFillingApi {

    @PostMapping(value = "/api/contractfiling/updateFilingStatus")
    CommonResponse<String> updateFilingStatus(@RequestBody String updateParamJson);

}
