package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.TemplDetailHystrix;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/9 14:37
 */
@FeignClient(name = "ejc-contractbase-web", url = "${common.env.feign-client-url}", path = "ejc-contractbase-web", fallback = TemplDetailHystrix.class)
public interface ITemplDetailApi {

    @GetMapping(value = "/api/templDetail/findExportDetailByCategoryId")
    CommonResponse<List<TemplDetailExportSettingVO>> findExportDetailByCategoryId(@RequestParam(required = false) Long categoryId,
                                                                                  @RequestParam(required = false)  Long templateId);

}
