package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.TemplateCategoryHystrix;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 模板类别管理API
 *
 * @author CJ
 * @Description: 模板类别管理API
 * @date 2021/11/10 17:50
 */
@FeignClient(name = "ejc-contractbase-web", url = "${common.env.feign-client-url}", path = "ejc-contractbase-web", fallback = TemplateCategoryHystrix.class)
public interface ITemplateCategoryApi {

    /**
     * 根据模板分类Id查询模板类别信息
     *
     * @param id 模板Id
     * @return
     */
    @GetMapping(value = "/api/template/queryTmplCategoryById")
    public CommonResponse<TemplateCategoryVO> queryTmplCategoryById(@RequestParam(value = "id") Long id);

    /**
     * 根据分类查询其本身及其子分类
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/api/template/querySelfAndChildById")
    public CommonResponse<List<TemplateCategoryVO>> querySelfAndChildById(@RequestParam(value = "id") Long id);


    @PostMapping(value = "/api/categoty/selectTemplateCategoriesByIds")
    public CommonResponse<List<TemplateCategoryVO>> selectTemplateCategoriesByIds(@RequestBody List<Long> ids);
}
