package com.ejianc.business.contractbase.home.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 编码常量翻译
 */
public enum DevTypeEnum {

    // 实施方式:1、自营；2、联营
    自营("1", "自营"),
    联营("2", "联营"),
    nullv(null, null),
    ;

    private final String name;
    private final String code;
    private static Map<String, DevTypeEnum> enumMap = new HashMap();

    private DevTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static DevTypeEnum getEnumByCode(String code) {
        return (DevTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(DevTypeEnum.class).stream().collect(Collectors.toMap(DevTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
