package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 最终结算标识枚举
 */
public enum SettleUltimateFlagEnum {

    /**
     * 最终结算
     */
    最终结算(1, "最终结算"),

    /**
     * 非最终结算
     */
    非最终结算(0, "非最终结算");


    SettleUltimateFlagEnum(Integer code, String codeName) {
        this.code = code;
        this.codeName = codeName;
    }

    private Integer code;
    private String codeName;

    private static Map<String, ContractTypeEnum> enumMap = new HashMap<>();

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getCodeName() {
        return codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    static {
        enumMap = EnumSet.allOf(ContractTypeEnum.class).stream().collect(Collectors.toMap(ContractTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

}
