package com.ejianc.business.contractbase.filing.enums;

import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FilingTypeEnum {

    材料采购("contractMaterial","材料采购"),
    混凝土采购("contractConcrete","混凝土采购"),
    周转材租赁 ("rmat","周转材租赁"),
    专业分包("proSub","专业分包"),
    劳务分包("laborSub","劳务分包"),
    设备租赁合同("equipmentRent","设备租赁合同"),
    设备采购合同("equipmentPurchase","设备采购合同"),
    安拆合同("contractAC","安拆合同"),
    其他支出("contractOther", "其他合同");

    FilingTypeEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    private String typeCode;
    private String typeName;
    private static Map<String, FilingTypeEnum> enumMap = new HashMap<>();

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(FilingTypeEnum.class).stream().collect(Collectors.toMap(FilingTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static FilingTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }
}
