package com.ejianc.business.contractbase.pool.contractpool.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;


public class ContractPoolNameVO extends BaseVO {

    private String orgId; // 项目id orgName
    private String orgCode; // 项目编码
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String signDate; // 签订日期
    private Long customerId; // 合同甲方Id   partyaId
    private String customerName; // 合同甲方名称 partyaName
    private Long supplierId; // 合同乙方Id partybId
    private String supplierCode; // 合同乙方名称  partybName
    private String constructionPartner; // 联合体方名称 joinPartyName
    private String contractPartyc; // 合同丙方名称 partycName
    private BigDecimal taxRate; // 合同税率
    private BigDecimal contractTaxMny; // 合同总金额（含税）
    private BigDecimal contractMny; // 合同总金额（不含税）
    private String startDate ; // 合同开工日期 contractStartDate
    private String endDate; // 合同竣工日期 contractFinishDate
    private Integer schedule; // 合同工期:合同工期=同竣工日期-开工日期+1（单位：天） contractDaysLimit

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；
     * 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。
     * 当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String contractStatus ;// performanceStatus
    private BigDecimal costChangeTotalMny; // 合同累计变更金额（不含税） totalChangeMny
    private BigDecimal costChangeTotalTaxMny; // 合同累计变更金额（含税） totalChangeTaxMny


    /**
     * 经办人   employeeName
     */
    private String employeeId;

    /**
     * 经办部门名称
     */
    private String deptId;//  departmentName;


    private BigDecimal estimationTaxMny; // 含税暂估金额
    private String areaName; // 所在地区
    private String address; // 详细地址
    private String engineeringType; // 工程类别
    private String isEstimation; // 是否暂估合同：0-否，1-是
    /**
     * 来源业务单据类型名称
     */
    private String sourceTypeName;

    private String cwProjectCode;// 财务账套编号
    private Integer purchaseMethod;// 采购方式（1：直采2：代采）


    public Integer getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(Integer purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }


    public String getCwProjectCode() {
        return cwProjectCode;
    }

    public void setCwProjectCode(String cwProjectCode) {
        this.cwProjectCode = cwProjectCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(String isEstimation) {
        this.isEstimation = isEstimation;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getSignDate() {
        return signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getConstructionPartner() {
        return constructionPartner;
    }

    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }

    public String getContractPartyc() {
        return contractPartyc;
    }

    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getSchedule() {
        return schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public BigDecimal getEstimationTaxMny() {
        return estimationTaxMny;
    }

    public void setEstimationTaxMny(BigDecimal estimationTaxMny) {
        this.estimationTaxMny = estimationTaxMny;
    }
}
