package com.ejianc.business.contractbase.pool.contractpool.vo;

import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
public class ContractPoolVO extends BaseVO {

    private static final long serialVersionUID = -7704541980055959188L;

    /**
     * 更新字段策略
     */
    private String updateLevel = UpdateLevelEnum.更新非NULL字段.getLevelCode();

    private Integer handleType;// 是否手动新增：1-是，0-否
    private Long contractId; // 合同Id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long categoryId; // 合同分类Id
    private String categoryName; // 合同分类名称
    private String categoryProperty; // 合同分类属性
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String supplementFlagName; // 是否补充协议名称(1:是，0：否)
    private Long mainContractId; // 主合同Id
    private String mainContractName; // 主合同名称
    private String mainContractCode; // 主合同编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Long partyaId; // 合同甲方Id
    private String partyaName; // 合同甲方名称
    private Long partybId; // 合同乙方Id
    private String partybName; // 合同乙方名称
    private Long partycId; // 合同丙方Id
    private String partycName; // 合同丙方名称
    private Long joinPartyId; // 联合体方Id
    private String joinPartyName; // 联合体方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String signPlace; // 签订地点
    /**
     * 工程地点
     */
    private String projectAddress;
    private String pricingType; // 计价方式：可调单价、固定总价、成本加酬金、费率合同、固定单价
    private Long pricingTypeId; // 计价方式：可调单价、固定总价、成本价酬金、费率合同、固定单价
    private String taxCalcTypeName; // 计税方式名称:简易计税、一般计税
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractFinishDate; // 合同竣工日期
    private Integer contractDaysLimit; // 合同工期:合同工期=同竣工日期-开工日期+1（单位：天）
    private Integer purchaseType; // 采购类型: 1-自采，2-集采
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeStatusName; // 变更状态名称(1-未变更 2-变更中 3-已变更)
    private BigDecimal taxRate; // 合同税率
    private BigDecimal baseTaxMny; // 合同签订(合同初始)金额（含税）
    private BigDecimal baseMny; // 合同签订(合同初始)金额（不含税）
    private BigDecimal baseTax; // 合同签订(合同初始)税额
    private BigDecimal contractTaxMny; // 合同总金额（含税）
    private BigDecimal contractMny; // 合同总金额（不含税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal totalChangeTaxMny; // 合同累计变更金额（含税）
    private BigDecimal totalChangeMny; // 合同累计变更金额（不含税）
    private BigDecimal totalChangeTax; // 合同累计变更金额税额
    private BigDecimal taotalChangeScale; // 合同累计变更比例
    private BigDecimal totalShouldInOutTaxMny; // 累计应收/应付金额（含税）
    private BigDecimal totalShouldInOutMny; // 累计应收/应付金额（不含税）
    private BigDecimal totalShouldInOutTax; // 累计应收/应付税额
    private BigDecimal totalPaymentApplyTaxMny; // 累计付款申请金额（含税）
    private BigDecimal totalPaymentApplyMny; // 累计付款申请金额（不含税）
    private BigDecimal totalPaymentApplyTax; // 累计付款申请金额税额
    private BigDecimal totalOpenInvoiceApplyTaxMny; // 累计开票申请金额（含税）
    private BigDecimal totalOpenInvoiceApplyMny; // 累计开票申请金额（不含税）
    private BigDecimal totalOpenInvoiceApplyTax; // 累计开票申请金额税额
    private BigDecimal totalOpenRecInvoiceTaxMny; // 累计开/收票金额（含税）
    private BigDecimal totalOpenRecInvoiceMny; // 累计开/收票金额（不含税）
    private BigDecimal totalOpenRecInvoiceTax; // 累计开/收票金额税额
    private BigDecimal totalActualPayRecTaxMny; // 累计实收/付金额（含税）
    private BigDecimal totalActualPayRecMny; // 累计实收/付金额（不含税）
    private BigDecimal totalActualPayRecTax; // 累计实收/付金额税额
    private BigDecimal totalSettleDevidePayRecScale; // 累计结算/收付款比例
    private BigDecimal contractTaxMnyDevidePayRecScale; // 合同金额/收付款比例
    private BigDecimal totalInvoiceTaxMnyDevidePayRecScale; // 累计发票金额/收付款比例
    private Long sourceId; //

    private Integer filingStatus;//是否归档 1：是；0：否
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    /**
     * 是否将当前状态同步至合同单据
     */
    private Boolean syncWithContractBill = false;

    /*** 导出使用字段 ***/
    private String handleTypeStr; //是否手动新增：1-是，0-否

    public String getHandleTypeStr() {
        return handleTypeStr;
    }

    public void setHandleTypeStr(String handleTypeStr) {
        this.handleTypeStr = handleTypeStr;
    }

    public Long getPricingTypeId() {
        return pricingTypeId;
    }

    @ReferDeserialTransfer
    public void setPricingTypeId(Long pricingTypeId) {
        this.pricingTypeId = pricingTypeId;
    }

    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    /**
     * 合同属性：1-收入，0支出
     */
    private Integer contractProperty;
    /**
     * 合同属性名称：1-收入，0支出
     */
    private String contractPropertyName;

    /**
     * 来源单业务单据类型：
     */
    private String sourceType;

    /**
     * 来源业务单据类型名称
     */
    private String sourceTypeName;

    /**
     * 单据PC端详情路由地址
     */
    private String pcCardUrl;

    /**
     * 单据移动端详情路由地址
     */
    private String mobileCardUrl;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废； 5、已冻结  默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String performanceStatus;
    /**
     * 合同履约状态名称：1、未签订；2、履约中；3、已终止；4、已作废； 5、已冻结  默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String performanceStatusName;

    /**
     * 经办人Id
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办人电话
     */
    private String employeePhone;

    /**
     * 经办部门id
     */
    private Long departmentId;

    /**
     * 经办部门名称
     */
    private String departmentName;

    /**
     * 备注
     */
    private String memo;

    /**
     * 合同累计结算金额(含税)
     */
    private BigDecimal totalSettleTaxMny;
    /**
     * 合同累计结算金额(无税)
     */
    private BigDecimal totalSettleMny;
    /**
     * 合同累计结算税额
     */
    private BigDecimal totalSettleTax;

    /**
     * 数据来源：1-业务系统数据推送，2-手工录入
     */
    private Integer addType;

    private Long supplierProjectManagerId;// 乙方负责人/乙方项目经理id
    /**
     * 乙方负责人/乙方项目经理名称
     */
    private String supplierProjectManagerName;

    /**
     * 乙方负责人/乙方项目经理联系电话
     */
    private String supplierProjectManagerLink;

    /**
     * 完工结算单生效日期
     */
    private Date finishSettleDate;

    /**
     * 二次经营申请金额含税
     */
    private BigDecimal totalClaimTaxMny;

    /**
     * 二次经营申请金额无税
     */
    private BigDecimal totalClaimMny;

    /**
     * 二次经营申请金额税额
     */
    private BigDecimal totalClaimTax;

    /**
     * 二次经营批复金额含税
     */
    private BigDecimal totalTeplyTaxMny;

    /**
     * 二次经营批复金额无税
     */
    private BigDecimal totalTeplyMny;

    /**
     * 二次经营批复金额税额
     */
    private BigDecimal totalTeplyTax;

    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    private BigDecimal provisionalMny; // 暂列金额
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    private String cwProjectCode;// 财务账套编号
    private Integer purchaseMethod;// 采购方式（1：直采2：代采）


    public Integer getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(Integer purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getCwProjectCode() {
        return cwProjectCode;
    }

    public void setCwProjectCode(String cwProjectCode) {
        this.cwProjectCode = cwProjectCode;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public BigDecimal getTotalClaimTaxMny() {
        return totalClaimTaxMny;
    }

    public void setTotalClaimTaxMny(BigDecimal totalClaimTaxMny) {
        this.totalClaimTaxMny = totalClaimTaxMny;
    }

    public BigDecimal getTotalClaimMny() {
        return totalClaimMny;
    }

    public void setTotalClaimMny(BigDecimal totalClaimMny) {
        this.totalClaimMny = totalClaimMny;
    }

    public BigDecimal getTotalClaimTax() {
        return totalClaimTax;
    }

    public void setTotalClaimTax(BigDecimal totalClaimTax) {
        this.totalClaimTax = totalClaimTax;
    }

    public BigDecimal getTotalTeplyTaxMny() {
        return totalTeplyTaxMny;
    }

    public void setTotalTeplyTaxMny(BigDecimal totalTeplyTaxMny) {
        this.totalTeplyTaxMny = totalTeplyTaxMny;
    }

    public BigDecimal getTotalTeplyMny() {
        return totalTeplyMny;
    }

    public void setTotalTeplyMny(BigDecimal totalTeplyMny) {
        this.totalTeplyMny = totalTeplyMny;
    }

    public BigDecimal getTotalTeplyTax() {
        return totalTeplyTax;
    }

    public void setTotalTeplyTax(BigDecimal totalTeplyTax) {
        this.totalTeplyTax = totalTeplyTax;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    private List<ContractSubPaymentNodeVO> contractSubPaymentNodeList = new ArrayList<>(); // 合同付款节点子实体

    public String getUpdateLevel() {
        return updateLevel;
    }

    public void setUpdateLevel(String updateLevel) {
        this.updateLevel = updateLevel;
    }

    public Integer getContractProperty() {
        return contractProperty;
    }

    public void setContractProperty(Integer contractProperty) {
        this.contractProperty = contractProperty;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    @ReferDeserialTransfer
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getPcCardUrl() {
        return pcCardUrl;
    }

    public void setPcCardUrl(String pcCardUrl) {
        this.pcCardUrl = pcCardUrl;
    }

    public String getMobileCardUrl() {
        return mobileCardUrl;
    }

    public void setMobileCardUrl(String mobileCardUrl) {
        this.mobileCardUrl = mobileCardUrl;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @ReferDeserialTransfer
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public String getSupplementFlagName() {
        return supplementFlagName;
    }

    public void setSupplementFlagName(String supplementFlagName) {
        this.supplementFlagName = supplementFlagName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    @ReferDeserialTransfer
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    @ReferDeserialTransfer
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferDeserialTransfer
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferDeserialTransfer
    public Long getPartyaId() {
        return partyaId;
    }

    public void setPartyaId(Long partyaId) {
        this.partyaId = partyaId;
    }
    public String getPartyaName() {
        return partyaName;
    }

    public void setPartyaName(String partyaName) {
        this.partyaName = partyaName;
    }

    @ReferDeserialTransfer
    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }
    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }

    @ReferDeserialTransfer
    public Long getPartycId() {
        return partycId;
    }

    public void setPartycId(Long partycId) {
        this.partycId = partycId;
    }
    public String getPartycName() {
        return partycName;
    }

    public void setPartycName(String partycName) {
        this.partycName = partycName;
    }

    @ReferDeserialTransfer
    public Long getJoinPartyId() {
        return joinPartyId;
    }

    public void setJoinPartyId(Long joinPartyId) {
        this.joinPartyId = joinPartyId;
    }
    public String getJoinPartyName() {
        return joinPartyName;
    }

    public void setJoinPartyName(String joinPartyName) {
        this.joinPartyName = joinPartyName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public String getTaxCalcTypeName() {
        return taxCalcTypeName;
    }

    public void setTaxCalcTypeName(String taxCalcTypeName) {
        this.taxCalcTypeName = taxCalcTypeName;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getContractFinishDate() {
        return contractFinishDate;
    }

    public void setContractFinishDate(Date contractFinishDate) {
        this.contractFinishDate = contractFinishDate;
    }
    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTotalChangeTaxMny() {
        return totalChangeTaxMny;
    }

    public void setTotalChangeTaxMny(BigDecimal totalChangeTaxMny) {
        this.totalChangeTaxMny = totalChangeTaxMny;
    }
    public BigDecimal getTotalChangeMny() {
        return totalChangeMny;
    }

    public void setTotalChangeMny(BigDecimal totalChangeMny) {
        this.totalChangeMny = totalChangeMny;
    }
    public BigDecimal getTotalChangeTax() {
        return totalChangeTax;
    }

    public void setTotalChangeTax(BigDecimal totalChangeTax) {
        this.totalChangeTax = totalChangeTax;
    }
    public BigDecimal getTaotalChangeScale() {
        return taotalChangeScale;
    }

    public void setTaotalChangeScale(BigDecimal taotalChangeScale) {
        this.taotalChangeScale = taotalChangeScale;
    }
    public BigDecimal getTotalShouldInOutTaxMny() {
        return totalShouldInOutTaxMny;
    }

    public void setTotalShouldInOutTaxMny(BigDecimal totalShouldInOutTaxMny) {
        this.totalShouldInOutTaxMny = totalShouldInOutTaxMny;
    }
    public BigDecimal getTotalShouldInOutMny() {
        return totalShouldInOutMny;
    }

    public void setTotalShouldInOutMny(BigDecimal totalShouldInOutMny) {
        this.totalShouldInOutMny = totalShouldInOutMny;
    }
    public BigDecimal getTotalShouldInOutTax() {
        return totalShouldInOutTax;
    }

    public void setTotalShouldInOutTax(BigDecimal totalShouldInOutTax) {
        this.totalShouldInOutTax = totalShouldInOutTax;
    }
    public BigDecimal getTotalPaymentApplyTaxMny() {
        return totalPaymentApplyTaxMny;
    }

    public void setTotalPaymentApplyTaxMny(BigDecimal totalPaymentApplyTaxMny) {
        this.totalPaymentApplyTaxMny = totalPaymentApplyTaxMny;
    }
    public BigDecimal getTotalPaymentApplyMny() {
        return totalPaymentApplyMny;
    }

    public void setTotalPaymentApplyMny(BigDecimal totalPaymentApplyMny) {
        this.totalPaymentApplyMny = totalPaymentApplyMny;
    }
    public BigDecimal getTotalPaymentApplyTax() {
        return totalPaymentApplyTax;
    }

    public void setTotalPaymentApplyTax(BigDecimal totalPaymentApplyTax) {
        this.totalPaymentApplyTax = totalPaymentApplyTax;
    }
    public BigDecimal getTotalOpenInvoiceApplyTaxMny() {
        return totalOpenInvoiceApplyTaxMny;
    }

    public void setTotalOpenInvoiceApplyTaxMny(BigDecimal totalOpenInvoiceApplyTaxMny) {
        this.totalOpenInvoiceApplyTaxMny = totalOpenInvoiceApplyTaxMny;
    }
    public BigDecimal getTotalOpenInvoiceApplyMny() {
        return totalOpenInvoiceApplyMny;
    }

    public void setTotalOpenInvoiceApplyMny(BigDecimal totalOpenInvoiceApplyMny) {
        this.totalOpenInvoiceApplyMny = totalOpenInvoiceApplyMny;
    }
    public BigDecimal getTotalOpenRecInvoiceTaxMny() {
        return totalOpenRecInvoiceTaxMny;
    }

    public void setTotalOpenRecInvoiceTaxMny(BigDecimal totalOpenRecInvoiceTaxMny) {
        this.totalOpenRecInvoiceTaxMny = totalOpenRecInvoiceTaxMny;
    }
    public BigDecimal getTotalOpenRecInvoiceMny() {
        return totalOpenRecInvoiceMny;
    }

    public void setTotalOpenRecInvoiceMny(BigDecimal totalOpenRecInvoiceMny) {
        this.totalOpenRecInvoiceMny = totalOpenRecInvoiceMny;
    }
    public BigDecimal getTotalOpenRecInvoiceTax() {
        return totalOpenRecInvoiceTax;
    }

    public void setTotalOpenRecInvoiceTax(BigDecimal totalOpenRecInvoiceTax) {
        this.totalOpenRecInvoiceTax = totalOpenRecInvoiceTax;
    }
    public BigDecimal getTotalActualPayRecTaxMny() {
        return totalActualPayRecTaxMny;
    }

    public void setTotalActualPayRecTaxMny(BigDecimal totalActualPayRecTaxMny) {
        this.totalActualPayRecTaxMny = totalActualPayRecTaxMny;
    }

    public BigDecimal getTotalOpenInvoiceApplyTax() {
        return totalOpenInvoiceApplyTax;
    }

    public void setTotalOpenInvoiceApplyTax(BigDecimal totalOpenInvoiceApplyTax) {
        this.totalOpenInvoiceApplyTax = totalOpenInvoiceApplyTax;
    }

    public BigDecimal getTotalActualPayRecMny() {
        return totalActualPayRecMny;
    }

    public void setTotalActualPayRecMny(BigDecimal totalActualPayRecMny) {
        this.totalActualPayRecMny = totalActualPayRecMny;
    }

    public BigDecimal getTotalActualPayRecTax() {
        return totalActualPayRecTax;
    }

    public void setTotalActualPayRecTax(BigDecimal totalActualPayRecTax) {
        this.totalActualPayRecTax = totalActualPayRecTax;
    }

    public BigDecimal getTotalSettleDevidePayRecScale() {
        return totalSettleDevidePayRecScale;
    }

    public void setTotalSettleDevidePayRecScale(BigDecimal totalSettleDevidePayRecScale) {
        this.totalSettleDevidePayRecScale = totalSettleDevidePayRecScale;
    }
    public BigDecimal getContractTaxMnyDevidePayRecScale() {
        return contractTaxMnyDevidePayRecScale;
    }

    public void setContractTaxMnyDevidePayRecScale(BigDecimal contractTaxMnyDevidePayRecScale) {
        this.contractTaxMnyDevidePayRecScale = contractTaxMnyDevidePayRecScale;
    }
    public BigDecimal getTotalInvoiceTaxMnyDevidePayRecScale() {
        return totalInvoiceTaxMnyDevidePayRecScale;
    }

    public void setTotalInvoiceTaxMnyDevidePayRecScale(BigDecimal totalInvoiceTaxMnyDevidePayRecScale) {
        this.totalInvoiceTaxMnyDevidePayRecScale = totalInvoiceTaxMnyDevidePayRecScale;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
     public List<ContractSubPaymentNodeVO> getContractSubPaymentNodeList() {
        return contractSubPaymentNodeList;
     }

     public void setContractSubPaymentNodeList(List<ContractSubPaymentNodeVO> contractSubPaymentNodeList) {
        this.contractSubPaymentNodeList = contractSubPaymentNodeList;
     }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getPerformanceStatusName() {
        return performanceStatusName;
    }

    public void setPerformanceStatusName(String performanceStatusName) {
        this.performanceStatusName = performanceStatusName;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public Boolean getSyncWithContractBill() {
        return syncWithContractBill;
    }

    public void setSyncWithContractBill(Boolean syncWithContractBill) {
        this.syncWithContractBill = syncWithContractBill;
    }


    /**
     * 推送财务-施工合同新加字段
     */
    private BigDecimal estimationTaxMny; // 含税暂估金额
    private String areaName; // 所在地区
    private String address; // 详细地址
    private String engineeringType; // 工程类别

    public BigDecimal getEstimationTaxMny() {
        return estimationTaxMny;
    }

    public void setEstimationTaxMny(BigDecimal estimationTaxMny) {
        this.estimationTaxMny = estimationTaxMny;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }
}
