package com.ejianc.business.contractbase.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 二维码页面展示位置
 *
 * @author CJ
 * @Description: 二维码页面展示位置
 * @date 2022/7/5 11:11
 */
public enum QRCodePagePositonEnum {

    /**
     * 二维码页面展示位置：左上角
     */
    左上角("topLeft", "左上角"),
    /**
     * 二维码页面展示位置：右上角
     */
    右上角("topRight", "右上角"),
    /**
     * 二维码页面展示位置：顶部居中
     */
    顶部居中("topCenter", "顶部居中"),
    /**
     * 二维码页面展示位置：左侧中间
     */
    左侧居中("middleLeft", "左侧中间"),
    /**
     * 二维码页面展示位置：右侧中间
     */
    右侧中间("middleRight", "右侧中间"),
    /**
     * 二维码页面展示位置：页面中心
     */
    页面中心("middleCenter", "页面中心"),
    /**
     * 二维码页面展示位置：左下角
     */
    左下角("bottomLeft", "左下角"),
    /**
     * 二维码页面展示位置：右下角
     */
    右下角("bottomRight", "右下角"),
    /**
     * 二维码页面展示位置：底部居中
     */
    底部居中("bottomCenter", "底部居中");

    QRCodePagePositonEnum(String positionCode, String positionName) {
        this.positionCode = positionCode;
        this.positionName = positionName;
    }

    private String positionCode;
    private String positionName;
    private static Map<String, QRCodePagePositonEnum> enumMap = new HashMap<>();

    public String getPositionCode() {
        return positionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    static {
        enumMap = EnumSet.allOf(QRCodePagePositonEnum.class).stream().collect(Collectors.toMap(QRCodePagePositonEnum::getPositionCode, Function.identity(), (k1, k2) -> k2));
    }

    public static QRCodePagePositonEnum getByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}

