package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.TemplateHystrix;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 模板管理API
 *
 * @author CJ
 * @Description: 模板管理API
 * @date 2021/11/10 17:50
 */
@FeignClient(name = "ejc-contractbase-web", url = "${common.env.feign-client-url}", path = "ejc-contractbase-web", fallback = TemplateHystrix.class)
public interface ITemplateApi {

    /**
     * 根据模板Id查询模板信息
     *
     * @param id 模板Id
     * @return
     */
    @GetMapping(value = "/api/template/queryDetailById")
    public CommonResponse<TemplateVO> queryDetailById(@RequestParam(value = "id") Long id);

    /**
     * 根据分类Id查询分类下启用的合同模板信息
     *
     * @param categoryId
     * @return
     */
    @GetMapping(value = "/api/template/getByCategoryId")
    public CommonResponse<TemplateVO> getByCategoryId(@RequestParam(value = "categoryId") Long categoryId);

    /**
     * 根据模板Id查询模板编辑版本列表
     *
     * @param templateId 模板id
     * @param start 查询偏移量
     * @param size 查询条数
     * @return
     */
    @GetMapping(value = "/api/template/getHisListByTemplateId")
    public CommonResponse<List<TemplateVersionVO>> getHisListByTemplateId(@RequestParam String templateId,
                                                                          @RequestParam int start,
                                                                          @RequestParam int size);

    /**
     * 根据Id查询模板详情
     *
     * @param templateId 模板Id
     * @param version 版本号
     * @return
     */
    @GetMapping(value = "/api/template/getTemplateVersionInfo")
    public CommonResponse<TemplateVersionVO> getTemplateVersionInfo(@RequestParam(value = "templateId") Long templateId,
                                                                    @RequestParam(value = "version", required = false) Long version);

    /**
     * 创建新的模板版本
     *
     * @param templateVersionVO
     * @return
     */
    @PostMapping(value = "/api/template/createNewTmplVersion")
    public CommonResponse<TemplateVersionVO> createNewTmplVersion(@RequestBody TemplateVersionVO templateVersionVO);

}
