package com.ejianc.business.contractbase.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * @author:刘家乐
 */

public class TemplateVO extends BaseVO {

	private static final long serialVersionUID = 3221541146225952879L;
	public static final Integer STATUS_ENABLE = 1;
	public static final Integer STATUS_DISABLE = 0;
	private Long categoryId;

	private String categoryName;

	@ApiModelProperty("当前最新版本id")
	private Long curVersionId;
	@ApiModelProperty("当前最新版本号")
	private Long curVersion;
	@ApiModelProperty("模板名称")
	private String templateName;

	@ApiModelProperty("文件类型  w-doc,p-ppt,s-excel,f-pdf")
	private String fileType;

	@ApiModelProperty("文件大小 以 B 为单位")
	private Long fileSize;

	@ApiModelProperty("排序号")
	private Integer sequence;

	@ApiModelProperty("文件路径")
	private String filePath;

	@ApiModelProperty("预览地址")
	private String onlinePath;

	@ApiModelProperty("模板描述")
	private String description;

	@ApiModelProperty("模板文件名称")
	private String fileName;

	@ApiModelProperty("文件id")
	private Long fileId;
	@ApiModelProperty("停启用状态：0停用，1-启用")
	private Integer enableStatus;

	@ApiModelProperty("对应单据类型")
	private String billTypeCode;

	@ApiModelProperty("模板选择元数据")
	private String metadata;

	@ApiModelProperty("模板编码")
	private String code;

	private List<PartyVO> partyList = new ArrayList<>();

	@ApiModelProperty("是否开启二维码：0-否，1-是")
	private Boolean qrCodeFlag;

	@ApiModelProperty("二维码显示方式")
	private String qrCodeShowType;

	@ApiModelProperty("二维码显示方式名称")
	private String qrCodeShowTypeName;

	@ApiModelProperty("二维码在页面显示位置")
	private String qrCodePagePosition;

	@ApiModelProperty("二维码在页面显示位置名称")
	private String qrCodePagePositionName;

	@ApiModelProperty("所属组织Id")
	private Long belongOrgId;

	@ApiModelProperty("所属组织名称")
	private String belongOrgName;

	@ApiModelProperty("所属组织编码")
	private String belongOrgCode;

	@ApiModelProperty("所属组织内码")
	private String belongOrgInnerCode;

	@ApiModelProperty("当前合同清单导出模式：topCategory-依据合同大类，category-依据小合同分类，template-依据合同模板")
	private String detailExportMode;

	public String getDetailExportMode() {
		return detailExportMode;
	}

	public void setDetailExportMode(String detailExportMode) {
		this.detailExportMode = detailExportMode;
	}

	public String getBelongOrgInnerCode() {
		return belongOrgInnerCode;
	}

	public void setBelongOrgInnerCode(String belongOrgInnerCode) {
		this.belongOrgInnerCode = belongOrgInnerCode;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getBelongOrgId() {
		return belongOrgId;
	}

	@ReferDeserialTransfer
	public void setBelongOrgId(Long belongOrgId) {
		this.belongOrgId = belongOrgId;
	}

	public String getBelongOrgName() {
		return belongOrgName;
	}

	public void setBelongOrgName(String belongOrgName) {
		this.belongOrgName = belongOrgName;
	}

	public String getBelongOrgCode() {
		return belongOrgCode;
	}

	public void setBelongOrgCode(String belongOrgCode) {
		this.belongOrgCode = belongOrgCode;
	}

	public String getCode() {
		return code;
	}

	public String getMetadata() {
		return metadata;
	}

	public void setMetadata(String metadata) {
		this.metadata = metadata;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public void setBillTypeCode(String billTypeCode) {
		this.billTypeCode = billTypeCode;
	}

	public Long getFileId() {
		return fileId;
	}

	public void setFileId(Long fileId) {
		this.fileId = fileId;
	}


	public Long getCurVersion() {
		return curVersion;
	}

	public void setCurVersion(Long curVersion) {
		this.curVersion = curVersion;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	@ReferDeserialTransfer
	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Long getCurVersionId() {
		return curVersionId;
	}

	public void setCurVersionId(Long curVersionId) {
		this.curVersionId = curVersionId;
	}

	public String getTemplateName() {
		return templateName;
	}

	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Long getFileSize() {
		return fileSize;
	}

	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getOnlinePath() {
		return onlinePath;
	}

	public void setOnlinePath(String onlinePath) {
		this.onlinePath = onlinePath;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Integer getEnableStatus() {
		return enableStatus;
	}

	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}

	public void setCode(String code) {
		this.code = code;
	}


	public List<PartyVO> getPartyList() {
		return partyList;
	}

	public void setPartyList(List<PartyVO> partyList) {
		this.partyList = partyList;
	}

	public Boolean getQrCodeFlag() {
		return qrCodeFlag;
	}

	public void setQrCodeFlag(Boolean qrCodeFlag) {
		this.qrCodeFlag = qrCodeFlag;
	}

	public String getQrCodeShowType() {
		return qrCodeShowType;
	}

	public void setQrCodeShowType(String qrCodeShowType) {
		this.qrCodeShowType = qrCodeShowType;
	}

	public String getQrCodePagePosition() {
		return qrCodePagePosition;
	}

	public void setQrCodePagePosition(String qrCodePagePosition) {
		this.qrCodePagePosition = qrCodePagePosition;
	}

	public String getQrCodeShowTypeName() {
		return qrCodeShowTypeName;
	}

	public void setQrCodeShowTypeName(String qrCodeShowTypeName) {
		this.qrCodeShowTypeName = qrCodeShowTypeName;
	}

	public String getQrCodePagePositionName() {
		return qrCodePagePositionName;
	}

	public void setQrCodePagePositionName(String qrCodePagePositionName) {
		this.qrCodePagePositionName = qrCodePagePositionName;
	}
}
