package com.ejianc.business.contractbase.pool.contractpool.api;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.contractbase.pool.contractpool.hystrix.ContractPoolHystrix;
import com.ejianc.business.contractbase.pool.contractpool.vo.*;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 合同池管理API
 *
 * @author CJ
 * @Description: 合同池管理API
 * @date 2021/11/10 17:50
 */
@FeignClient(name = "ejc-contractbase-web", url = "${common.env.feign-client-url}", path = "ejc-contractbase-web", fallback = ContractPoolHystrix.class)
public interface IContractPoolApi {

    /**
     * 更新合同履约状态
     *
     * @param contractPoolVO
     * @return
     */
    @PostMapping(value = "/api/contractpool/updatePerformanceStatusByContractId")
    public CommonResponse<ContractPoolVO> updatePerformanceStatusByContractId(@RequestBody ContractPoolVO contractPoolVO);

    /**
     * 更新合同履约状态---分布式事务版
     *
     * @param contractPoolVO
     * @return
     */
    @PostMapping(value = "/api/contractpool/updatePerformanceStatusById")
    public CommonResponse<ContractPoolVO> updatePerformanceStatusById(@RequestBody ContractPoolVO contractPoolVO);



    /**
     * 新增或更新合同信息
     *
     * @param contract
     * @return
     */
    @PostMapping(value = "/api/contractpool/saveOrUpdateContract")
    public CommonResponse<ContractPoolVO> saveOrUpdateContract(@RequestBody ContractPoolVO contract);

    /**
     * 合同删除
     *
     * @param contract
     * @return
     */
    @PostMapping(value = "/api/contractpool/deleteContract")
    public CommonResponse<String> deleteContract(@RequestBody ContractPoolVO contract);


    @RequestMapping(value = "/api/contractpool/queryPayment",method = RequestMethod.GET)
    public CommonResponse<List<ContractSubPaymentNodeVO>> queryPayment(@RequestParam(value = "contractId") String contractId);


    /**
     * 根据条件查询合同池列表
     *
     * @param QueryParam
     * @return
     */
    @PostMapping(value = "/api/contractpool/queryList")
    public CommonResponse<List<ContractPoolVO>> queryList(@RequestBody QueryParam QueryParam);

    /**
     * 根据条件查询合同池的合同金额
     * @param QueryParam
     * @return
     */
    @PostMapping(value = "/api/contractpool/queryContractMny")
    public CommonResponse<BigDecimal> queryContractMny(@RequestBody QueryParam QueryParam);


    @PostMapping(value = "/api/contractpool/querySumContractMny")
    public CommonResponse<BigDecimal> querySumContractMny(@RequestBody QueryParam QueryParam);
    /**
     * 根据条件查询签订日期为今年的合同池的合同金额
     * @param sourceType,dateIn
     * @return
     */
    @GetMapping(value = "/api/contractpool/queryThisYearContractMny")
    public CommonResponse<BigDecimal> queryThisYearContractMny(@RequestParam(value = "sourceType",required = false) String sourceType,@RequestParam(value = "dateIn",required = false)String dateIn, @RequestParam(value = "orgId",required = false) Long orgId);

    /**
     * 根据供应商 id 和开始时间啊 结束时间 查询合同列表
     * @param
     * @return
     */
    @PostMapping(value = "/api/contractpool/getContractList")
    public CommonResponse<JSONArray> getContractList(@RequestBody SupplyVO vo);
    /**
     * 根据分包负责人 id 和开始时间啊 结束时间 查询合同列表
     * @param
     * @return
     */
    @PostMapping(value = "/api/contractpool/getContractListByHeadUser")
    public CommonResponse<JSONArray> getContractListByHeadUser(@RequestBody HeadUserVO vo);


    @RequestMapping(value = "/api/contractpool/queryById",method = RequestMethod.GET)
    public CommonResponse<ContractPoolVO> queryById(@RequestParam(value = "contractId") Long contractId);

    /**
     * 根据供应商Id查询供应商历史业绩列表
     *
     * @param supplierId
     * @return
     */
    @GetMapping(value = "/api/contractpool/supHisPerformanceList")
    public CommonResponse<List<SupHisPerformanceVO>> supHisPerformanceList(@RequestParam Long supplierId);

    /**
     *  付款 查询 合同 履约金额
     * @param vo
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/api/contractpool/queryContractHonourMny",method = RequestMethod.POST)
    public CommonResponse<BigDecimal> queryContractHonourMny(@RequestBody ContractPoolVO vo);

    @ResponseBody
    @RequestMapping(value = "/api/contractpool/queryContractByCode",method = RequestMethod.GET)
    public CommonResponse<ContractPoolVO> queryContractByCode(@RequestParam(value = "contractCode") String contractCode);

    // 根据项目id查询当前项目下的 最新一条施工合同的合同金额 - 专业合同的合同金额的累计
    @GetMapping(value = "/api/contractpool/queryContractionSubtractProTaxMny")
    @ResponseBody
    public CommonResponse<BigDecimal> queryContractionSubtractProTaxMny(@RequestParam Long projectId);
    /**
     * 根据供应商id和orgIds 查询 供应商的合同金额 和结算金额
     */
    @ResponseBody
    @RequestMapping(value = "/api/contractpool/queryContractSettleTaxMny",method = RequestMethod.POST)
    public CommonResponse<List<SupplierInfoVO>> queryContractSettleTaxMny(@RequestBody SupplierInfoVO vo);

    /**
     * 累加回写【合同池】对应合同的“累计实付/收金额”、“累计实付/收金额(无税)”
     */
    @GetMapping(value = "/api/contractpool/updateActualPayRecMny")
    public CommonResponse<String> updateActualPayRecMny(@RequestParam(value = "contractId") Long contractId,@RequestParam(value = "taxMny") BigDecimal taxMny,@RequestParam(value = "mny") BigDecimal mny,@RequestParam(value = "flag") boolean flag);

    /**
     * 在建项目金额区位排名前topNum名
     *
     * @param orgId
     * @param topNum
     * @return
     */
    @GetMapping(value = "/api/contractpool/getProjectAreaContractMny")
    public CommonResponse<List<Map<String, Object>>> getProjectAreaContractMny(@RequestParam Long orgId,
                                                                               @RequestParam Integer topNum,
                                                                               @RequestParam(value = "contractTypes",required = false) String contractTypes,
                                                                               @RequestParam(required = false) String dateIn);

    /**
     *
     *
     * @param orgId
     * @param topNum
     * @param contractTypes
     * @return
     */
    @GetMapping(value = "/api/contractpool/getMolecularUnitRange")
    CommonResponse<List<Map<String, Object>>> getMolecularUnitRange(@RequestParam Long orgId,
                                                                           @RequestParam Integer topNum,
                                                                           @RequestParam(value = "contractTypes",required = false) String contractTypes);



    /**
     * 年度支出合同签订占比（金额、数量）
     *
     * @param orgId
     * @param year 年度
     * @return
     */
    @GetMapping(value = "/api/contractpool/getPayContractRatio")
    public CommonResponse<List<ContractMnyAndNumRatioVO>> getPayContractRatio(@RequestParam Long orgId,
                                                                              @RequestParam(value = "year",required = false) String year);

    /**
     * 根据项目id查询当前项目下的 施工合同总金额
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/contractpool/queryContractionTaxMny")
    @ResponseBody
    public CommonResponse<BigDecimal> queryContractionTaxMny(@RequestParam Long projectId);



    /**
     * 根据条件查询供应商id
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/contractpool/querySupplierList")
    public CommonResponse<List<Long>> querySupplierList(@RequestBody QueryParam queryParam);
}
