package com.ejianc.business.contractbase.check.service.impl;

import cn.hutool.core.math.MathUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.check.service.IParamCheckService;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.pro.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import groovy.util.IFileNameFinder;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ParamCheckServiceImpl implements IParamCheckService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static final String CHECK_PARAM_CODE = "P-434f5499";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractPoolService contractService;

    @Autowired
    private ISettlePoolService settleService;

    @Override
    public ParamsCheckVO paramsCheck(Long projectId, Long contractId, BigDecimal contractTaxMny){
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();

        LambdaQueryWrapper<ContractPoolEntity> incomeQueryWrapper = new LambdaQueryWrapper();
        incomeQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
        incomeQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        incomeQueryWrapper.eq(ContractPoolEntity::getSourceType, ContractTypeEnum.施工合同.getTypeCode());
        incomeQueryWrapper.eq(ContractPoolEntity::getDr,0);
        List<ContractPoolEntity> listContractPool = contractService.list(incomeQueryWrapper);

        if (CollectionUtils.isEmpty(listContractPool)){
            // 该项目无施工合同直接赋值为不控制
            paramsCheckVO.setWarnType(paramsArray[0]);
            return paramsCheckVO;
        }

        BigDecimal sumIncomeContractTaxMny = BigDecimal.ZERO; //施工合同金额总和
        if (CollectionUtils.isNotEmpty(listContractPool)){
            sumIncomeContractTaxMny = listContractPool.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
        }

        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();

            BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(sumIncomeContractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);

            BigDecimal sumPayContractTaxMny = BigDecimal.ZERO;

            LambdaQueryWrapper<ContractPoolEntity> payQueryWrapper = new LambdaQueryWrapper();
            if (null != contractId){
                payQueryWrapper.ne(ContractPoolEntity::getId,contractId);
            }
            payQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
            payQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
            payQueryWrapper.in(ContractPoolEntity::getContractProperty, ContractPropertyEnum.支出合同.getPropertyCode());
            payQueryWrapper.eq(ContractPoolEntity::getDr,0);
            List<ContractPoolEntity> payContractPool = contractService.list(payQueryWrapper);

            List<ContractPoolEntity> contractListA = payContractPool.stream().filter(e ->
                    PerformanceStatusEnum.未签订.getCode().equals(e.getPerformanceStatus()) ||
                            PerformanceStatusEnum.履约中.getCode().equals(e.getPerformanceStatus()) ||
                            PerformanceStatusEnum.已冻结.getCode().equals(e.getPerformanceStatus())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(contractListA)){
                sumPayContractTaxMny = contractListA.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
            }

            List<ContractPoolEntity> contractListB = payContractPool.stream().filter(e ->
                    PerformanceStatusEnum.已终止.getCode().equals(e.getPerformanceStatus()) ||
                            PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus()) ||
                            PerformanceStatusEnum.已结束.getCode().equals(e.getPerformanceStatus())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(contractListB)){
                /*List<Long> ids = contractListB.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(SettlePoolEntity::getDr,0);
                queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                queryWrapper.in(SettlePoolEntity::getContractId,ids);
                List<SettlePoolEntity> settleList = settleService.list(queryWrapper);

                BigDecimal sumPaySettleTaxMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(settleList)){
                    sumPaySettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal::add).get();
                }
                sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,sumPaySettleTaxMny);*/


                List<ContractPoolEntity> notSubContractList = contractListB.stream().filter(e -> !(ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType()))).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(notSubContractList)){
                    List<Long> ids = notSubContractList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                    LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(SettlePoolEntity::getDr,0);
                    queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                    queryWrapper.in(SettlePoolEntity::getContractId,ids);
                    List<SettlePoolEntity> settleList = settleService.list(queryWrapper);

                    BigDecimal sumNotSubSettleTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty(settleList)){
                        sumNotSubSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                    }
                    sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,sumNotSubSettleTaxMny);
                }

                List<ContractPoolEntity> subContractList = contractListB.stream().filter(e -> ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(subContractList)){
                    List<ContractPoolEntity> yzfList = subContractList.stream().filter(e -> PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(yzfList)){
                        List<Long> yzfIds = yzfList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(SettlePoolEntity::getDr,0);
                        queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                        queryWrapper.in(SettlePoolEntity::getSourceType, SettleSourceTypeEnum.劳务分包月度结算.getCode(),SettleSourceTypeEnum.专业分包月度结算.getCode());
                        queryWrapper.in(SettlePoolEntity::getContractId,yzfIds);
                        List<SettlePoolEntity> settleListOne = settleService.list(queryWrapper);

                        BigDecimal settleOne = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty(settleListOne)){
                            settleOne = settleListOne.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                        }
                        sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,settleOne);
                    }

                    List<ContractPoolEntity> otherList = subContractList.stream().filter(e -> !PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(otherList)){
                        List<Long> otherIds = otherList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(SettlePoolEntity::getDr,0);
                        queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                        queryWrapper.in(SettlePoolEntity::getSourceType, SettleSourceTypeEnum.劳务分包最终结算,SettleSourceTypeEnum.专业分包最终结算.getCode());
                        queryWrapper.in(SettlePoolEntity::getContractId,otherIds);
                        List<SettlePoolEntity> settleListTwo = settleService.list(queryWrapper);

                        BigDecimal settleTwo = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty(settleListTwo)){
                            settleTwo = settleListTwo.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                        }
                        sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,settleTwo);
                    }
                }
            }

            sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,contractTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);
            contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;


            if (sumPayContractTaxMny.compareTo(comMny) > 0) {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);

                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("支出超施工合同");
                paramsCheckDsVO.setWarnName("累计支出合同金额大于施工合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次合同金额：").append(contractTaxMny)
                        .append("元，含本次合同金额：").append(sumPayContractTaxMny)
                        .append("元，施工合同金额*").append(roleValue).append("% = ").append(comMny)
                        .append("元。超出金额：").append(ComputeUtil.safeSub(sumPayContractTaxMny, comMny).setScale(2,BigDecimal.ROUND_HALF_UP)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }else{
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> paramsCheck(Long projectId, Long contractId, BigDecimal contractTaxMny, Long orgId){
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
//        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
//        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        LambdaQueryWrapper<ContractPoolEntity> incomeQueryWrapper = new LambdaQueryWrapper();
        incomeQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
        incomeQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        incomeQueryWrapper.eq(ContractPoolEntity::getSourceType, ContractTypeEnum.施工合同.getTypeCode());
        incomeQueryWrapper.eq(ContractPoolEntity::getDr,0);
        List<ContractPoolEntity> listContractPool = contractService.list(incomeQueryWrapper);
        if (CollectionUtils.isEmpty(listContractPool)){
            // 该项目无施工合同直接赋值为不控制
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            paramsCheckVO.setWarnType(paramsArray[0]);
            paramsCheckVOList.add(paramsCheckVO);
            return paramsCheckVOList;
        }
        List<ContractPoolEntity> zsht = listContractPool.stream().filter(x->x.getIsEstimation()==null || x.getIsEstimation()==0).collect(Collectors.toList());
        List<ContractPoolEntity> zght = listContractPool.stream().filter(x->x.getIsEstimation()==1).collect(Collectors.toList());
        BigDecimal sumIncomeContractTaxMny = BigDecimal.ZERO; //施工合同金额总和
        sumIncomeContractTaxMny = CollectionUtil.isNotEmpty(zsht)?zsht.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO):
                zght.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);

//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = billParamVO.getRoleValue();

                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(sumIncomeContractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);

                    BigDecimal sumPayContractTaxMny = BigDecimal.ZERO;

                    LambdaQueryWrapper<ContractPoolEntity> payQueryWrapper = new LambdaQueryWrapper();
                    if (null != contractId){
                        payQueryWrapper.ne(ContractPoolEntity::getId,contractId);
                    }
                    payQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
                    payQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
                    payQueryWrapper.in(ContractPoolEntity::getContractProperty, ContractPropertyEnum.支出合同.getPropertyCode());
                    payQueryWrapper.eq(ContractPoolEntity::getDr,0);
                    List<ContractPoolEntity> payContractPool = contractService.list(payQueryWrapper);

                    List<ContractPoolEntity> contractListA = payContractPool.stream().filter(e ->
                            PerformanceStatusEnum.未签订.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.履约中.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已冻结.getCode().equals(e.getPerformanceStatus())
                    ).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(contractListA)){
                        sumPayContractTaxMny = contractListA.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                    }

                    List<ContractPoolEntity> contractListB = payContractPool.stream().filter(e ->
                            PerformanceStatusEnum.已终止.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus()) ||
                                    PerformanceStatusEnum.已结束.getCode().equals(e.getPerformanceStatus())
                    ).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(contractListB)){
                /*List<Long> ids = contractListB.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(SettlePoolEntity::getDr,0);
                queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                queryWrapper.in(SettlePoolEntity::getContractId,ids);
                List<SettlePoolEntity> settleList = settleService.list(queryWrapper);

                BigDecimal sumPaySettleTaxMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(settleList)){
                    sumPaySettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal::add).get();
                }
                sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,sumPaySettleTaxMny);*/


                        List<ContractPoolEntity> notSubContractList = contractListB.stream().filter(e -> !(ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType()))).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(notSubContractList)){
                            List<Long> ids = notSubContractList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                            LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                            queryWrapper.eq(SettlePoolEntity::getDr,0);
                            queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                            queryWrapper.in(SettlePoolEntity::getContractId,ids);
                            List<SettlePoolEntity> settleList = settleService.list(queryWrapper);

                            BigDecimal sumNotSubSettleTaxMny = BigDecimal.ZERO;
                            if (CollectionUtils.isNotEmpty(settleList)){
                                sumNotSubSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                            }
                            sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,sumNotSubSettleTaxMny);
                        }

                        List<ContractPoolEntity> subContractList = contractListB.stream().filter(e -> ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(subContractList)){
                            List<ContractPoolEntity> yzfList = subContractList.stream().filter(e -> PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(yzfList)){
                                List<Long> yzfIds = yzfList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                                LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                                queryWrapper.eq(SettlePoolEntity::getDr,0);
                                queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                                queryWrapper.in(SettlePoolEntity::getSourceType, SettleSourceTypeEnum.劳务分包月度结算.getCode(),SettleSourceTypeEnum.专业分包月度结算.getCode());
                                queryWrapper.in(SettlePoolEntity::getContractId,yzfIds);
                                List<SettlePoolEntity> settleListOne = settleService.list(queryWrapper);

                                BigDecimal settleOne = BigDecimal.ZERO;
                                if (CollectionUtils.isNotEmpty(settleListOne)){
                                    settleOne = settleListOne.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                                }
                                sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,settleOne);
                            }

                            List<ContractPoolEntity> otherList = subContractList.stream().filter(e -> !PerformanceStatusEnum.已作废.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(otherList)){
                                List<Long> otherIds = otherList.stream().map(ContractPoolEntity::getId).collect(Collectors.toList());
                                LambdaQueryWrapper<SettlePoolEntity> queryWrapper = new LambdaQueryWrapper<>();
                                queryWrapper.eq(SettlePoolEntity::getDr,0);
                                queryWrapper.in(SettlePoolEntity::getBillState,1,3);
                                queryWrapper.in(SettlePoolEntity::getSourceType, SettleSourceTypeEnum.劳务分包最终结算,SettleSourceTypeEnum.专业分包最终结算.getCode());
                                queryWrapper.in(SettlePoolEntity::getContractId,otherIds);
                                List<SettlePoolEntity> settleListTwo = settleService.list(queryWrapper);

                                BigDecimal settleTwo = BigDecimal.ZERO;
                                if (CollectionUtils.isNotEmpty(settleListTwo)){
                                    settleTwo = settleListTwo.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                                }
                                sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,settleTwo);
                            }
                        }
                    }

                    sumPayContractTaxMny = ComputeUtil.safeAdd(sumPayContractTaxMny,contractTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);
                    contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;


                    if (sumPayContractTaxMny.compareTo(comMny) > 0) {
                        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);

                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("支出超施工合同");
                        paramsCheckDsVO.setWarnName("累计支出合同金额大于施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny)
                                .append("元，含本次合同金额：").append(sumPayContractTaxMny)
                                .append("元，施工合同金额*").append(roleValue).append("% = ").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(sumPayContractTaxMny, comMny).setScale(2,BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }else{
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

}
