package com.ejianc.business.contractbase.pool.settlepool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算池主实体---controller
 *
 * @author generator
 */
@RestController
@RequestMapping("/settlePool")
public class SettlePoolController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    // 有合同结算
    private static final String BILL_CODE = "SETTLE_POOL_TEMP";

    // 无合同结算
    private static final String BILL_CODE_NO_CONTRACT = "SETTLE_POOL_NO_CONTRACT_TEMP";

    @Autowired
    private ISettlePoolService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillTypeApi billTypeApi;

    //分包完工结算差额计算方式：1-使用过程结算，2-使用节点结算
    private final String FINISH_SETTLE_CALC_TYPE = "P-2hiWQQ0131";

    private final String CALC_WITH_PROCESS_SETTLE ="1";
    private final String CALC_WITH_NODE_SETTLE ="2";

    @Autowired
    private IParamConfigApi paramConfigApi;

    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";

    @PostMapping("/saveOrUpdate")
    public CommonResponse<SettlePoolVO> saveOrUpdate(@RequestBody SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity entity = BeanMapper.map(saveOrUpdateVO, SettlePoolEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            // 生成单据编码并关联实体属性
            BillCodeParam billCodeParam = new BillCodeParam();
            if (entity.getContractFlag() != null) {
                if (entity.getContractFlag() == 0) {
                    // 无合同
                    billCodeParam = BillCodeParam.build(BILL_CODE_NO_CONTRACT, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                } else {
                    // 有合同
                    billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                }
            }
            CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
            if(billCodeRes.isSuccess()) {
                entity.setBillCode(billCodeRes.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SettlePoolVO vo = BeanMapper.map(entity, SettlePoolVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlePoolVO> vos) {
        QueryWrapper<SettlePoolEntity> query = new QueryWrapper<>();
        List<Long> ids = vos.stream().map(SettlePoolVO::getId).collect(Collectors.toList());
        query.in("id", ids);
        List<SettlePoolEntity> settleList = service.list(query);
        for(SettlePoolEntity settle : settleList) {
            //合同是否被其他单据引用
            CommonResponse<String> res = billTypeApi.checkQuote(null != settle.getContractId()  ? "EJCBT202205000007" : "EJCBT202205000006", settle.getId());
            logger.info("平台返回查询被引用情况：{}", JSONObject.toJSONString(res));
            if(!res.isSuccess()) {
                return CommonResponse.error("结算单["+settle.getBillCode()+"]已被下游业务引用，不能删除！");
            }
        }

        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    // 查列表
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();

        //查询分包结算控制参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FINISH_SETTLE_CALC_TYPE);
        String defaultCalcType = CALC_WITH_PROCESS_SETTLE; //分包完工差额取过程结算
        if(!response.isSuccess()) {
            logger.error("获取平台系统参数，分包完工差额计算方式-【{}】失败, {}", FINISH_SETTLE_CALC_TYPE, JSONObject.toJSONString(response));
        } else {
            defaultCalcType = response.getData().getValueData();
        }
        resp.put("finishSettleCalcType", defaultCalcType);

        // 设置模糊查询字段     结算单号、项目名称、合同名称、甲方/乙方名称
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null; String orgType= null;
        if(null != param.getParams().get("orgId") && null != param.getParams().get("orgType")) {
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgType = param.getParams().get("orgType").getValue().toString();

            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        } else {
            orgType = InvocationInfoProxy.getOrgType();
            orgId = InvocationInfoProxy.getOrgId();
        }

        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(orgType))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        // 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！
        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(orgId,
                    projectRange, dateIn);

            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", orgId, JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！", orgId);

                resp.put("current", param.getPageIndex());
                resp.put("size", param.getPageSize());
                resp.put("pages", 0);
                resp.put("totalMny", 0);
                resp.put("total", 0);
                resp.put("records", new ArrayList<>());
                return CommonResponse.success("查询列表数据成功！", resp);
            }
        }

        if(null != param.getParams().get("projectSettleFlag")) {
            if("true".equals(param.getParams().get("projectSettleFlag").getValue().toString())) {
                CommonResponse<ParamRegisterSetVO> paramResponse = paramConfigApi.getByCode(PROJECT_SETTLE_RANGE_PARAM);
                if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
                    throw new BusinessException("获取项目结算查询结算单范围系统参数请求失败，失败原因：" + paramResponse.getMsg());
                }
                String valueData = paramResponse.getData().getValueData();
                Assert.hasText(valueData, "获取的项目结算查询结算单范围不能为空!");

                param.getParams().put("sourceType", new Parameter(QueryParam.IN, valueData));
            }
            param.getParams().remove("projectSettleFlag");
        }

        // 查询结算池数据
        IPage<SettlePoolEntity> page = service.queryPage(param, false);
        IPage<SettlePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SettlePoolVO> settlePoolVOList = BeanMapper.mapList(page.getRecords(), SettlePoolVO.class);

        // 向结算池vo中封装结算单类型名称
        settlePoolVOList.forEach(vo -> {
            vo.setSourceTypeName(null != SettleSourceTypeEnum.getByCode(vo.getSourceType()) ? SettleSourceTypeEnum.getByCode(vo.getSourceType()).getName() : null);
            Integer settleProperty = vo.getSettleProperty();
            vo.setSettlePropertyName("");
            if (settleProperty != null) {
                vo.setSettlePropertyName(1 == settleProperty ? "收入" : "支出");
            }
            // 是否有合同标识
            Integer contractFlag = vo.getContractFlag();
            vo.setContractFlagName("");
            if (contractFlag != null) {
                vo.setContractFlagName(1 == contractFlag ? "是" : "否");
            } else {
                vo.setContractFlagName("是");
            }
        });

        // 封装page对象并返回给前端
        pageData.setRecords(settlePoolVOList);

        resp.put("current", page.getCurrent());
        resp.put("size", page.getSize());
        resp.put("pages", page.getPages());
        resp.put("total", page.getTotal());
        resp.put("totalMny", service.calcTotalMny(param));
        resp.put("records", settlePoolVOList);
        return CommonResponse.success("查询列表数据成功！", resp);
    }

    /**
     * 查详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/queryDetail")
    public CommonResponse<SettlePoolVO> queryDetail(Long id) {
        SettlePoolEntity entity = service.selectById(id);
        SettlePoolVO vo = BeanMapper.map(entity, SettlePoolVO.class);
        List<String> paramList = Lists.newArrayList(vo.getSourceType(), vo.getContractType(), "partya", "partyb", "project");
        // 查询穿透URL中间表所有数据，获取所有穿透URL
        HashMap<String, String> urlMap = new HashMap<>();
        List<BillUrlDictEntity> urlList = service.queryDetailUrlList(paramList);
        if (CollectionUtils.isNotEmpty(urlList)) {
            urlList.forEach(u -> urlMap.put(u.getSourceType(), u.getSourceDetailUrl()));
        }
        // vo中封装穿透URL
        if (MapUtils.isNotEmpty(urlMap)) {
            // 来源结算单号URL
            vo.setBillCodeUrl(urlMap.get(vo.getSourceType()));
            // 合同编码URL
            vo.setContractUrl(urlMap.get(vo.getContractType()));
            // 甲方URL
            vo.setPartyaUrl(urlMap.get("partya"));
            // 乙方URL
            vo.setPartybUrl(urlMap.get("partyb"));
            // 项目URL
            vo.setProjectUrl(urlMap.get("project"));
        }
        // 向结算池vo中封装结算单类型名称
        vo.setSourceTypeName(SettleSourceTypeEnum.getByCode(vo.getSourceType()).getName());
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 导出Excel
     *
     * @param param
     * @param response
     */
    @PostMapping(value = "/excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        // 查询所有
        param.setPageSize(-1);
        // 设置模糊查询字段     结算单号、项目名称、合同名称、甲方/乙方名称
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        // 租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 数据隔离 本下 没有组织orgId的删除下面代码-------------开始
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            // 要求主表有parent_org_id字段，保存单据所属组织
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            // 要求主表有org_id字段，保存单据所属项目部
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        // 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！

        // 查询结算池数据
        List<SettlePoolEntity> list = service.queryList(param);
        List<SettlePoolVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, SettlePoolVO.class);
            for (SettlePoolVO vo : voList) {
                if (vo == null) {
                    continue;
                }
                // 结算单类型转换
                vo.setSourceTypeName("");
                String sourceType = vo.getSourceType();
                if (StringUtils.isNotBlank(sourceType)) {
                    SettleSourceTypeEnum settleSourceTypeEnum = SettleSourceTypeEnum.getByCode(sourceType);
                    vo.setSourceTypeName(settleSourceTypeEnum != null ? settleSourceTypeEnum.getName() : "");
                }
                Integer settleProperty = vo.getSettleProperty();
                vo.setSettlePropertyName("");
                if (settleProperty != null) {
                    vo.setSettlePropertyName(1 == settleProperty ? "收入" : "支出");
                }
                vo.setHandleTypeStr(Integer.valueOf(1).equals(vo.getHandleType()) ? "手动补录" : "业务推送");
            }
        }
        // 封装并导出
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("SettlePool-export.xlsx", beans, response);
    }

    /**
     * 获取RPC数据
     *
     * @param resp      返回值
     * @param isMustSuc 是否必须成功
     * @param errMsg    失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @GetMapping(value = "/refSettlePoolData")
    public CommonResponse<IPage<SettlePoolVO>> refSettlePoolData(@RequestParam Integer pageNumber,
                                                                 @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        // 设置模糊查询字段     结算单号、项目名称、合同名称、甲方/乙方名称
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        // 租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (StringUtils.isNotEmpty(condition)) {
            // 处理condition
            JSONObject _con = JSONObject.parseObject(condition);
            // 合同id
            if (condition.contains("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.getString("contractId")));
            }
            //查询结算类型
            String sourceTypeStr = _con.getString("sourceTypes");
            if (StringUtils.isNotBlank(sourceTypeStr)) {
                param.getParams().put("source_type", new Parameter(QueryParam.IN, Lists.newArrayList(sourceTypeStr.split(","))));
            }
            //查询过滤结算类型
            String excludeSourceTypes = _con.getString("excludeSourceTypes");
            if (StringUtils.isNotBlank(excludeSourceTypes)) {
                param.getParams().put("source_type", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeSourceTypes.split(","))));
            }
            //根据项目过滤
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getString("projectId")));
            }
            //根据付款单位 乙方 供应商过滤
            if (condition.contains("supplierId")) {
                param.getParams().put("partyb_id", new Parameter(QueryParam.EQ, _con.getString("supplierId")));
            }
            // 封装查询时排除的数据的结算池数据的ID
            String excludeIdStr = _con.getString("excludeIds");
            if (StringUtils.isNotBlank(excludeIdStr)) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeIdStr.split(","))));
            }
        }
        param.getParams().put("residue_apply_mny",new Parameter(QueryParam.GT,0));
        IPage<SettlePoolEntity> page = service.queryPage(param, false);
        IPage<SettlePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SettlePoolVO> settlePoolVOS = BeanMapper.mapList(page.getRecords(), SettlePoolVO.class);
        for (SettlePoolVO vo:settlePoolVOS){
            if (vo.getTotalSettlePaymentTaxMny()==null){
                vo.setTotalSettlePaymentTaxMny(vo.getCurTaxMny());
                vo.setTotalSettlePaymentMny(vo.getCurMny());
            }
            String sourceType = vo.getSourceType();
            //是否最终结算：0否，1是
            if ("labor_node".equals(vo.getSourceType())||"pro_node".equals(vo.getSourceType())){
                vo.setSourceTypeNameStr("节点结算");
            }else if ("labor_final".equals(vo.getSourceType())||"pro_final".equals(vo.getSourceType())){
                vo.setSourceTypeNameStr("最终结算");
            }else if (vo.getUltimateFlag()==null||1!=vo.getUltimateFlag()){
                vo.setSourceTypeNameStr("过程结算");
            }else {
                vo.setSourceTypeNameStr("最终结算");

            }
        }
        pageData.setRecords(settlePoolVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     *  获取当前 合同下的累计结算金额
     * @param settlePoolVO
     * @return
     */
    @RequestMapping(value = "/queryTotalMny", method = RequestMethod.POST)
    public CommonResponse<SettlePoolVO> queryTotalMny(@RequestBody SettlePoolVO settlePoolVO) {
        return CommonResponse.success(service.queryTotalMny(settlePoolVO));
    }

    /**
     *  获取当前 合同下的累计结算金额
     * @param settlePoolVO
     * @return
     */
    @RequestMapping(value = "/queryContractSettleList", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryContractSettleList(@RequestBody SettlePoolVO settlePoolVO) {
        JSONObject resp = new JSONObject();
        //查询 当前合同下的 结算金额
        QueryParam queryParam = new QueryParam();

        if(null != settlePoolVO.getContractId()) {
            queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,settlePoolVO.getContractId()));
        }
        if(null != settlePoolVO.getContractType()) {
            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ,settlePoolVO.getContractType()));
        }
        if(null != settlePoolVO.getProjectId()) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ,settlePoolVO.getProjectId()));
        }

        //正常情况不区分 结算类型
        if (ContractTypeEnum.专业分包合同.getTypeCode().equals(settlePoolVO.getContractType())){
            List typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.专业分包最终结算.getCode());
            typeList.add(SettleSourceTypeEnum.专业分包节点结算.getCode());
            queryParam.getParams().put("source_type",new Parameter(QueryParam.IN,typeList));
        }
        if (ContractTypeEnum.劳务分包合同.getTypeCode().equals(settlePoolVO.getContractType())){
            List typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.劳务分包最终结算.getCode());
            typeList.add(SettleSourceTypeEnum.劳务分包节点结算.getCode());
            queryParam.getParams().put("source_type",new Parameter(QueryParam.IN,typeList));
        }
        queryParam.getOrderMap().put("settleDate", QueryParam.DESC);
        List<SettlePoolEntity> settleList = service.queryList(queryParam, false);
        BigDecimal totalTaxMny = BigDecimal.ZERO, totalMny = BigDecimal.ZERO;
        for(SettlePoolEntity entity:settleList){
            //分包的 累计结算金额 = 节点+完工节点结算差额
            if (SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(entity.getSourceType())
                    ||SettleSourceTypeEnum.专业分包最终结算.getCode().equals(entity.getSourceType())){
                if (entity.getTotalNodeTaxDifference()!=null) {
                    totalTaxMny = totalTaxMny.add(entity.getTotalNodeTaxDifference());
                }
                if(null != entity.getTotalNodeDifference()) {
                    totalMny = totalMny.add(entity.getTotalNodeDifference());
                }
            }else {
                totalTaxMny = totalTaxMny.add(entity.getCurTaxMny());
                totalMny = totalMny.add(entity.getCurMny());
            }
        }

        resp.put("totalSettleTaxMny", totalTaxMny);
        resp.put("totalSettleMny", totalMny);
        resp.put("settleList", settleList);
        return CommonResponse.success("查询成功", resp);
    }

    // 根据合同ID，来源类型查询数据，工人工资支付申请卡片页面查询累计月度结算和累计节点结算数据使用
    @GetMapping(value = "/queryLaborMny")
    public CommonResponse<Map<String, BigDecimal>> queryLaborMny(@RequestParam(value = "contractId") String contractId) {
        logger.info("ejc-contractbase-impl***SettlePoolController***queryLaborMny方法***begin***contractId-{}", contractId);
        Map<String, BigDecimal> response = service.queryLaborMny(Long.parseLong(contractId));
        logger.info("ejc-contractbase-impl***SettlePoolController***queryLaborMny方法***end***返回结果-{}", JSONObject.toJSONString(response));
        return CommonResponse.success(response);
    }

    // 导入模板下载
    @RequestMapping(value = "/downloadExcelModel")
    @ResponseBody
    public void downloadExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SettlePool-import-template.xlsx", "结算池-导入模板");
    }

    // excel数据导入
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }

    @RequestMapping(value = "/calcTotalMny", method = RequestMethod.POST)
    public CommonResponse<BigDecimal> calcTotalMny(@RequestBody QueryParam param) {

        // 设置模糊查询字段     结算单号、项目名称、合同名称、甲方/乙方名称
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null; String orgType= null;
        if(null != param.getParams().get("orgId") && null != param.getParams().get("orgType")) {
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgType = param.getParams().get("orgType").getValue().toString();

            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        } else {
            orgType = InvocationInfoProxy.getOrgType();
            orgId = InvocationInfoProxy.getOrgId();
        }
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(orgType))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("查询成功，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        // 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！
        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);

            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");
                return CommonResponse.success("查询成功！", BigDecimal.ZERO);
            }
        }

        return CommonResponse.success("查询成功！", service.calcTotalMny(param));
    }
}
