package com.ejianc.business.contractbase.pool.settlepool.mapper;

import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.vo.report.ContractSettleReportVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 结算池主实体
 *
 * @author generator
 */
@Mapper
public interface SettlePoolMapper extends BaseCrudMapper<SettlePoolEntity> {

    SettlePoolEntity selectBySourceId(@Param("sourceId") Long sourceId);

    void delBySourceId(@Param("sourceId") Long sourceId);

    List<SubUnitTopVO> queryProductSubUnitTopN(@Param("sourceType") String sourceType
            , @Param("year") String year, @Param("beginQuarterDate") String beginQuarterDate, @Param("endQuarterDate") String endQuarterDate
            , @Param("month") String month, @Param("ordIdsList") List<Long> ordIdsList);

    Map<String, Object> countSettleInfo(@Param("paramMap") Map<String, Object> paramMap);

    List<ContractSettleReportVO> pageList(@Param("paramMap") Map<String, Object> paramMap);
}
