package com.ejianc.business.contractbase.pool.settlepool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.mapper.BillUrlDictMapper;
import com.ejianc.business.contractbase.pool.settlepool.mapper.SettlePoolMapper;
import com.ejianc.business.contractbase.pool.settlepool.service.IBillUrlDictService;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.settlepool.vo.ImportSettlePoolVO;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.pool.util.BeanUtil;
import com.ejianc.business.contractbase.vo.report.ContractSettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算池主实体
 *
 * @author generator
 */
@Service("settlePoolService")
public class SettlePoolServiceImpl extends BaseServiceImpl<SettlePoolMapper, SettlePoolEntity> implements ISettlePoolService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    BillUrlDictMapper urlMapper;

    @Autowired
    SettlePoolMapper poolMapper;

    @Autowired
    private IBillUrlDictService billUrlDictService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ContractPoolMapper contractPoolMapper;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private IOrgApi orgApi;

    private static final String BILL_CODE = "SETTLE_POOL_TEMP";// 有合同
    private static final String BILL_CODE_NO_CONTRACT = "SETTLE_POOL_NO_CONTRACT_TEMP";// 无合同

    @Override
    public List<BillUrlDictEntity> queryDetailUrlList(List<String> typeList) {
        QueryWrapper<BillUrlDictEntity> query = new QueryWrapper<>();
        query.in("source_type", typeList);
        return urlMapper.selectList(query);
    }


    @Override
    public void delBySourceId(Long sourceId) {
        poolMapper.delBySourceId(sourceId);
    }

    @Override
    public SettlePoolVO saveOrUpdateSettle(SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity saveEntity = null;
        SettlePoolEntity dbEntity = selectBySourceId(saveOrUpdateVO.getSourceId());
        if(null != dbEntity) {
            saveEntity = copyProperty(dbEntity, saveOrUpdateVO);
        } else {
            //新增
            saveEntity = BeanMapper.map(saveOrUpdateVO, SettlePoolEntity.class);
            if (saveEntity.getResidueApplyMny()==null){
                saveEntity.setResidueApplyMny(saveEntity.getCurTaxMny()==null?BigDecimal.ZERO:saveEntity.getCurTaxMny());
            }
            billCheck(saveEntity);
            saveEntity.setAlreadyApplyMny(BigDecimal.ZERO);
            //设置详情地址
            findDetailUrl(saveEntity);

            //新增走下物理删除逻辑，防止数据insert时主键重复
            poolMapper.delBySourceId(saveEntity.getSourceId());
        }
        fillTypeName(saveEntity);

        super.saveOrUpdate(saveEntity, false);
        return BeanMapper.map(saveEntity, SettlePoolVO.class);
    }

    @Override
    public List<SettlePoolVO> saveOrUpdateSettleBatch(List<SettlePoolVO> saveOrUpdateVOs) {
        Map<Long, SettlePoolVO> vosMap = saveOrUpdateVOs.stream().collect(Collectors.toMap(SettlePoolVO::getId, e -> e));
        List<SettlePoolEntity> list = selectBySourceIds(new ArrayList<>(vosMap.keySet()));
        List<SettlePoolEntity> saveList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            SettlePoolEntity saveEntity = null;
            for(SettlePoolEntity dbEntity : list) {
                saveEntity = copyProperty(dbEntity, vosMap.get(dbEntity.getSourceId()));
                fillTypeName(saveEntity);
                saveList.add(saveEntity);
                vosMap.remove(dbEntity.getSourceId());
            }
        }

        if(!vosMap.isEmpty()) {
            //新增
            List<SettlePoolEntity> newList = BeanMapper.mapList(vosMap.values(), SettlePoolEntity.class);
            newList.forEach(item -> {
                billCheck(item);
                fillTypeName(item);
                if (item.getResidueApplyMny()==null){
                    item.setResidueApplyMny(item.getCurTaxMny()==null?BigDecimal.ZERO:item.getCurTaxMny());
                }
                item.setAlreadyApplyMny(BigDecimal.ZERO);
                findDetailUrl(item);
                //新增走下物理删除逻辑，防止数据insert时主键重复
                poolMapper.delBySourceId(item.getSourceId());
            });
            saveList.addAll(newList);
        }

        super.saveOrUpdateBatch(saveList, saveList.size(), false);

        return BeanMapper.mapList(saveList, SettlePoolVO.class);
    }

    private void billCheck(SettlePoolEntity settle) {
        if(null == settle.getSourceId()) {
            throw new BusinessException("同步结算单失败， 结算单来源业务单据id-[sourceId]为空！");
        }
        if(null != settle.getId() && !settle.getId().equals(settle.getSourceId())) {
            throw new BusinessException("同步结算单失败， 结算单Id与sourceId不一致！");
        }
        if(StringUtils.isBlank(settle.getSourceType())) {
            throw new BusinessException("同步结算单失败， 结算单业务类型-[sourceType]为空！");
        }
        if(null == settle.getSettleProperty()) {
            throw new BusinessException("同步结算单失败， 结算单属性类别-[settleProperty]为空！");
        }
        if(null == settle.getContractFlag()) {
            throw new BusinessException("同步结算单失败， 结算单合同标识字段为空-[contractFlag]为空！");
        }
        if(null == settle.getUltimateFlag()) {
            throw new BusinessException("同步结算单失败， 结算单合是否最终结算标识为空-[ultimateFlag]为空！");
        }
        if(settle.getContractFlag().equals(1) &&  null == settle.getContractId()) {
            throw new BusinessException("同步结算单失败， 结算单合同Id为空-[contractId]为空！");
        }
        if(null == settle.getHandleType()) {
            settle.setHandleType(0); //业务系统推送
        }

    }

    private void fillTypeName(SettlePoolEntity item) {
        if(StringUtils.isNotBlank(item.getSourceType())) {
            SettleSourceTypeEnum settleType = SettleSourceTypeEnum.getByCode(item.getSourceType());
            if(null != settleType) {
                item.setSettleSourceTypeName(settleType.getName());
            }
        }
        if(StringUtils.isNotBlank(item.getContractType())) {
            ContractTypeEnum ct = ContractTypeEnum.getByCode(item.getContractType());
            if(null != ct) {
                item.setContractTypeName(ct.getTypeName());
            }
        }
    }

    private SettlePoolEntity copyProperty(SettlePoolEntity dbEntity, SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity saveEnitty = null;
        //更新
        if(UpdateLevelEnum.全量覆盖更新.getLevelCode().equals(saveOrUpdateVO.getUpdateLevel())) {
            logger.info("全量更新结算单：{}", JSONObject.toJSONString(saveOrUpdateVO));
            //全量覆盖更新
            saveEnitty = BeanMapper.map(saveOrUpdateVO, SettlePoolEntity.class);
        } else {
            //部分更新
            saveEnitty = BeanMapper.map(dbEntity, SettlePoolEntity.class);
            String[] updateFields = BeanUtil.getPropertyNames(saveOrUpdateVO, saveOrUpdateVO.getUpdateLevel());
            logger.info("部分更新结算单：{}, 本次更新字段-{}", JSONObject.toJSONString(saveOrUpdateVO), JSONObject.toJSONString(updateFields));
            BeanUtils.copyProperties(saveOrUpdateVO, saveEnitty, updateFields);
            logger.info("待更新结算单数据：{}, 本次更新字段-{}", JSONObject.toJSONString(saveEnitty), JSONObject.toJSONString(updateFields));
        }

        saveEnitty.setId(dbEntity.getId());
        saveEnitty.setVersion(dbEntity.getVersion());
        saveEnitty.setCreateTime(dbEntity.getCreateTime());
        saveEnitty.setCreateUserCode(dbEntity.getCreateUserCode());

        //若PC或移动端详情地址为空，则根据字典信息设置详情地址
        findDetailUrl(saveEnitty);

        return saveEnitty;
    }

    /**
     * 详情地址填充
     *  暂时先设置结算单和合同的穿透详情页
     *
     * @param saveEntity
     */
    private void findDetailUrl(SettlePoolEntity saveEntity) {
        List<String> sourceTypes = new ArrayList<>();
        //查询结算单PC详情URL
        if(StringUtils.isNotBlank(saveEntity.getSourceType())) {
            sourceTypes.add(saveEntity.getSourceType()+"Pc");
        }

        //查询合同详PC情页URL
        if(StringUtils.isNotBlank(saveEntity.getContractType())) {
            sourceTypes.add(saveEntity.getContractType()+"PC");
        }

        //合同来源类型不为空
        Map<String, String> urlMap = billUrlDictService.getDictMapBySourceTypes(sourceTypes);
        logger.info("结算单id-{}，查询详情参数-{}， 结果：{}", saveEntity.getId(), JSONObject.toJSONString(sourceTypes), JSONObject.toJSONString(urlMap));

        if(MapUtils.isNotEmpty(urlMap)) {
            //不覆盖已有的详情地址
            if(StringUtils.isBlank(saveEntity.getBillCodeUrl()) &&  null != urlMap.get(saveEntity.getSourceType()+"Pc")) {
                saveEntity.setBillCodeUrl(urlMap.get(saveEntity.getSourceType()+"Pc"));
            }
            if(StringUtils.isBlank(saveEntity.getContractUrl()) && null != urlMap.get(saveEntity.getContractType()+"Pc")) {
                saveEntity.setContractUrl(urlMap.get(saveEntity.getContractType()+"Pc"));
            }
        }
        if(null == saveEntity.getHandleType()) {
            saveEntity.setHandleType(0); //业务系统推送
        }

        if(null == saveEntity.getId()) {
            saveEntity.setId(saveEntity.getSourceId());
        }

        if(StringUtils.isBlank(saveEntity.getSettleSourceTypeName())) {
            saveEntity.setSettleSourceTypeName(SettleSourceTypeEnum.getByCode(saveEntity.getSourceType()).getName());
        }

        if(null != saveEntity.getContractId()) {
            ContractPoolEntity contract = contractPoolMapper.selectById(saveEntity.getContractId());
            if(null == contract) {
                logger.error("新增同步结算单-【{}】失败,，合同池无匹配合同数据！", JSONObject.toJSONString(saveEntity));
                throw new BusinessException("同步结算单失败，合同池无匹配合同数据！");
            }
            if(StringUtils.isBlank(saveEntity.getContractName())) {
                saveEntity.setContractName(contract.getContractName());
            }
            if(StringUtils.isBlank(saveEntity.getContractCode())) {
                saveEntity.setContractCode(saveEntity.getContractCode());
            }
            if(StringUtils.isBlank(saveEntity.getContractUrl())) {
                saveEntity.setContractUrl(contract.getPcCardUrl());
            }
            if(StringUtils.isBlank(saveEntity.getContractType())) {
                saveEntity.setContractType(contract.getSourceType());
            }
            if(StringUtils.isBlank(saveEntity.getContractTypeName())) {
                saveEntity.setContractTypeName(contract.getSourceTypeName());
            }
            if(null == saveEntity.getSupplementFlag()) {
                saveEntity.setSupplementFlag(contract.getSupplementFlag());
            }
            if(null == saveEntity.getMaiContractId()) {
                saveEntity.setMaiContractId(contract.getMainContractId());
            }
            if(StringUtils.isBlank(saveEntity.getMaiContractCode())) {
                saveEntity.setMaiContractCode(contract.getMainContractCode());
            }
            if(StringUtils.isBlank(saveEntity.getMaiContractName())) {
                saveEntity.setMaiContractName(contract.getMainContractName());
            }
            if(StringUtils.isBlank(saveEntity.getSettleSourceTypeName())) {
                saveEntity.setSettleSourceTypeName(SettleSourceTypeEnum.getByCode(saveEntity.getSourceType()).getName());
            }
            if(StringUtils.isBlank(saveEntity.getPartyaName())) {
                saveEntity.setPartyaName(contract.getPartyaName());
            }
            if(null == saveEntity.getPartyaId()) {
                saveEntity.setPartyaId(contract.getPartyaId());
            }
            if(StringUtils.isBlank(saveEntity.getPartybName())) {
                saveEntity.setPartybName(contract.getPartybName());
            }
            if(null == saveEntity.getPartybId()) {
                saveEntity.setPartybId(contract.getPartybId());
            }
            if(null == saveEntity.getDepartmentId()) {
                saveEntity.setDepartmentId(contract.getDepartmentId());
            }
            if(StringUtils.isBlank(saveEntity.getDepartmentName())) {
                saveEntity.setDepartmentName(contract.getDepartmentName());
            }
            if(null == saveEntity.getProjectId()) {
                saveEntity.setProjectId(contract.getProjectId());
            }
            if(null == saveEntity.getOrgId()) {
                saveEntity.setOrgId(contract.getOrgId());
            }
            if(null == saveEntity.getParentOrgId()) {
                saveEntity.setParentOrgId(contract.getParentOrgId());
            }
            if(StringUtils.isBlank(saveEntity.getProjectCode())) {
                saveEntity.setProjectCode(contract.getProjectCode());
            }
            if(StringUtils.isBlank(saveEntity.getOrgCode())) {
                saveEntity.setOrgCode(contract.getOrgCode());
            }
            if(StringUtils.isBlank(saveEntity.getParentOrgCode())) {
                saveEntity.setParentOrgCode(contract.getParentOrgCode());
            }
            if(StringUtils.isBlank(saveEntity.getProjectName())) {
                saveEntity.setProjectName(contract.getProjectName());
            }
            if(StringUtils.isBlank(saveEntity.getOrgName())) {
                saveEntity.setOrgName(contract.getOrgName());
            }
            if(StringUtils.isBlank(saveEntity.getParentOrgName())) {
                saveEntity.setParentOrgName(contract.getParentOrgName());
            }
        }

    }

    @Override
    public SettlePoolVO getBySourceId(Long sourceId) {
        SettlePoolEntity dbEntity = selectBySourceId(sourceId);
        if(null !=dbEntity) {
            return BeanMapper.map(dbEntity, SettlePoolVO.class);
        }
        return null;
    }

    @Override
    public List<SettlePoolVO> getBySourceIds(List<Long> sourceIds) {
        List<SettlePoolEntity> list = selectBySourceIds(sourceIds);
        if(CollectionUtils.isNotEmpty(list)) {
            return BeanMapper.mapList(list, SettlePoolVO.class);
        } else {
            return new ArrayList<>();
        }
    }

    // 根据合同ID，来源类型查询数据，工人工资支付申请卡片页面查询累计月度结算和累计节点结算数据使用
    @Override
    public Map<String, BigDecimal> queryLaborMny(Long contractId) {
        logger.info("ejc-contractbase-impl***SettlePoolServiceImpl***queryLaborMny方法***begin***contractId-{}", contractId);
        Map<String, BigDecimal> resMap = new HashMap<>();
        QueryWrapper<SettlePoolEntity> query = new QueryWrapper<>();
        query.select("sum(if(source_type = 'labor_month', cur_tax_mny, 0)) as totalProcessSettleNum, sum(if(source_type = 'labor_node', cur_tax_mny, 0)) as totalNodeSettleNum");
        query.eq("contract_id", contractId);
        query.in("source_type", Arrays.asList(new String[]{SettleSourceTypeEnum.劳务分包月度结算.getCode(), SettleSourceTypeEnum.劳务分包节点结算.getCode()}));
        Map rs = super.getMap(query);

        resMap.put("nodeTotal", null != rs && null != rs.get("totalNodeSettleNum") ? new BigDecimal(rs.get("totalNodeSettleNum").toString()) : BigDecimal.ZERO);
        resMap.put("processTotal", null != rs && null != rs.get("totalProcessSettleNum") ? new BigDecimal(rs.get("totalProcessSettleNum").toString()) : BigDecimal.ZERO);
        logger.info("ejc-contractbase-impl***SettlePoolServiceImpl***queryLaborMny方法***end***返回结果-{}", JSONObject.toJSONString(resMap, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return resMap;
    }

    @Override
    public BigDecimal calcTotalMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(if(source_type in ('labor_final','pro_final'), ifnull(total_node_tax_difference,0), cur_tax_mny)) as totalMny");
        Map<String, BigDecimal> result = super.getMap(wrapper);
        return  null != result && null != result.get("totalMny") ? result.get("totalMny") : BigDecimal.ZERO;
    }

    @Override
    public SettlePoolVO queryTotalMny(SettlePoolVO settlePoolVO) {
        //查询 当前合同下的 结算金额
        QueryParam queryParam = new QueryParam();

        if(null != settlePoolVO.getContractId()) {
            queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,settlePoolVO.getContractId()));
        }
        if(null != settlePoolVO.getContractType()) {
            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ,settlePoolVO.getContractType()));
        }
        if(null != settlePoolVO.getProjectId()) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ,settlePoolVO.getProjectId()));
        }

        //正常情况不区分 结算类型
        if (ContractTypeEnum.专业分包合同.getTypeCode().equals(settlePoolVO.getContractType())){
            List typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.专业分包最终结算.getCode());
            typeList.add(SettleSourceTypeEnum.专业分包月度结算.getCode());
            queryParam.getParams().put("source_type",new Parameter(QueryParam.IN,typeList));
        }
        if (ContractTypeEnum.劳务分包合同.getTypeCode().equals(settlePoolVO.getContractType())){
            List typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.劳务分包最终结算.getCode());
            typeList.add(SettleSourceTypeEnum.劳务分包月度结算.getCode());
            queryParam.getParams().put("source_type",new Parameter(QueryParam.IN,typeList));
        }
        //排除掉诉讼费结算单
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("source_type",  new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        queryParam.getComplexParams().add(c1);

        List<SettlePoolEntity> settleList = super.queryList(queryParam, false);
        BigDecimal totalMny = BigDecimal.ZERO;
        for(SettlePoolEntity entity:settleList){
            //分包的 累计结算金额 = 节点+完工节点结算差额
            if (SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(entity.getSourceType())
                    ||SettleSourceTypeEnum.专业分包最终结算.getCode().equals(entity.getSourceType())){
                if (entity.getTotalProcessTaxDifference()!=null) {
                    totalMny = totalMny.add(entity.getTotalProcessTaxDifference());
                }
            }else {
                totalMny = totalMny.add(entity.getCurTaxMny());
            }
        }
        SettlePoolVO settleVO = new SettlePoolVO();
        settleVO.setCurTaxMny(totalMny);
        return settleVO;
    }

    @Override
    public CommonResponse<JSONObject> queryNoContractTotalMny(SettlePoolVO settlePoolVO) {
        QueryParam queryParam = new QueryParam();
        if (settlePoolVO.getPartybId()!=null){
            queryParam.getParams().put("partyb_id",new Parameter(QueryParam.EQ, settlePoolVO.getPartybId()));

        }
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,settlePoolVO.getProjectId()));
        if(StringUtils.isNotBlank(settlePoolVO.getSourceType())) {
            if(settlePoolVO.getSourceType().indexOf(",") > 0) {
                queryParam.getParams().put("source_type",new Parameter(QueryParam.IN, settlePoolVO.getSourceType().split(",")));
            } else {
                queryParam.getParams().put("source_type",new Parameter(QueryParam.EQ,settlePoolVO.getSourceType()));
            }
        }

        if (settlePoolVO.getContractFlag()!=null){
            queryParam.getParams().put("contract_flag",new Parameter(QueryParam.EQ,settlePoolVO.getContractFlag()));
        }
        //只查审批通过的
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List<SettlePoolEntity> settleList = super.queryList(queryParam);
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        for(SettlePoolEntity entity:settleList){
            totalSettleMny = totalSettleMny.add(entity.getCurTaxMny());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalSettleMny",totalSettleMny);
        return CommonResponse.success(jsonObject);
    }

    private SettlePoolEntity selectBySourceId(Long sourceId) {
        QueryWrapper<SettlePoolEntity> query = new QueryWrapper();
        query.eq("source_id", sourceId)
                .eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.getOne(query);
    }

    private List<SettlePoolEntity> selectBySourceIds(List<Long> sourceIds) {
        QueryWrapper<SettlePoolEntity> query = new QueryWrapper();
        query.in("source_id", sourceIds)
                .eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(query);
    }

    // 数据导入
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称+&+项目编码 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同池查询到的数据，key为 当前行的合同名称+&+合同编码 ，value为查询到的合同池数据
        Map<String, ContractPoolEntity> contractPoolVoMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();

        // 无合同费用类型map
        Map<String, Map<String, Object>> payTypeNoContractMap = new HashMap<>();
        /*
        id: "1522760479528308738"
        name: "零星材料费用"
        code: "sporadic_material_fee"
         */
        HashMap<String, Object> payTypeMapMaterial = new HashMap<>();
        payTypeMapMaterial.put("id", "1522760479528308738");
        payTypeMapMaterial.put("name", "零星材料费用");
        payTypeMapMaterial.put("code", "sporadic_material_fee");
        payTypeNoContractMap.put("零星材料费用", payTypeMapMaterial);
        HashMap<String, Object> payTypeMapEquip = new HashMap<>();
        /*
        id: "1522760553071235074"
        name: "临时设备费用"
        code: "temp_equip_fee"
         */
        payTypeMapEquip.put("id", "1522760553071235074");
        payTypeMapEquip.put("name", "临时设备费用");
        payTypeMapEquip.put("code", "temp_equip_fee");
        payTypeNoContractMap.put("临时设备费用", payTypeMapEquip);

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportSettlePoolVO> successList = new ArrayList<>();
            List<ImportSettlePoolVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 14) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportSettlePoolVO detailVO = new ImportSettlePoolVO();
                    // 从Excel拿到的数据，并将数据放入detailvo中作为初始数据，当报错时也可以展示Excel中填写的所有内容
                    String parentOrgNameEx = datas.get(0);// 所属组织，必填项，与【组织管理】“组织名称”进行匹配
                    detailVO.setParentOrgName(parentOrgNameEx);
                    String contractNameEx = datas.get(1);// 合同名称，非必填，与【合同池】的“合同名称”进行匹配
                    detailVO.setContractName(contractNameEx);
                    String contractCodeEx = datas.get(2);// 合同编码，非必填，与【合同池】的“合同编码”进行匹配
                    detailVO.setContractCode(contractCodeEx);
                    String projectNameEx = datas.get(3);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String projectCodeEx = datas.get(4);// 项目编码，必填项，与【项目池】的“项目编码”进行匹配
                    detailVO.setProjectCode(projectCodeEx);
                    String settlePropertyNameEx = datas.get(5);// 属性类别，必填项，只能录入“收入”、“支出”，如果不是，需要提示
                    detailVO.setSettlePropertyName(settlePropertyNameEx);
                    String partyaNameEx = datas.get(6);// 合同甲方，必填项，与【客户库】的“客户名称”进行匹配
                    detailVO.setPartyaName(partyaNameEx);
                    String partybNameEx = datas.get(7);// 合同乙方，必填项，与【供应商库】的“供应商名称”进行匹配
                    detailVO.setPartybName(partybNameEx);
                    /*
                    结算单类型，必填项，只能录入：
                    产值报量、对甲报量、劳务分包月度结算、劳务分包节点结算、劳务分包竣工结算、专业分包月度结算、专业分包节点结算、
                    专业分包竣工结算、物资采购结算、设备采购结算、混凝土采购结算、周转材租入结算、设备租入计算、临时设备结算、
                    大型设备安拆结算、诉讼费结算、零星费用结算、其他支出结算、其他收入结算、周转材租出结算(公司)、
                    周转材租入结算(公司)、周转材采购结算(公司)、设备租出结算(公司)、设备租入结算(公司)
                     */
                    String sourceTypeNameEx = datas.get(8);
                    detailVO.setSourceTypeName(sourceTypeNameEx);
                    String settleDateStrEx = datas.get(9);// 结算日期，必填项，日期
                    String curTaxMnyEx = datas.get(10);// 本期结算金额，数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setCurTaxMnyStr(curTaxMnyEx);
                    String curMnyEx = datas.get(11);// 本期结算金额（无税），数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setCurMnyStr(curMnyEx);
                    String ultimateFlagNameEx = datas.get(12);// 是否最终结算，必填项，只能录入“是”或“否”
                    detailVO.setUltimateFlagName(ultimateFlagNameEx);
                    String memoEx = datas.get(13);// 备注
                    detailVO.setMemo(memoEx);

                    //
                    if (StringUtils.isBlank(parentOrgNameEx)) {
                        detailVO.setErrorMessage("所属组织不可为空");
                    } else {
                        // 与【组织管理】“组织名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(parentOrgNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                OrgVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据所属组织查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    orgVOMap.put(parentOrgNameEx, orgVO);
                                    // 封装数据
                                    orgIdP = orgVO.getId();
                                    detailVO.setParentOrgId(orgVO.getId());
                                    detailVO.setParentOrgCode(orgVO.getCode());
                                    detailVO.setParentOrgName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据所属组织查询数据失败");
                            }
                        } else {
                            OrgVO orgVO = orgVOMap.get(parentOrgNameEx);
                            detailVO.setParentOrgId(orgVO.getId());
                            detailVO.setParentOrgCode(orgVO.getCode());
                            detailVO.setParentOrgName(orgVO.getName());
                        }
                    }
                    //
                    if ((StringUtils.isNotBlank(contractNameEx) && StringUtils.isBlank(contractCodeEx))
                            || (StringUtils.isBlank(contractNameEx) && StringUtils.isNotBlank(contractCodeEx))){
                        // 合同名称和合同编码只有一个不为空
                        detailVO.setErrorMessage("合同名称和合同编码要么同时为空，要么同时不为空");
                    } else if (StringUtils.isNotBlank(contractNameEx) && StringUtils.isNotBlank(contractCodeEx)) {
                        // 合同名称和合同编码都不为空，此时为有合同结算单
                        detailVO.setContractFlag(1);
                        detailVO.setContractFlagName("是");
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(contractPoolVoMap) || contractPoolVoMap.get(contractNameEx + "&" + contractCodeEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            QueryWrapper<ContractPoolEntity> contractPoolEntityQueryWrapper = new QueryWrapper<>();
                            contractPoolEntityQueryWrapper
                                    .eq("contract_name", contractNameEx)
                                    .eq("contract_code", contractCodeEx)
                                    .eq("dr", 0)
                                    .eq("tenant_id", tenantid);
                            List<ContractPoolEntity> contractPoolEntityList = contractPoolMapper.selectList(contractPoolEntityQueryWrapper);
                            if (CollectionUtils.isEmpty(contractPoolEntityList)) {
                                // 没有匹配上合同
                                detailVO.setErrorMessage("合同名称和合同编码不匹配");
                            } else {
                                if (contractPoolEntityList.size() == 1) {
                                    // 只匹配到一条数据
                                    ContractPoolEntity contractPoolEntity = contractPoolEntityList.get(0);
                                    Long contractId = contractPoolEntity.getContractId();
                                    if (contractId == null) {
                                        detailVO.setErrorMessage("根据合同名称和合同编码查询到的数据的合同ID为空");
                                    } else {
                                        // 将查询到的数据缓存到map中
                                        contractPoolVoMap.put(contractNameEx + "&" + contractCodeEx, contractPoolEntity);
                                        // 封装数据
                                        detailVO.setContractId(contractId);
                                        detailVO.setContractCode(contractCodeEx);
                                        detailVO.setContractName(contractNameEx);
                                        // 此时（项目编码、项目名称、属性类别、合同甲方、合同乙方）等字段根据查询到的合同数据直接赋值
                                        setDetailVOPartData(detailVO, contractPoolEntity);
                                    }
                                } else {
                                    // 匹配到多条数据，直接返回错误
                                    detailVO.setErrorMessage("合同名称和合同编码不匹配");
                                }
                            }
                        } else {
                            ContractPoolEntity contractPoolEntity = contractPoolVoMap.get(contractNameEx + "&" + contractCodeEx);
                            // 封装数据
                            detailVO.setContractId(contractPoolEntity.getContractId());
                            detailVO.setContractCode(contractCodeEx);
                            detailVO.setContractName(contractNameEx);
                            // 此时（项目编码、项目名称、属性类别、合同甲方、合同乙方）等字段根据查询到的合同数据直接赋值
                            setDetailVOPartData(detailVO, contractPoolEntity);
                        }
                    } else {
                        // 合同名称和合同编码都为空，此时为无合同结算单
                        detailVO.setContractFlag(0);
                        detailVO.setContractFlagName("否");
                        // 合同名称和合同编码都为空，此时（项目编码、项目名称、属性类别、合同甲方、合同乙方）等字段根据当前行数据取值
                        if (StringUtils.isBlank(projectNameEx) || StringUtils.isBlank(projectCodeEx)) {
                            detailVO.setErrorMessage("项目名称或项目编码不可为空");
                        } else {
                            // 与【项目池】的“项目名称”和“项目编码”进行匹配
                            // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                            if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx + "&" + projectCodeEx) == null) {
                                // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                                CommonResponse<List<ProjectPoolSetVO>> projectListRes = projectPoolApi.queryProjectListByNameAndCodeAndTenantId(projectNameEx, projectCodeEx, tenantid);
                                if (projectListRes.isSuccess()) {
                                    List<ProjectPoolSetVO> projectList = projectListRes.getData();
                                    if (CollectionUtils.isEmpty(projectList)) {
                                        detailVO.setErrorMessage("项目名称和项目编码不匹配");
                                    } else {
                                        if (projectList.size() == 1) {
                                            ProjectPoolSetVO projectPoolSetVO = projectList.get(0);
                                            // 项目所在项目部id
                                            Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                            // 优先从缓存map中获取数据，减少数据库查询次数
                                            if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                                // 缓存map为空或无当前行数据，调用接口查询
                                                CommonResponse<OrgVO> orgVOCommonResponse = orgApi.detailById(projectDepartmentId);
                                                if (orgVOCommonResponse.isSuccess()) {
                                                    OrgVO orgVO = orgVOCommonResponse.getData();
                                                    if (orgVO == null) {
                                                        detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                    } else {
                                                        // 存入缓存map
                                                        projectOrgVoMap.put(projectDepartmentId.toString(), orgVO);
                                                        // 封装数据
                                                        String innerCode = orgVO.getInnerCode();
                                                        if (StringUtils.isEmpty(innerCode)) {
                                                            detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                        } else {
                                                            List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                            if (!innerCodes.contains(orgIdP)) {
                                                                detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                            } else {
                                                                detailVO.setOrgId(orgVO.getId());
                                                                detailVO.setOrgCode(orgVO.getCode());
                                                                detailVO.setOrgName(orgVO.getName());
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    detailVO.setErrorMessage("根据项目名称和编码查询所在项目部信息失败");
                                                }
                                            } else {
                                                // 缓存map有当前数据
                                                OrgVO orgVO = projectOrgVoMap.get(projectDepartmentId.toString());
                                                String innerCode = orgVO.getInnerCode();
                                                if (StringUtils.isEmpty(innerCode)) {
                                                    detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                } else {
                                                    List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                    if (!innerCodes.contains(orgIdP)) {
                                                        detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                    } else {
                                                        detailVO.setOrgId(orgVO.getId());
                                                        detailVO.setOrgCode(orgVO.getCode());
                                                        detailVO.setOrgName(orgVO.getName());
                                                    }
                                                }
                                            }
                                            // 将查询到的数据缓存到map中
                                            projectPoolVoMap.put(projectNameEx + "&" + projectCodeEx, projectPoolSetVO);
                                            // 封装数据
                                            detailVO.setProjectId(projectPoolSetVO.getId());
                                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                                            detailVO.setProjectName(projectPoolSetVO.getName());
                                        } else {
                                            detailVO.setErrorMessage("根据项目名称和项目编码查询项目失败");
                                        }
                                    }
                                } else {
                                    detailVO.setErrorMessage("根据项目名称和项目编码查询项目失败");
                                }
                            } else {
                                ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx + "&" + projectCodeEx);
                                detailVO.setProjectId(projectPoolSetVO.getId());
                                detailVO.setProjectCode(projectPoolSetVO.getCode());
                                detailVO.setProjectName(projectPoolSetVO.getName());
                            }
                        }
                        //
                        if (StringUtils.isBlank(settlePropertyNameEx)) {
                            detailVO.setErrorMessage("属性类别不可为空");
                        } else {
                            if ("收入".equals(settlePropertyNameEx)) {
                                detailVO.setSettleProperty(1);
                                detailVO.setSettlePropertyName(settlePropertyNameEx);
                            } else if ("支出".equals(settlePropertyNameEx)) {
                                detailVO.setSettleProperty(0);
                                detailVO.setSettlePropertyName(settlePropertyNameEx);
                            } else {
                                detailVO.setErrorMessage("属性类别填写不正确");
                            }
                        }
                        //
                        if (StringUtils.isBlank(partyaNameEx)) {
                            detailVO.setErrorMessage("合同甲方不可为空");
                        } else {
                            // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                            // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                            if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(partyaNameEx) == null) {
                                // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                                CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                                if (orgVORes.isSuccess()) {
                                    OrgVO orgVO = orgVORes.getData();
                                    if (orgVO == null) {
                                        detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                    } else {
                                        // 将查询到的数据缓存到map中
                                        orgVOMap.put(partyaNameEx, orgVO);
                                        // 封装数据
                                        detailVO.setPartyaId(orgVO.getId());
                                        detailVO.setPartyaName(orgVO.getName());
                                    }
                                } else {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                }
                            } else {
                                OrgVO orgVO = orgVOMap.get(partyaNameEx);
                                detailVO.setPartyaId(orgVO.getId());
                                detailVO.setPartyaName(orgVO.getName());
                            }
                        }
                        //
                        if (StringUtils.isBlank(partybNameEx)) {
                            detailVO.setErrorMessage("合同乙方不可为空");
                        } else {
                            // 与【供应商库】的“供应商名称”进行匹配
                            // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                            if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                                // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                                CommonResponse<SupplierVO> supplierVORes = shareSupplierApi.findOneByName(partybNameEx, tenantid);
                                if (supplierVORes.isSuccess()) {
                                    SupplierVO supplierVO = supplierVORes.getData();
                                    if (supplierVO == null) {
                                        detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                    } else {
                                        // 将查询到的数据缓存到map中
                                        supplierVOMap.put(partybNameEx, supplierVO);
                                        // 封装数据
                                        detailVO.setPartybId(supplierVO.getId());
                                        detailVO.setPartybName(supplierVO.getName());
                                    }
                                } else {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                }
                            } else {
                                SupplierVO supplierVO = supplierVOMap.get(partybNameEx);
                                detailVO.setPartybId(supplierVO.getId());
                                detailVO.setPartybName(supplierVO.getName());
                            }
                        }
                    }
                    //
                    if (StringUtils.isBlank(sourceTypeNameEx)) {
                        detailVO.setErrorMessage("结算单类型不可为空");
                    } else {
                        Integer contractFlag = detailVO.getContractFlag();
                        if (contractFlag == 0) {
                            // 无合同，只能是 临时设备结算和零星费用结算
                            if (!"临时设备结算".equals(sourceTypeNameEx) && !"零星费用结算".equals(sourceTypeNameEx)) {
                                detailVO.setErrorMessage("当前为无合同结算，结算单类型只能是临时设备结算或零星费用结算");
                            }
                        } else if (contractFlag == 1) {
                            // 有合同，不能是 临时设备结算和零星费用结算
                            if ("临时设备结算".equals(sourceTypeNameEx) || "零星费用结算".equals(sourceTypeNameEx)) {
                                detailVO.setErrorMessage("当前为无合同结算，结算单类型不能是临时设备结算或零星费用结算");
                            }
                        }
                        String sourceType = getSourceTypeBySourceTypeName(sourceTypeNameEx);
                        if (StringUtils.isBlank(sourceType)) {
                            detailVO.setErrorMessage("结算单类型填写不正确");
                        } else {
                            detailVO.setSourceTypeName(sourceTypeNameEx);
                            detailVO.setSourceType(sourceType);
                        }
                        // 无合同时，自动封装无合同费用类型字段内容
                        if (contractFlag == 0) {
                            // 零星费用结算 对应 零星材料费用
                            Map<String, Object> materialMap = payTypeNoContractMap.get("零星材料费用");
                            // 临时设备结算 对应 临时设备费用
                            Map<String, Object> equipMap = payTypeNoContractMap.get("临时设备费用");
                            if ("零星费用结算".equals(sourceTypeNameEx)) {
                                detailVO.setPayTypeNoContractId(Long.parseLong(materialMap.get("id").toString()));
                                detailVO.setPayTypeNoContractCode(materialMap.get("code").toString());
                                detailVO.setPayTypeNoContractName(materialMap.get("name").toString());
                            } else if ("临时设备结算".equals(sourceTypeNameEx)) {
                                detailVO.setPayTypeNoContractId(Long.parseLong(equipMap.get("id").toString()));
                                detailVO.setPayTypeNoContractCode(equipMap.get("code").toString());
                                detailVO.setPayTypeNoContractName(equipMap.get("name").toString());
                            }
                        }
                    }
                    //
                    if (StringUtils.isBlank(settleDateStrEx)) {
                        detailVO.setErrorMessage("本次结算日期不可为空");
                    } else {
                        try {
                            detailVO.setSettleDate(HSSFDateUtil.getJavaDate(Double.parseDouble(settleDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("本次结算日期填写不正确");
                        }
                    }
                    //
                    if (StringUtils.isBlank(curTaxMnyEx)) {
                        detailVO.setErrorMessage("本期结算金额不可为空");
                    } else {
                        try {
                            BigDecimal curTaxMny = new BigDecimal(curTaxMnyEx);
                            if (curTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("本期结算金额不可小于0");
                            } else {
                                detailVO.setCurTaxMny(curTaxMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("本期结算金额必须为数字");
                        }
                    }
                    //
                    if (StringUtils.isBlank(curMnyEx)) {
                        detailVO.setErrorMessage("本期结算金额（无税）不可为空");
                    } else {
                        try {
                            BigDecimal curMny = new BigDecimal(curMnyEx);
                            if (curMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("本期结算金额（无税）不可小于0");
                            } else {
                                detailVO.setCurMny(curMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("本期结算金额（无税）必须为数字");
                        }
                    }
                    // 计算本期结算税额
                    try {
                        BigDecimal curTax = new BigDecimal(curTaxMnyEx).subtract(new BigDecimal(curMnyEx));
                        if (curTax.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("本期结算金额不可小于本期结算金额（无税）");
                        } else {
                            detailVO.setCurTax(curTax.abs());
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("计算本期结算税额失败，本期结算金额和本期结算金额（无税）不可为空且必须为数字");
                    }
                    //
                    if (StringUtils.isBlank(ultimateFlagNameEx)) {
                        detailVO.setErrorMessage("是否最终结算不可为空");
                    } else {
                        if ("是".equals(ultimateFlagNameEx)) {
                            detailVO.setUltimateFlag(1);
                            detailVO.setUltimateFlagName(ultimateFlagNameEx);
                        } else if ("否".equals(ultimateFlagNameEx)) {
                            detailVO.setUltimateFlag(0);
                            detailVO.setUltimateFlagName(ultimateFlagNameEx);
                        } else {
                            detailVO.setErrorMessage("是否最终结算填写不正确");
                        }
                    }
                    //
                    if (StringUtils.isNotBlank(memoEx) && memoEx.length() > 100) {
                        detailVO.setErrorMessage("备注长度不可大于100");
                    } else {
                        detailVO.setMemo(memoEx);
                    }
                    // 封装返回的数据
                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
                        detailVO.setHandleType(1);
                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                }
            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            List<SettlePoolEntity> sucEntityList = BeanMapper.mapList(successList, SettlePoolEntity.class);
            if (CollectionUtils.isNotEmpty(sucEntityList)) {
                for (SettlePoolEntity entity : sucEntityList) {
                    SettlePoolVO saveOrUpdateVO = BeanMapper.map(entity, SettlePoolVO.class);
                    entity.setCreateTime(new Date());
                    UserContext userContext = sessionManager.getUserContext();
                    entity.setCreateUserCode(userContext.getUserCode());
                    entity.setCreateUserName(userContext.getUserName());
                    BillCodeParam billCodeParam = new BillCodeParam();
                    if (entity.getContractFlag() != null) {
                        if (entity.getContractFlag() == 0) {
                            // 无合同
                            billCodeParam = BillCodeParam.build(BILL_CODE_NO_CONTRACT, tenantid, saveOrUpdateVO);
                        } else {
                            // 有合同
                            billCodeParam = BillCodeParam.build(BILL_CODE, tenantid, saveOrUpdateVO);
                        }
                    }
                    CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                    if(billCodeRes.isSuccess()) {
                        entity.setBillCode(billCodeRes.getData());
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }

    // 将重复代码收取出来
    private void setDetailVOPartData(ImportSettlePoolVO detailVO, ContractPoolEntity contractPoolEntity) {
        // 项目
        detailVO.setProjectId(contractPoolEntity.getProjectId());
        detailVO.setProjectCode(contractPoolEntity.getProjectCode());
        detailVO.setProjectName(contractPoolEntity.getProjectName());
        // 项目部信息
        detailVO.setOrgId(contractPoolEntity.getOrgId());
        detailVO.setOrgCode(contractPoolEntity.getOrgCode());
        detailVO.setOrgName(contractPoolEntity.getOrgName());
        // 属性类别
        detailVO.setSettleProperty(contractPoolEntity.getContractProperty());
        // 甲方
        detailVO.setPartyaId(contractPoolEntity.getPartyaId());
        detailVO.setPartyaName(contractPoolEntity.getPartyaName());
        // 乙方
        detailVO.setPartybId(contractPoolEntity.getPartybId());
        detailVO.setPartybName(contractPoolEntity.getPartybName());
    }

    // 根据结算单类型名称获取结算单类型编码
    private String getSourceTypeBySourceTypeName(String sourceTypeName) {
        String sourceType = "";
        switch (sourceTypeName) {
            case "产值报量":
                sourceType = "product_value";
                break;
            case "对甲报量":
                sourceType = "product_value_first";
                break;
            case "劳务分包月度结算":
                sourceType = "labor_month";
                break;
            case "劳务分包节点结算":
                sourceType = "labor_node";
                break;
            case "劳务分包竣工结算":
                sourceType = "labor_final";
                break;
            case "专业分包月度结算":
                sourceType = "pro_month";
                break;
            case "专业分包节点结算":
                sourceType = "pro_node";
                break;
            case "专业分包竣工结算":
                sourceType = "pro_final";
                break;
            case "设备采购结算":
                sourceType = "equip_buy_in";
                break;
            case "混凝土采购结算":
                sourceType = "beton_buy_in";
                break;
            case "物资采购结算":
                sourceType = "material_buy_in";
                break;
            case "周转材租入结算":
                sourceType = "material_week_rent_in";
                break;
            case "设备租入结算":
                sourceType = "equip_rent_in";
                break;
            case "临时设备结算":
                sourceType = "temp_equip";
                break;
            case "零星费用结算":
                sourceType = "sporadic_material";
                break;
            case "大型设备安拆结算":
                sourceType = "big_equip_install_uninstall";
                break;
            case "诉讼费结算":
                sourceType = "law_cost";
                break;
            case "其他支出结算":
                sourceType = "other_out";
                break;
            case "其他收入结算":
                sourceType = "other_in";
                break;
            case "周转材租出结算（公司）":
                sourceType = "material_week_rent_out_company";
                break;
            case "周转材租入结算（公司）":
                sourceType = "material_week_rent_in_company";
                break;
            case "周转材采购结算（公司）":
                sourceType = "material_week_buy_in_company";
                break;
            case "设备组出结算（公司）":
                sourceType = "equip_rent_out_company";
                break;
            case "设备租入结算（公司）":
                sourceType = "equip_rent_in_company";
                break;
            default:
                break;
        }
        return sourceType;
    }


    /**
     * 根据项目id查询结算池中结算类型为产值报量的累计产值金额
     *
     * @param projectId 项目id
     *
     * @return 累计产值金额 = “本期结算金额(含税)”之和
     */
    @Override
    public BigDecimal fetchTotalProductValueTaxMny(Long projectId) {
        QueryWrapper<SettlePoolEntity> queryWrapper = Wrappers.query();
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("source_type", "product_value");
        queryWrapper.select("ifnull(sum(cur_tax_mny), 0) as total");
        Map<String, Object> resultMap = super.getMap(queryWrapper);
        if (resultMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(resultMap.get("total").toString());
    }

    /**
     * 根据合同id查询该合同的所有【结算池】数据，汇总“本期结算金额”之和
     *
     * @param contractIds 合同id集合
     *
     * @return 累计结算金额
     */
    @Override
    public Map<String, Object> fetchTotalSettleTaxMny(Collection<Long> contractIds) {
        HashMap<String, Object> result = new HashMap<>();
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new BusinessException("合同id集合不能为空");
        }
        QueryWrapper<SettlePoolEntity> queryWrapper = Wrappers.query();
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in("contract_id", contractIds);
        queryWrapper.groupBy("contract_id");
        queryWrapper.select("contract_id as contractId, ifnull(sum(cur_tax_mny), 0) as total");
        List<Map<String, Object>> resultMaps = super.listMaps(queryWrapper);
        if (CollectionUtils.isEmpty(resultMaps)) {
            return Collections.emptyMap();
        }

        for (Map<String, Object> map : resultMaps) {
            if (!result.containsKey(map.get("contractId").toString())) {
                result.put(map.get("contractId").toString(), map.get("total").toString());
            }
        }
        return result;
    }

    @Override
    public Map<String, BigDecimal> queryContractsTotalSettleMny(QueryParam queryParam) {
        Map<String, Parameter> params = queryParam.getParams();

        //正常情况不区分 结算类型
        List<String> settleType = new ArrayList<>();
        if(null != params.get("contractType")) {
            List<String> contractTypeList = new ArrayList<>();
            Object contractTypeObj = params.get("contractType").getValue();

           if(contractTypeObj instanceof String) {
                contractTypeList.addAll(Arrays.asList(params.get("contractType").getValue().toString().split(",")));
            } else {
                contractTypeList.addAll(JSONObject.parseArray(JSONObject.toJSONString(contractTypeObj), String.class));
            }

            ComplexParam cp1 = new ComplexParam();
            cp1.setLogic(ComplexParam.AND);

            if(contractTypeList.contains(ContractTypeEnum.专业分包合同.getTypeCode())) {
                settleType.add(SettleSourceTypeEnum.专业分包最终结算.getCode());
                settleType.add(SettleSourceTypeEnum.专业分包节点结算.getCode());
                contractTypeList.remove(ContractTypeEnum.专业分包合同.getTypeCode());
            }
            if (contractTypeList.contains(ContractTypeEnum.劳务分包合同.getTypeCode())){
                settleType.add(SettleSourceTypeEnum.劳务分包最终结算.getCode());
                settleType.add(SettleSourceTypeEnum.劳务分包节点结算.getCode());
                contractTypeList.remove(ContractTypeEnum.劳务分包合同.getTypeCode());
            }

            if(contractTypeList.contains(ContractTypeEnum.物资采购合同.getTypeCode())) {
                settleType.add(SettleSourceTypeEnum.零星材料结算.getCode());
            }
            if(contractTypeList.indexOf(ContractTypeEnum.临时设备.getTypeCode()) >= 0) {
                settleType.add(SettleSourceTypeEnum.临时设备结算.getCode());
            }


            if(CollectionUtils.isNotEmpty(settleType)) {
                ComplexParam cp3 = new ComplexParam();
                cp3.setLogic(ComplexParam.OR);
                cp3.getParams().put("source_type", new Parameter(QueryParam.IN, StringUtils.join(settleType, ",")));
                cp1.getComplexParams().add(cp3);
                queryParam.getComplexParams().add(cp1);

                if(CollectionUtils.isNotEmpty(contractTypeList)) {
                    ComplexParam cp2 = new ComplexParam();
                    cp2.setLogic(ComplexParam.OR);
                    cp2.getParams().put("contract_type", new Parameter(QueryParam.IN, StringUtils.join(contractTypeList, ",")));
                    cp1.getComplexParams().add(cp2);
                }
                queryParam.getParams().remove("contractType");
            }
        }

        //排除掉诉讼费结算单
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("source_type",  new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        queryParam.getComplexParams().add(c1);

        List<SettlePoolEntity> settleList = super.queryList(queryParam, false);
        BigDecimal totalMny = null;
        Map<String, BigDecimal> resp = new HashMap<>();

        String tmpContractType = null;
        for(SettlePoolEntity entity : settleList){
            tmpContractType = Integer.valueOf(1).equals(entity.getContractFlag()) ? entity.getContractType() :
                    SettleSourceTypeEnum.零星材料结算.getCode().equals(entity.getSourceType()) ? ContractTypeEnum.物资采购合同.getTypeCode() : ContractTypeEnum.临时设备.getTypeCode();
            totalMny = resp.get(tmpContractType);
            if(null == totalMny) {
                totalMny = BigDecimal.ZERO;
            }
            //分包的 累计结算金额 = 节点+完工节点结算差额
            if (SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(entity.getSourceType())
                    ||SettleSourceTypeEnum.专业分包最终结算.getCode().equals(entity.getSourceType())){
                if (entity.getTotalNodeTaxDifference()!=null) {
                    totalMny = totalMny.add(entity.getTotalNodeTaxDifference());
                }
            }else {
                totalMny = totalMny.add(entity.getCurTaxMny());
            }
            resp.put(tmpContractType, totalMny);
        }
        SettlePoolVO settleVO = new SettlePoolVO();
        settleVO.setCurTaxMny(totalMny);
        return resp;
    }

    @Override
    public Map<String, Object> count(Map<String, Object> paramMap) {
        Map<String, Object> resp = new HashMap<>();

        Map<String, Object> rs = poolMapper.countSettleInfo(paramMap);
        if(null == rs) {
            rs = new HashMap<>();
        }

        resp.put("total", null == rs.get("total") ? 0 : Integer.valueOf(rs.get("total").toString()));
        resp.put("curTotalSettleMny", null == rs.get("curTotalSettleMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("curTotalSettleMny").toString()));
        resp.put("curTotalSettleTaxMny", null == rs.get("curTotalSettleTaxMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("curTotalSettleTaxMny").toString()));
        resp.put("totalSettleMnyThisYear", null == rs.get("totalSettleMnyThisYear") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalSettleMnyThisYear").toString()));
        resp.put("totalSettleTaxMnyThisYear", null == rs.get("totalSettleTaxMnyThisYear") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalSettleTaxMnyThisYear").toString()));
        resp.put("totalStartSettleMny", null == rs.get("totalStartSettleMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalStartSettleMny").toString()));
        resp.put("totalStartSettleTaxMny", null == rs.get("totalStartSettleTaxMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalStartSettleTaxMny").toString()));

        return resp;
    }

    @Override
    public List<ContractSettleReportVO> pageList(Map<String, Object> paramMap) {
        return poolMapper.pageList(paramMap);
    }

}
