package com.ejianc.business.contractbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.mapper.TemplateVersionMapper;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;

/**
 * @author:刘家乐
 * @version: 1
 *  @document:
 */
@Service
public class TemplateVersionServiceImpl extends BaseServiceImpl<TemplateVersionMapper, TemplateVersionEntity> implements ITemplateVersionService {

    @Autowired
    private ITemplateService templateService;

    @Autowired
    private IAttachmentApi attachmentApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    @Transactional(rollbackFor = Exception.class)
    public TemplateVersionVO newTemplateVersion(TemplateVersionVO templateVersionVO) {
        TemplateEntity templateEntity = templateService.selectById(templateVersionVO.getTemplateId());

        TemplateVersionEntity tee = BeanMapper.map(templateVersionVO, TemplateVersionEntity.class);
        tee.setCategoryName(templateEntity.getCategoryName());
        tee.setCategoryId(templateEntity.getCategoryId());
        tee.setTenantId(templateEntity.getTenantId());
        tee.setTemplateName(templateEntity.getTemplateName());
        tee.setBillTypeCode(templateEntity.getBillTypeCode());
        tee.setMetadata(templateEntity.getMetadata());
        tee.setId(IdWorker.getId());

        //更新模板信息
        templateEntity.setFileId(tee.getFileId());
        templateEntity.setFilePath(tee.getFilePath());
        templateEntity.setFileName(tee.getFileName());
        templateEntity.setFileSize(tee.getFileSize());
        templateEntity.setFileType(tee.getFileType());
        templateEntity.setCurVersionId(tee.getId());
        templateEntity.setCurVersion(tee.getTemplateVersion());

        //模板文件拷贝
        CommonResponse<AttachmentVO> copyResp = attachmentApi.copyFile(tee.getFileId().toString(), tee.getId().toString(), "BT211109000000002", "template", false);
        if(!copyResp.isSuccess()) {
            logger.error("创建模板{} 版本信息失败, 模板文件拷贝失败: {}", JSONObject.toJSONString(templateVersionVO), JSONObject.toJSONString(copyResp));
            throw new BusinessException("创建模板版本信息失败, 模板文件拷贝失败");
        }
        AttachmentVO attach = copyResp.getData();
        tee.setFileId(attach.getId());
        tee.setFileName(attach.getFileName());
        tee.setFileSize(attach.getFileSize().intValue());
        tee.setFilePath(attach.getFilePath());

        super.saveOrUpdate(tee, false);
        templateService.saveOrUpdate(templateEntity, false);

        return BeanMapper.map(tee, TemplateVersionVO.class);
    }


    @Override
    public TemplateVersionEntity createVersion(TemplateEntity entity) {
        TemplateVersionEntity map = BeanMapper.map(entity, TemplateVersionEntity.class);
        map.setAttachIds(new ArrayList<>());
        map.setTemplateId(entity.getId());
        //如何设置版本号 版本号设置为id
        map.setTemplateVersion(1L);
        map.setId(IdWorker.getId());

        if(null != entity.getFileId()) {
            //模板文件拷贝
            CommonResponse<AttachmentVO> copyResp = attachmentApi.copyFile(entity.getFileId().toString(), map.getId().toString(), "BT211109000000002", "template", false);
            if(!copyResp.isSuccess()) {
                logger.error("创建模板{} 版本信息失败, 模板文件拷贝失败: {}", JSONObject.toJSONString(entity), JSONObject.toJSONString(copyResp));
                throw new BusinessException("创建模板版本信息失败, 模板文件拷贝失败");
            }
            AttachmentVO attach = copyResp.getData();
            map.setFileId(attach.getId());
            map.setFileName(attach.getFileName());
            map.setFileSize(attach.getFileSize().intValue());
            map.setFilePath(attach.getFilePath());
        }

        this.saveOrUpdate(map, false);
        return map;
    }

    @Override
    public TemplateVersionEntity updateVersion(TemplateEntity entity){
        TemplateVersionEntity versionEntity = this.selectById(entity.getCurVersionId());
        versionEntity.setFileSize(entity.getFileSize());
        versionEntity.setOnlinePath(entity.getOnlinePath());
        versionEntity.setFileName(entity.getFileName());
        versionEntity.setTemplateName(entity.getTemplateName());
        versionEntity.setFileType(entity.getFileType());
        versionEntity.setCategoryName(entity.getCategoryName());
        versionEntity.setCategoryId(entity.getCategoryId());
        versionEntity.setFileId(entity.getFileId());
        versionEntity.setMetadata(entity.getMetadata());
        this.saveOrUpdate(versionEntity, false);
        return versionEntity;
    }
}
