package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/9
 * @document:
 */
@RestController
@RequestMapping("clauseSettingController")
public class ClauseSettingController {

    /**此处需要根据实际修改*/
    private static final String BILL_CODE = "CATEGORY_RELATION";

/**SessionManager sessionManager;*/

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IClauseSettingService service;
    @Autowired
    private ICategoryRelationService relationService;
    @Autowired
    private ITemplateCategoryService categoryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     *  保存 or 修改接口
     * @param saveorUpdateVO 新增 或修改的条款
     * @return 返回新增或修改后的条款
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClauseSettingVO> saveOrUpdate(@RequestBody ClauseSettingVO saveorUpdateVO){
        ClauseSettingEntity entity = BeanMapper.map(saveorUpdateVO, ClauseSettingEntity.class);
        if(null == entity.getId()) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (saveorUpdateVO.getIds().isEmpty()) {
                throw new BusinessException("新增 条款请指定对应分类");
            } else {
                if (billCode.isSuccess()) {
                    entity.setId(IdWorker.getId());
                    entity.setEnableStatus(1);
                    entity.setCode(billCode.getData());
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                    //根据 合同类别id 查询到 顶级分类的数量
                    int sum = relationService.saveCategoryRelation(entity, saveorUpdateVO.getIds());
                    //查询到 当前租户下合同顶级分类的数量比对 并设计对应关系
                    if (this.getCategoryCount()==sum){
                        entity.setEnableType(1);
                    }else {
                        entity.setEnableType(2);
                    }
                }
            }
            entity.setNecessaryStatus(0); //默认非必填
        }else {
            entity = service.selectById(entity.getId());
            if (saveorUpdateVO.getEnableStatus().equals(entity.getEnableStatus())){
                //启用状态相等，证明改变了信息，对应关系表全删全加
                entity.setClauseName(saveorUpdateVO.getClauseName());
                entity.setRangeIds(saveorUpdateVO.getRangeIds());
                entity.setRangeNames(saveorUpdateVO.getRangeNames());
                entity.setSequence(saveorUpdateVO.getSequence());
                //新增条款内容
                entity.setContent(saveorUpdateVO.getContent());
                //是否必填
                entity.setNecessaryStatus(saveorUpdateVO.getNecessaryStatus());

                //根据 合同类别id 查询到 顶级分类的数量
                int sum = relationService.saveCategoryRelation(entity, entity.getRangeIds());
                //查询到 当前租户下合同顶级分类的数量比对 并设计对应关系
                if (this.getCategoryCount()==sum){
                    entity.setEnableType(1);
                }else {
                    entity.setEnableType(2);
                }
            }else {
                //启用状态不相等，证明只改变了启用状态，只需更新条款表启用状态
                entity.setEnableStatus(saveorUpdateVO.getEnableStatus());
            }
        }
        service.saveOrUpdate(entity,false);
        ClauseSettingVO map  = BeanMapper.map(entity,ClauseSettingVO.class);
        return CommonResponse.success(map);
    }

    /**
     * 分页查询接口
     */
    @RequestMapping(value = "/queryPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ClauseSettingVO>> queryPage(@RequestBody QueryParam param){
        if(null != param.getParams() && null != param.getParams().get("categoryId")) {
            //查询分类下所有的子分类
            TemplateCategoryEntity cateogory = categoryService.selectById(Long.valueOf(param.getParams().get("categoryId").getValue().toString()));
            if (null != cateogory){
                //查询设置可用范围的分类id
                QueryWrapper<CategoryRelationEntity> query = new QueryWrapper<>();
                query.eq("dr", 0);
                query.eq("tenant_id", InvocationInfoProxy.getTenantid());
                query.likeRight("category_inner_code", cateogory.getInnerCode());
                List<CategoryRelationEntity> categoryRelationEntities = relationService.list(query);

                if(CollectionUtils.isNotEmpty(categoryRelationEntities)){
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic(ComplexParam.AND);
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic(ComplexParam.OR);
                    c2.getParams().put("id",new Parameter(QueryParam.IN,categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic(ComplexParam.OR);
                    c3.getParams().put("enableType",new Parameter("eq",1));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                } else {
                    param.getParams().put("enableType",new Parameter("eq",1));
                }
            }else{
                return CommonResponse.error("招标类别不支持添加合同条款！");
            }
            param.getParams().remove("categoryId");
        }

        //租户分离
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence","asc");
        param.getOrderMap().put("createTime","desc");
        IPage<ClauseSettingEntity> page = service.queryPage(param, false);
        List<ClauseSettingVO> categoryVoList =
                BeanMapper.mapList(page.getRecords(), ClauseSettingVO.class);
        IPage<ClauseSettingVO> categoryVoPage = new Page<>();
        categoryVoPage.setCurrent(page.getCurrent());
        categoryVoPage.setRecords(categoryVoList);
        categoryVoPage.setSize(page.getSize());
        categoryVoPage.setTotal(page.getTotal());
        categoryVoPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", categoryVoPage);
    }
    /**
     * 修改 排序 和条款名
     */
    @RequestMapping(value = "/updateLitter",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClauseSettingVO> updateLitter(@RequestBody ClauseSettingVO t){
        ClauseSettingEntity clauseSettingEntity = service.selectById(t.getId());
        clauseSettingEntity.setClauseName(t.getClauseName());
        clauseSettingEntity.setSequence(t.getSequence());
        service.saveOrUpdate(clauseSettingEntity,false);
        ClauseSettingVO vo = BeanMapper.map(clauseSettingEntity, ClauseSettingVO.class);

        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long>  ids) {
        service.removeRelationByClause(ids);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/updateStatus",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClauseSettingVO> updateStatus(@RequestBody ClauseSettingVO clauseSettingVO){
        ClauseSettingVO vo = service.updateStatus(clauseSettingVO);
        return CommonResponse.success("操作成功！", vo);
    }

    /**
     * @return int 返回当前合同分类顶级的数量
     */
    private int getCategoryCount(){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("is_top",new Parameter("eq","0"));
        List<TemplateCategoryEntity> templateCategoryEntities = categoryService.queryList(queryParam);
        return templateCategoryEntities.size();
    }

    /**
     *  根据分类查询条款 劳务分包合同处调用
     * @param pageNumber 分页数据
     * @param pageSize 分页数据
     * @param condition  接收合同id categoryId
     * @return 返回当前合同可用条款 包含根据类别id查询到的 和适用与所有类别的条款
     */
    @ResponseBody
    @RequestMapping(value = "/queryClauseSetting",method = RequestMethod.GET)
    public CommonResponse<IPage<ClauseSettingVO>> queryClauseSetting(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition
            ){
        //封装参数
        QueryParam queryParam = new QueryParam();
        String categoryId = "categoryId";
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        //模糊查询参数
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("clauseName");

        queryParam.getParams().put("tenantId",new Parameter("eq", InvocationInfoProxy.getTenantid()));
        //查询启用
        queryParam.getParams().put("enableStatus",new Parameter("eq","1"));
        boolean onlyQueryAll = true;
        //判断是否传入condition 传入 查询 id未当前分类的和全分类可用的
        if(StringUtils.isNotBlank(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

            // 是否必填字段处理
            String ns = String.valueOf(conditionMap.get("necessaryStatus"));
            if (StringUtils.isNotBlank(ns) && !"null".equals(ns)) {
                List<Integer> nsList = Arrays.stream(ns.split(",")).map(Integer::parseInt).collect(Collectors.toList());
                queryParam.getParams().put("necessaryStatus", new Parameter("in", nsList));
            }

            if(null != conditionMap.get(categoryId)) {
                //类型转换 拿到categoryId
                Long id = Long.parseLong(conditionMap.get(categoryId).toString());
                QueryParam query = new QueryParam();
                query.getParams().put(categoryId,new Parameter("eq", id));
                //查询 合同条款 类别 关系表
                List<CategoryRelationEntity> categoryRelationEntities = relationService.queryList(query, false);
                //
                if(!categoryRelationEntities.isEmpty()){
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic(ComplexParam.AND);
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic(ComplexParam.OR);
                    c2.getParams().put("id",new Parameter(QueryParam.IN,categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic(ComplexParam.OR);
                    c3.getParams().put("enableType",new Parameter("eq",1));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    queryParam.getComplexParams().add(c1);
                    onlyQueryAll = false;
                }
            }
        }
        if(onlyQueryAll) {
            queryParam.getParams().put("enableType",new Parameter("eq",1));
        }
        queryParam.getOrderMap().put("sequence",QueryParam.ASC);
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<ClauseSettingEntity> pageData = service.queryPage(queryParam, false);
        IPage<ClauseSettingVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), ClauseSettingVO.class));
        return CommonResponse.success(result);
    }
}
