package com.ejianc.business.contractbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Collection;
import java.util.List;
import java.util.Map;


/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
public interface ITemplateCategoryService
        extends IBaseService<TemplateCategoryEntity> {
    /**
     * 用于新增模板类型 只要用于查询父级
     * @return 返回 全部父级
     */
    CommonResponse<IPage<TemplateCategoryVO>> getCategoryParent(QueryParam param);

    /**
     * 检查 当前合同属性是否存在
     */
    boolean checkProperty(String categoryProperty);
    /**
     * 合同模板 查询树形图
     * @return  TemplateCategoryVO
     */
    CommonResponse<List<TemplateCategoryVO>> queryTree();

    /**
     * 合同模板 修改的时候查询同级的下拉框选项
     * @return  TemplateCategoryVO
     */
    CommonResponse<List<TemplateCategoryVO>> querySameLevel(String id);

    /**
     * 修改停启用
     *  @return  TemplateCategoryVO
     */
    CommonResponse<TemplateCategoryVO> updateEnableStatus(TemplateCategoryVO categoryVO);

    /**
     * 删除 新增子级 同时验证 当前分类是否可以被删除
     *  @return  TemplateCategoryVO
     */
    CommonResponse<String> deleteOrCheck(List<TemplateCategoryVO> vos);


    /**
     * 根据分类 删除分类和条款相关信息
     * @param vos
     */
    void removeRelationByCategory(List<TemplateCategoryVO> vos);

    CommonResponse<List<TemplateCategoryVO>> querySameLevel(String categoryId, String range);

    /**
     * 根据模板Id查询对应分类信息
     *
     * @param templateId
     * @return
     */
    TemplateCategoryEntity getOneByTemplateId(Long templateId);

    List<Map> setTenderResultMapList(TemplateCategoryEntity entity, Map<String, List<DefdocDetailVO>> defdocMap);

    List<String> getAllDefDocContent();

    Boolean getTenderFlag(String billTypeCode);
}
