/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.service.impl;

import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.CategoryRelationMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryRelationServiceImpl
extends BaseServiceImpl<CategoryRelationMapper, CategoryRelationEntity>
implements ICategoryRelationService {
    @Autowired
    private ITemplateCategoryService categoryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CategoryRelationMapper categoryRelationMapper;

    @Override
    public int saveCategoryRelation(ClauseSettingEntity entity, String ids) {
        int sum = 0;
        List<String> categoryIdList = Arrays.asList(ids.split(","));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", categoryIdList));
        List templateCategoryList = this.categoryService.queryList(param);
        ArrayList<Long> clauseIds = new ArrayList<Long>();
        clauseIds.add(entity.getId());
        this.deleteRelationByClause(clauseIds);
        ArrayList<CategoryRelationEntity> insertList = new ArrayList<CategoryRelationEntity>();
        if (CollectionUtils.isNotEmpty((Collection)templateCategoryList)) {
            for (TemplateCategoryEntity templateCategoryEntity : templateCategoryList) {
                CategoryRelationEntity relationEntity = new CategoryRelationEntity();
                if (0 == templateCategoryEntity.getIsTop()) {
                    ++sum;
                }
                relationEntity.setClauseId(entity.getId());
                relationEntity.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                relationEntity.setCategoryInnerCode(templateCategoryEntity.getInnerCode());
                relationEntity.setCategoryId(templateCategoryEntity.getId());
                relationEntity.setCreateUserCode(UserContext.getUserContext().getUserCode());
                relationEntity.setTenantId(InvocationInfoProxy.getTenantid());
                insertList.add(relationEntity);
            }
        } else {
            throw new BusinessException("\u62db\u6807\u7c7b\u522b\u4e0d\u652f\u6301\u6dfb\u52a0\u5408\u540c\u6761\u6b3e\uff01");
        }
        this.logger.info("\u5206\u7c7b\u6761\u6b3e\u5173\u7cfb\u8868\u672c\u6b21\u65b0\u589e" + insertList.size() + "\u6761\u6570\u636e\uff01");
        this.saveOrUpdateBatch(insertList, insertList.size(), false);
        return sum;
    }

    @Override
    public void addRelationByCategory(TemplateCategoryEntity templateCategoryEntity, List<ClauseSettingEntity> clauseList) {
        ArrayList<CategoryRelationEntity> insertList = new ArrayList<CategoryRelationEntity>();
        if (CollectionUtils.isNotEmpty(clauseList)) {
            for (ClauseSettingEntity clauseEntity : clauseList) {
                CategoryRelationEntity relationEntity = new CategoryRelationEntity();
                relationEntity.setClauseId(clauseEntity.getId());
                relationEntity.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                relationEntity.setCategoryInnerCode(templateCategoryEntity.getInnerCode());
                relationEntity.setCategoryId(templateCategoryEntity.getId());
                relationEntity.setCreateUserCode(UserContext.getUserContext().getUserCode());
                relationEntity.setTenantId(InvocationInfoProxy.getTenantid());
                insertList.add(relationEntity);
            }
            this.saveOrUpdateBatch(insertList, insertList.size(), false);
            this.logger.info("\u5206\u7c7b\u6761\u6b3e\u5173\u7cfb\u8868\u672c\u6b21\u65b0\u589e" + insertList.size() + "\u6761\u6570\u636e\uff01");
        }
    }

    @Override
    public void deleteRelationByCategory(List<Long> categoryIds) {
        this.categoryRelationMapper.deleteRelationByCategory(categoryIds);
    }

    @Override
    public void deleteRelationByClause(List<Long> clauseIds) {
        this.categoryRelationMapper.deleteRelationByClause(clauseIds);
    }
}

