/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/templDetail/"})
public class TemplDetailExportSettingController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITemplDetailExportSettingService service;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITemplateCategoryService templateCategoryService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String EMPTY_EXPORT_PARAM_NAME = "P-W4AGu40184";

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<String> saveOrUpdate(@RequestBody List<TemplDetailExportSettingVO> vos) {
        this.service.saveOrUpdateVos(vos);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"getByTemplateId"})
    public CommonResponse<List<TemplDetailExportSettingVO>> getByTemplateId(@RequestParam(required=false) Long categoryId, @RequestParam(required=false) Long templateId) {
        QueryWrapper query;
        ArrayList<TemplDetailExportSettingVO> resp = new ArrayList<TemplDetailExportSettingVO>();
        if (null == categoryId && null == templateId) {
            return CommonResponse.success(resp);
        }
        CommonResponse response = this.paramConfigApi.getByCode(EMPTY_EXPORT_PARAM_NAME);
        Boolean emptyExportFlag = true;
        if (response.isSuccess() && response.getData() != null && "0".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            emptyExportFlag = false;
        }
        TemplateCategoryEntity categoryEntity = null;
        List detailList = null;
        if (null != categoryId) {
            query = new QueryWrapper();
            query.eq((Object)"category_id", (Object)categoryId);
            query.isNull((Object)"template_id");
            detailList = this.service.list((Wrapper)query);
            categoryEntity = (TemplateCategoryEntity)((Object)this.templateCategoryService.getById(categoryId));
        } else {
            query = new QueryWrapper();
            query.eq((Object)"template_id", (Object)templateId);
            detailList = this.service.list((Wrapper)query);
            categoryEntity = this.templateCategoryService.getOneByTemplateId(templateId);
        }
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Map<String, TemplDetailExportSettingVO> detailIdMap = detailList.stream().collect(Collectors.toMap(item -> item.getBelongEntityId().toString(), item -> (TemplDetailExportSettingVO)BeanMapper.map((Object)item, TemplDetailExportSettingVO.class)));
            CommonResponse classResp = this.mdClassApi.findAllByParentEntityId(((TemplDetailExportSettingEntity)((Object)detailList.get(0))).getMainEntityId());
            if (!classResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4e3b\u5b9e\u4f53\u3010id-{}\u3011\u5bf9\u5e94\u5b50\u5b9e\u4f53\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25:{}", (Object)((TemplDetailExportSettingEntity)((Object)detailList.get(0))).getMainEntityId(), (Object)JSONObject.toJSONString((Object)classResp));
                return CommonResponse.error((String)"\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u5b50\u5b9e\u4f53\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List mdSubEntityList = (List)classResp.getData();
            for (MdClassVO sub : mdSubEntityList) {
                if (detailIdMap.containsKey(sub.getId().toString())) {
                    resp.add(detailIdMap.get(sub.getId().toString()));
                    continue;
                }
                resp.add(this.generateTemplDetail(sub, categoryEntity, templateId, emptyExportFlag));
            }
        } else {
            CommonResponse mdReferResp = this.billTypeApi.queryMetadataByBillType(categoryEntity.getBillTypeCode());
            if (!mdReferResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u6a21\u677f\u5355\u636e\u7c7b\u578b-{}\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25:{}", (Object)categoryEntity.getBillTypeCode(), (Object)JSONObject.toJSONString((Object)mdReferResp));
                return CommonResponse.error((String)"\u6839\u636e\u6a21\u677f\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            MdReferVO mdReferVO = (MdReferVO)mdReferResp.getData();
            CommonResponse classResp = this.mdClassApi.findAllByParentEntityId(mdReferVO.getMetadataId());
            if (!classResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u4e3b\u5b9e\u4f53\u3010id-{}\u3011\u5bf9\u5e94\u5b50\u5b9e\u4f53\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25:{}", (Object)mdReferVO.getMetadataId(), (Object)JSONObject.toJSONString((Object)classResp));
                return CommonResponse.error((String)"\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u5b50\u5b9e\u4f53\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            for (MdClassVO sub : (List)classResp.getData()) {
                resp.add(this.generateTemplDetail(sub, categoryEntity, templateId, emptyExportFlag));
            }
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"delDetailExportSetting"})
    public CommonResponse<String> delDetailExportSetting(@RequestBody TemplDetailExportSettingVO exportSettingVO) {
        this.service.delByTemplateId(exportSettingVO.getTemplateId());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private TemplDetailExportSettingVO generateTemplDetail(MdClassVO sub, TemplateCategoryEntity category, Long templateId, Boolean emptyExportFlag) {
        TemplDetailExportSettingVO vo = new TemplDetailExportSettingVO();
        vo.setBelongEntityId(sub.getId());
        vo.setMainEntityId(sub.getParentId());
        vo.setBelongProjectId(sub.getProjectId());
        vo.setTableName(sub.getTableName());
        vo.setBillTypeCode(category.getBillTypeCode());
        vo.setEmptyExportFlag(emptyExportFlag);
        vo.setBelongOrgId(category.getBelongOrgId());
        vo.setBelongOrgCode(category.getBelongOrgCode());
        vo.setBelongOrgName(category.getBelongOrgName());
        vo.setDetailName(sub.getDisplayName());
        vo.setDetailSequence(Integer.valueOf(0));
        vo.setMainAttrName(sub.getMainAttributeField());
        vo.setCategoryId(category.getId());
        vo.setTemplateId(templateId);
        vo.setDetailStatus(Boolean.valueOf(true));
        vo.setRowState("add");
        vo.setId(Long.valueOf(IdWorker.getId()));
        return vo;
    }
}

