/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"templateCategoryController"})
public class TemplateCategoryController {
    private static final String BILL_CODE = "TEMPLATE_CATEGORY";
    private static final String BILL_TYPE_CODE = "BT211109000000001";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ITemplateCategoryService service;
    @Autowired
    IClauseSettingService clauseSettingService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getParams().put("is_top", new Parameter("eq", (Object)"0"));
        param.getOrderMap().put("sequence", "asc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List categoryEntityList = this.service.queryList(param, false);
        List categoryVOList = BeanMapper.mapList((Iterable)categoryEntityList, TemplateCategoryVO.class);
        for (TemplateCategoryVO e : categoryVOList) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter("eq", (Object)e.getId()));
            queryParam.getOrderMap().put("sequence", "asc");
            List entityLists = this.service.queryList(queryParam);
            List categoryVos = BeanMapper.mapList((Iterable)entityLists, TemplateCategoryVO.class);
            if (categoryVos.isEmpty()) {
                e.setChildren(null);
                continue;
            }
            e.setChildren(categoryVos);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)categoryVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateCategoryVO>> pageList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> saveOrUpdate(@RequestBody TemplateCategoryVO saveorUpdateVO) {
        TemplateCategoryEntity entity = (TemplateCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TemplateCategoryEntity.class));
        Boolean insertFlag = false;
        String newCategoryName = null;
        if (null == entity.getId()) {
            insertFlag = true;
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setId(IdWorker.getId());
            if (1 == entity.getIsTop()) {
                TemplateCategoryEntity parent = (TemplateCategoryEntity)((Object)this.service.selectById(entity.getPid()));
                entity.setInnerCode(parent.getInnerCode() + "|" + entity.getId());
                entity.setCategoryProperty(parent.getCategoryProperty());
                entity.setBillTypeCode(parent.getBillTypeCode());
            } else {
                if (!this.service.checkProperty(entity.getCategoryProperty())) return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u5c5e\u6027\u5df2\u5b58\u5728");
                entity.setInnerCode(entity.getId().toString());
            }
            entity.setCode((String)billCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
        } else {
            TemplateCategoryEntity beforeEntity = (TemplateCategoryEntity)((Object)this.service.selectById(entity.getId()));
            if (null != beforeEntity && !beforeEntity.getCategoryName().equals(saveorUpdateVO.getCategoryName())) {
                newCategoryName = saveorUpdateVO.getCategoryName();
            }
            if (null == entity.getBelongOrgId()) {
                entity.setBelongOrgCode(beforeEntity.getBelongOrgCode());
                entity.setBelongOrgId(beforeEntity.getBelongOrgId());
                entity.setBelongOrgId(beforeEntity.getBelongOrgId());
            }
        }
        if (null != saveorUpdateVO.getBelongOrgId()) {
            CommonResponse orgResp = this.orgApi.getOneById(saveorUpdateVO.getBelongOrgId());
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            entity.setBelongOrgInnerCode(((OrgVO)orgResp.getData()).getInnerCode());
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.clauseSettingService.updateClauseByCategory(entity, insertFlag, newCategoryName);
        TemplateCategoryVO vo = (TemplateCategoryVO)BeanMapper.map((Object)((Object)entity), TemplateCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> update(@RequestBody TemplateCategoryVO t) {
        TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)this.service.selectById(t.getId()));
        templateCategoryEntity.setCategoryName(t.getCategoryName());
        templateCategoryEntity.setSequence(t.getSequence());
        templateCategoryEntity.setContractPropertyId(t.getContractPropertyId());
        templateCategoryEntity.setContractPropertyCode(t.getContractPropertyCode());
        templateCategoryEntity.setContractPropertyName(t.getContractPropertyName());
        this.service.saveOrUpdate((Object)templateCategoryEntity, false);
        TemplateCategoryVO vo = (TemplateCategoryVO)BeanMapper.map((Object)((Object)templateCategoryEntity), TemplateCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateEnableStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> updateEnableStatus(@RequestBody TemplateCategoryVO categoryVO) {
        return this.service.updateEnableStatus(categoryVO);
    }

    @RequestMapping(value={"/queryAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<TemplateCategoryVO>> queryAll() {
        return this.service.queryTree();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateCategoryVO> vos) {
        for (TemplateCategoryVO vo : vos) {
            CommonResponse resp = this.billTypeApi.checkQuote(BILL_TYPE_CODE, vo.getId());
            this.logger.info("\u5408\u540c\u5206\u7c7b\u3010id-{}\u3011\uff0c\u3010BILL_TYPE_CODE-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{vo.getId(), BILL_TYPE_CODE, JSONObject.toJSONString((Object)resp)});
            if (resp.isSuccess()) continue;
            this.logger.info("\u5408\u540c\u5206\u7c7b\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            return CommonResponse.error((String)"\u5408\u540c\u5206\u7c7b\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.service.removeRelationByCategory(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/querySameLevel"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<List<TemplateCategoryVO>> querySameLevel(@RequestParam(value="categoryId") String categoryId, @RequestParam(required=false) String range) {
        return this.service.querySameLevel(categoryId, range);
    }

    @ResponseBody
    @RequestMapping(value={"/getCategoryParent"}, method={RequestMethod.GET})
    public CommonResponse<IPage<TemplateCategoryVO>> getCategoryParent(@RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        return this.service.getCategoryParent(param);
    }

    @PostMapping(value={"/wholeCategoryTree"})
    public CommonResponse<JSONObject> wholeCategoryTree(@RequestBody String condition) {
        JSONObject data = new JSONObject();
        data.put("data", this.categoryTree(condition));
        return CommonResponse.success((Object)data);
    }

    @GetMapping(value={"/categoryTree"})
    public List<Map<String, Object>> categoryTree(@RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("enable_status", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("categoryName");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Long categoryId;
            Object category;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("categoryId") && (category = (TemplateCategoryEntity)((Object)this.service.selectById(categoryId = Long.valueOf(Long.parseLong(conditionMap.get("categoryId").toString()))))) != null) {
                if (null != conditionMap.get("only")) {
                    queryParam.getParams().put("id", new Parameter("eq", (Object)categoryId));
                } else {
                    queryParam.getParams().put("categoryProperty", new Parameter("eq", (Object)((TemplateCategoryEntity)((Object)category)).getCategoryProperty()));
                }
            }
            if (null != conditionMap.get("range")) {
                String range = conditionMap.get("range").toString();
                switch (range) {
                    case "selfOrg": {
                        queryParam.getParams().put("belong_org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                        break;
                    }
                    case "selfAndBelow": {
                        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                            queryParam.getParams().put("belong_org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                            break;
                        }
                        CommonResponse orgVOListResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                        if (!orgVOListResp.isSuccess()) {
                            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        queryParam.getParams().put("belong_org_id", new Parameter("in", ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                        break;
                    }
                    case "parents": {
                        CommonResponse orgVOListResp = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                        if (!orgVOListResp.isSuccess()) {
                            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        queryParam.getParams().put("belong_org_id", new Parameter("in", ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                        break;
                    }
                }
            }
            if (null != conditionMap.get("categoryProperty")) {
                queryParam.getParams().put("categoryProperty", new Parameter("eq", conditionMap.get("categoryProperty")));
            } else if (null != conditionMap.get("categoryPropertys")) {
                queryParam.getParams().put("categoryProperty", new Parameter("in", (Object)conditionMap.get("categoryPropertys").toString()));
            }
            if ("true".equals(conditionMap.get("noParent"))) {
                queryParam.getParams().put("isTop", new Parameter("eq", (Object)1));
            }
            if (null != conditionMap.get("isTop")) {
                queryParam.getParams().put("isTop", new Parameter("eq", conditionMap.get("isTop")));
            }
            if (null != conditionMap.get("searchText")) {
                queryParam.setSearchText(conditionMap.get("searchText").toString());
            }
            if (conditionMap.containsKey("type") && null != conditionMap.get("type") && conditionMap.get("type").equals("paymentApply")) {
                queryParam.getParams().put("bill_type_code", new Parameter("ne", (Object)"EJCBT202212000002"));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (TemplateCategoryEntity entity : dataList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getCategoryName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getPid());
            map.put("isTop", entity.getIsTop());
            map.put("categoryProperty", entity.getCategoryProperty());
            map.put("billTypeCode", entity.getBillTypeCode());
            map.put("contractPropertyCode", entity.getContractPropertyCode());
            map.put("contractPropertyId", entity.getContractPropertyId());
            map.put("contractPropertyName", entity.getContractPropertyName());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @ResponseBody
    @RequestMapping(value={"/queryCategory"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryCategory(@RequestParam(value="categoryProperty") String categoryProperty) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("categoryProperty", new Parameter("eq", (Object)categoryProperty));
        queryParam.getParams().put("enable_status", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("is_top", new Parameter("eq", (Object)"1"));
        List templateCategoryEntities = this.service.queryList(queryParam, false);
        List templateCategory = BeanMapper.mapList((Iterable)templateCategoryEntities, TemplateCategoryVO.class);
        JSONObject jsonObject = new JSONObject();
        if (templateCategory.isEmpty()) {
            jsonObject.put("data", null);
            return CommonResponse.success((Object)jsonObject);
        }
        ArrayList list = new ArrayList();
        templateCategory.forEach(category -> {
            JSONObject o = (JSONObject)JSONObject.toJSON((Object)category);
            o.put("text", (Object)category.getCategoryName());
            o.put("value", (Object)category.getId());
            list.add(o);
        });
        jsonObject.put("data", list);
        return CommonResponse.success((Object)jsonObject);
    }
}

