/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/templDetail/"})
public class TemplDetailApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITemplDetailExportSettingService templDetailExportSettingService;
    @Autowired
    private ITemplateCategoryService templateCategoryService;

    @GetMapping(value={"findExportDetailByCategoryId"})
    CommonResponse<List<TemplDetailExportSettingVO>> findExportDetailByCategoryId(@RequestParam(required=false) Long categoryId, @RequestParam(required=false) Long templateId) {
        List entityList = null;
        TemplateCategoryEntity category = null;
        if (null == categoryId && null == templateId) {
            return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u5408\u540c\u5206\u7c7bId\u6216\u6a21\u677fId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (null != templateId) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"template_id", (Object)templateId);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            entityList = this.templDetailExportSettingService.list((Wrapper)query);
            this.logger.info("\u6839\u636e\u6a21\u677f[Id-{}]\u67e5\u8be2\u5bf9\u5339\u914d\u7684\u6e05\u5355\u8bbe\u7f6e\u5217\u8868\uff1a{}", (Object)templateId, (Object)JSONObject.toJSONString((Object)entityList));
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                category = this.templateCategoryService.getOneByTemplateId(templateId);
            } else {
                entityList = entityList.stream().filter(item -> item.getDetailStatus() != false && (null != item.getSysFileId() || null != item.getCustomFileId())).collect(Collectors.toList());
            }
        } else {
            category = (TemplateCategoryEntity)((Object)this.templateCategoryService.selectById(categoryId));
        }
        if (null != category) {
            entityList = this.templDetailExportSettingService.findExportDetailByCategoryId(category.getId(), category.getPid());
        }
        return CommonResponse.success((Object)BeanMapper.mapList(entityList, TemplDetailExportSettingVO.class));
    }
}

