/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.filing.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.FilingTypeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"filingType"})
public class FilingTypeController {
    private static final String BILL_CODE = "FIL_TYP";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFilingTypeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FilingTypeVO> saveOrUpdate(@RequestBody FilingTypeVO saveorUpdateVO) {
        CommonResponse billTypeRes;
        FilingTypeEntity entity = (FilingTypeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, FilingTypeEntity.class));
        if (null == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff01");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
        }
        if (!(billTypeRes = this.billTypeApi.queryMetadataByBillType(entity.getSourceQueryBillType())).isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01");
        }
        String tableName = ((MdReferVO)billTypeRes.getData()).getTableName();
        String projectName = ((MdReferVO)billTypeRes.getData()).getProjectName();
        String databaseName = ((MdReferVO)billTypeRes.getData()).getDatabaseName();
        entity.setQueryDatabaseName(databaseName);
        entity.setQueryTableName(tableName);
        entity.setQueryProjectName(((MdReferVO)billTypeRes.getData()).getProjectName());
        entity.setQueryUrl(this.BaseHost + projectName + "/queryPub/queryBillMap");
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f!", (Object)BeanMapper.map((Object)((Object)entity), FilingTypeVO.class));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("is_children", new Parameter("eq", (Object)0));
        List filingTypeEntities = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)filingTypeEntities, FilingTypeVO.class);
        for (FilingTypeVO entity : voList) {
            QueryParam childParam = new QueryParam();
            childParam.getParams().put("is_children", new Parameter("eq", (Object)1));
            childParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            childParam.getParams().put("dr", new Parameter("eq", (Object)0));
            List childrenList = this.service.queryList(childParam);
            List voChildList = BeanMapper.mapList((Iterable)childrenList, FilingTypeVO.class);
            if (CollectionUtil.isNotEmpty((Collection)voChildList)) {
                for (FilingTypeVO vo : voChildList) {
                    vo.setChildren(null);
                }
                entity.setChildren(voChildList);
                continue;
            }
            entity.setChildren(null);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FilingTypeVO> queryDetail(Long id) {
        FilingTypeEntity entity = (FilingTypeEntity)((Object)this.service.selectById(id));
        FilingTypeVO vo = (FilingTypeVO)BeanMapper.map((Object)((Object)entity), FilingTypeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FilingTypeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FilingTypeVO filingTypeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"queryFilingTypeTop"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryFilingTypeTop() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_children", new Parameter("eq", (Object)0));
        List filingTypeEntities = this.service.queryList(queryParam);
        List voList = BeanMapper.mapList((Iterable)filingTypeEntities, FilingTypeVO.class);
        JSONObject jsonObject = new JSONObject();
        ArrayList list = new ArrayList();
        voList.forEach(vo -> {
            JSONObject o = (JSONObject)JSONObject.toJSON((Object)vo);
            o.put("text", (Object)vo.getFilingTypeName());
            o.put("value", (Object)vo.getId());
            list.add(o);
        });
        jsonObject.put("data", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @ResponseBody
    @RequestMapping(value={"queryFilingByType"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryFilingByType(String innerCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_children", new Parameter("eq", (Object)1));
        queryParam.getParams().put("inner_code", new Parameter("eq", (Object)innerCode));
        List filingTypeEntities = this.service.queryList(queryParam);
        List voList = BeanMapper.mapList((Iterable)filingTypeEntities, FilingTypeVO.class);
        JSONObject jsonObject = new JSONObject();
        ArrayList list = new ArrayList();
        voList.forEach(vo -> {
            JSONObject o = (JSONObject)JSONObject.toJSON((Object)vo);
            o.put("text", (Object)vo.getFilingTypeName());
            o.put("value", (Object)vo.getId());
            list.add(o);
        });
        jsonObject.put("data", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

