/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.business.market.api.IWorkReportApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectInfo"})
public class ProjectInfoController {
    @Autowired
    private IHomePortalService homePortalService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IWorkReportApi workReportApi;

    @RequestMapping(value={"/queryProjectDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryProjectDetail(Long projectDepartmentId) {
        List list;
        CommonResponse commonResponse = this.projectPoolApi.queryProjectListByProjectDepartmentId(projectDepartmentId);
        JSONObject jsonObject = new JSONObject();
        String today = EJCDateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(list = (List)commonResponse.getData()))) {
            ProjectPoolSetVO vo = (ProjectPoolSetVO)list.get(0);
            Long projectId = vo.getProjectId();
            jsonObject = this.homePortalService.queryOutputScale(vo.getId());
            jsonObject.put("projectId", (Object)vo.getId());
            jsonObject.put("projectName", (Object)vo.getName());
            jsonObject.put("constructName", (Object)vo.getConstructName());
            jsonObject.put("designer", (Object)vo.getDesigner());
            jsonObject.put("supervisor", (Object)vo.getSupervisor());
            jsonObject.put("buildUnitName", (Object)vo.getBuildUnitName());
            jsonObject.put("projectManagementPhone", (Object)vo.getProjectManagementPhone());
            String projectDate = null;
            if (vo.getProjectDate() != null) {
                projectDate = EJCDateUtil.format((Date)vo.getProjectDate(), (String)"yyyy-MM-dd");
            }
            jsonObject.put("projectDate", projectDate);
            String ProjectPlanStartDate = null;
            if (vo.getPlanStartDate() != null) {
                ProjectPlanStartDate = EJCDateUtil.format((Date)vo.getPlanStartDate(), (String)"yyyy-MM-dd");
            }
            jsonObject.put("planStartDate", ProjectPlanStartDate);
            String ProjectPlanEndDate = null;
            if (vo.getPlanEndDate() != null) {
                ProjectPlanEndDate = EJCDateUtil.format((Date)vo.getPlanEndDate(), (String)"yyyy-MM-dd");
            }
            jsonObject.put("planEndDate", ProjectPlanEndDate);
            jsonObject.put("areaName", (Object)vo.getAreaName());
            jsonObject.put("address", (Object)vo.getAddress());
            jsonObject.put("businessStatus", (Object)vo.getBusinessStatus());
            Integer surpluday = null;
            if (vo.getPlanEndDate() != null) {
                String planEndDate = EJCDateUtil.format((Date)vo.getPlanEndDate(), (String)"yyyy-MM-dd");
                surpluday = EJCDateUtil.getDayBetween((String)today, (String)planEndDate).size();
            }
            jsonObject.put("surpluday", surpluday);
            BigDecimal workDateProgress = null;
            if (vo.getPlanDateNum() != null && null != vo.getPlanStartDate()) {
                String planStartDate = EJCDateUtil.format((Date)vo.getPlanStartDate(), (String)"yyyy-MM-dd");
                BigDecimal planDateNum = new BigDecimal(vo.getPlanDateNum());
                BigDecimal startDateNum = new BigDecimal(EJCDateUtil.getDayBetween((String)planStartDate, (String)today).size());
                workDateProgress = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)startDateNum, (BigDecimal)planDateNum), (BigDecimal)new BigDecimal(100));
            } else {
                workDateProgress = BigDecimal.ZERO;
            }
            jsonObject.put("workDateProgress", (Object)workDateProgress);
            CommonResponse projectInfoResp = this.workReportApi.getProjectInfo(vo.getId());
            if (!projectInfoResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u9879\u76ee\u72b6\u6001\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONObject projectStatusInfo = (JSONObject)projectInfoResp.getData();
            jsonObject.put("projectStatusName", null != projectStatusInfo.get((Object)"projectStatusName") ? projectStatusInfo.get((Object)"projectStatusName").toString() : null);
            jsonObject.put("businessStatusName", null != projectStatusInfo.get((Object)"businessStatusName") ? projectStatusInfo.get((Object)"businessStatusName").toString() : null);
            jsonObject.put("settleStatusName", null != projectStatusInfo.get((Object)"settleStatusName") ? projectStatusInfo.get((Object)"settleStatusName").toString() : null);
            jsonObject.put("capitalStatusName", null != projectStatusInfo.get((Object)"capitalStatusName") ? projectStatusInfo.get((Object)"capitalStatusName").toString() : null);
            jsonObject.put("archiveStatusName", null != projectStatusInfo.get((Object)"archiveStatusName") ? projectStatusInfo.get((Object)"archiveStatusName").toString() : null);
            jsonObject.put("daysBeforeCostClose", (Object)Integer.valueOf(projectStatusInfo.get((Object)"daysBeforeCostClose").toString()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

